/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.rcp;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.JrxmlEditor;
import com.jaspersoft.studio.rcp.messages.Messages;
import com.jaspersoft.studio.utils.SelectionHelper;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.List;
import net.sf.jasperreports.eclipse.wizard.project.ProjectUtil;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;

public class Startup
implements IStartup {
    private void testRefreshCommand() {
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        service.addExecutionListener(new IExecutionListener(){

            public void postExecuteSuccess(String commandId, Object returnValue) {
                if ("org.eclipse.ui.file.refresh".equals(commandId)) {
                    List editors = SelectionHelper.getOpenedEditors();
                    for (JrxmlEditor editor : editors) {
                        JasperReportsConfiguration jConfig = editor.getJrContext(null);
                        if (jConfig == null) continue;
                        jConfig.refreshClasspath();
                    }
                }
            }

            public void preExecute(String commandId, ExecutionEvent event) {
            }

            public void notHandled(String commandId, NotHandledException exception) {
            }

            public void postExecuteFailure(String commandId, ExecutionException exception) {
            }
        });
    }

    public void earlyStartup() {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyReports");
        NullProgressMonitor monitor = new NullProgressMonitor();
        boolean defaultPrjCreatedOnce = JaspersoftStudioPlugin.getInstance().getPreferenceStore().getBoolean("com.jaspersoft.studio.myreports.created");
        try {
            try {
                if (!project.exists() && !defaultPrjCreatedOnce) {
                    project.create((IProgressMonitor)monitor);
                    project.open((IProgressMonitor)monitor);
                    ProjectUtil.createJRProject((IProgressMonitor)monitor, (IProject)project);
                    IProjectDescription description = project.getDescription();
                    description.setName(Messages.Startup_jss_project);
                    project.setDescription(description, (IProgressMonitor)monitor);
                }
                JaspersoftStudioPlugin.getInstance().getPreferenceStore().setValue("com.jaspersoft.studio.myreports.created", true);
                IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
                registry.setDefaultEditor("*.properties", "com.essiembre.rbe.eclipse.editor.ResourceBundleEditor");
                this.testRefreshCommand();
            }
            catch (CoreException e) {
                e.printStackTrace();
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }
}

