/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.rcp.handlers;

import com.jaspersoft.studio.ConfigurationManager;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.rcp.handlers.LocaleSourceProvider;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.text.MessageFormat;
import java.util.Map;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.FileUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.handlers.RestartWorkbenchHandler;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.services.ISourceProviderService;

public class SwitchLanguageHandler
extends AbstractHandler
implements IElementUpdater {
    private static final String PROP_EXIT_CODE = "eclipse.exitcode";
    private static final String PROP_EXIT_DATA = "eclipse.exitdata";
    private static final String CMD_NL = "-nl";
    private static final String PROP_VM = "eclipse.vm";
    private static final String PROP_VMARGS = "eclipse.vmargs";
    private static final String PROP_COMMANDS = "eclipse.commands";
    private static final String NEW_LINE = "\n";
    private static final String CMD_VMARGS = "-vmargs";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String locale = event.getParameter("com.jaspersoft.studio.switchlanguage.locale");
        boolean needToRestart = ConfigurationManager.changeLocale((String)locale);
        if (needToRestart) {
            MessageDialog dialog = new MessageDialog(UIUtils.getShell(), Messages.SwitchLanguageHandler_restartTitle, null, Messages.SwitchLanguageHandler_restartMessage, 3, new String[]{Messages.common_yes, Messages.common_no}, 1);
            int selection = dialog.open();
            if (selection == 0) {
                System.setProperty(PROP_EXIT_DATA, this.buildCommandLine(locale));
                System.setProperty(PROP_EXIT_CODE, IApplication.EXIT_RELAUNCH.toString());
                return new RestartWorkbenchHandler().execute(event);
            }
            IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
            ISourceProviderService service = (ISourceProviderService)window.getService(ISourceProviderService.class);
            LocaleSourceProvider sessionSourceProvider = (LocaleSourceProvider)service.getSourceProvider("actual_locale");
            sessionSourceProvider.forceRefreshLocale();
            ICommandService commandService = (ICommandService)window.getService(ICommandService.class);
            commandService.refreshElements("com.jaspersoft.studio.switchlanguage.command", null);
        }
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        element.setChecked(LocaleSourceProvider.getLocale().equals(parameters.get("com.jaspersoft.studio.switchlanguage.locale")));
    }

    private String buildCommandLine(String locale) {
        String property = System.getProperty(PROP_VM);
        StringBuffer result = new StringBuffer(512);
        if (property != null) {
            result.append(property);
            result.append(NEW_LINE);
        }
        String vmargs = System.getProperty(PROP_VMARGS);
        property = System.getProperty(PROP_COMMANDS);
        if (property != null) {
            int cmd_nl_pos = property.lastIndexOf(CMD_NL);
            if (cmd_nl_pos != -1) {
                result.append(property.substring(0, cmd_nl_pos += CMD_NL.length() + 1));
                result.append(locale);
                result.append(property.substring(property.indexOf(10, cmd_nl_pos)));
            } else {
                result.append(CMD_NL);
                result.append(NEW_LINE);
                result.append(locale);
                result.append(NEW_LINE);
                result.append(property);
            }
        }
        if (vmargs != null) {
            result.append(CMD_VMARGS);
            result.append(NEW_LINE);
            result.append(vmargs);
        }
        return result.toString();
    }

    private String buildCommandLineFromIni() {
        StringBuffer result;
        block6: {
            File configurationFile = ConfigurationManager.getApplicationConfigurationFile();
            BufferedReader in = null;
            Closeable out = null;
            result = new StringBuffer(512);
            try {
                try {
                    in = new BufferedReader(new FileReader(configurationFile));
                    String line = in.readLine();
                    while (line != null) {
                        result.append(line);
                        result.append(NEW_LINE);
                        line = in.readLine();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    JaspersoftStudioPlugin.getInstance().logError((Throwable)ex);
                    MessageDialog.openWarning((Shell)UIUtils.getShell(), (String)Messages.SwitchLanguageHandler_errorTitle, (String)MessageFormat.format(Messages.SwitchLanguageHandler_errorMessage, configurationFile.getAbsolutePath()));
                    FileUtils.closeStream((Closeable)in);
                    FileUtils.closeStream(out);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                FileUtils.closeStream(in);
                FileUtils.closeStream(out);
                throw throwable;
            }
            FileUtils.closeStream((Closeable)in);
            FileUtils.closeStream(out);
        }
        return result.toString();
    }
}

