/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.samples;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.jasperreports.eclipse.util.BundleCommonUtils;
import net.sf.jasperreports.samples.ISamplesProvider;
import net.sf.jasperreports.samples.messages.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class SamplesManager {
    private List<ISamplesProvider> samplesProviders = new ArrayList<ISamplesProvider>();
    private Set<File> additionalLibraries = null;
    private Set<File> srcFolders = null;
    private Set<File> exampleFolders = null;

    public void init() {
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor("net.sf.jasperreports.samples", "samples");
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                Object o = e.createExecutableExtension("resources");
                if (o instanceof ISamplesProvider) {
                    this.samplesProviders.add((ISamplesProvider)o);
                }
            }
            catch (CoreException ex) {
                BundleCommonUtils.logError((String)"net.sf.jasperreports.samples", (String)Messages.SamplesManager_AddSampleProviderError, (Throwable)ex);
            }
            ++n2;
        }
    }

    public Set<File> getAdditionalLibraries() {
        if (this.additionalLibraries == null) {
            this.additionalLibraries = new HashSet<File>();
            for (ISamplesProvider sp : this.samplesProviders) {
                Set<File> libraries = sp.getAdditionalLibraries();
                if (libraries == null) continue;
                this.additionalLibraries.addAll(libraries);
            }
        }
        return this.additionalLibraries;
    }

    public Set<File> getSourceFolders() {
        if (this.srcFolders == null) {
            this.srcFolders = new HashSet<File>();
            for (ISamplesProvider sp : this.samplesProviders) {
                Set<File> sourceFolders = sp.getSourceFolders();
                if (sourceFolders == null) continue;
                this.srcFolders.addAll(sourceFolders);
            }
        }
        return this.srcFolders;
    }

    public Set<File> getExampleFolders() {
        if (this.exampleFolders == null) {
            this.exampleFolders = new HashSet<File>();
            for (ISamplesProvider sp : this.samplesProviders) {
                Set<File> sampleFolders = sp.getSampleFolders();
                if (sampleFolders == null) continue;
                this.exampleFolders.addAll(sampleFolders);
            }
        }
        return this.exampleFolders;
    }
}

