/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.samples.wizards;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Set;
import net.sf.jasperreports.eclipse.builder.jdt.JDTUtils;
import net.sf.jasperreports.eclipse.classpath.container.JRDependenciesClasspathContainer;
import net.sf.jasperreports.eclipse.wizard.project.JRProjectPage;
import net.sf.jasperreports.eclipse.wizard.project.JRProjectWizard;
import net.sf.jasperreports.samples.Activator;
import net.sf.jasperreports.samples.messages.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbench;

public class SampleNewWizard
extends JRProjectWizard {
    public SampleNewWizard() {
        this.setWindowTitle(Messages.SampleNewWizard_Title);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.init(workbench, selection, new JRProjectPage());
    }

    public void init(IWorkbench workbench, IStructuredSelection selection, JRProjectPage page) {
        this.step1 = page;
        this.step1.setTitle(Messages.SampleNewWizard_Title);
        this.step1.setDescription(Messages.SampleNewWizard_Description);
        this.step1.setName("JasperReportsSamples");
        this.addPage((IWizardPage)this.step1);
    }

    protected void createProject(IProgressMonitor monitor, IProject prj) throws CoreException, FileNotFoundException {
        super.createProject(monitor, prj);
        IJavaProject project = JavaCore.create((IProject)prj);
        IClasspathEntry[] classpathEntries = project.getRawClasspath();
        IClasspathEntry[] newClasspathEntries = new IClasspathEntry[classpathEntries.length + 1];
        System.arraycopy(classpathEntries, 0, newClasspathEntries, 0, classpathEntries.length);
        newClasspathEntries[classpathEntries.length] = JavaCore.newContainerEntry((IPath)JRDependenciesClasspathContainer.ID, (boolean)true);
        project.setRawClasspath(newClasspathEntries, monitor);
        Set<File> libraries = Activator.getSamplesManager().getAdditionalLibraries();
        Set<File> sourceFolders = Activator.getSamplesManager().getSourceFolders();
        Set<File> exampleFolders = Activator.getSamplesManager().getExampleFolders();
        SampleNewWizard.addSourceFolders(sourceFolders, project, monitor);
        SampleNewWizard.addLibraries(libraries, project, monitor);
        SampleNewWizard.addExampleFolders(exampleFolders, project, monitor);
        prj.refreshLocal(2, monitor);
        prj.build(6, monitor);
        prj.close(monitor);
        prj.open(monitor);
    }

    private static void addExampleFolders(Set<File> exampleFolders, IJavaProject project, IProgressMonitor monitor) throws FileNotFoundException, CoreException {
        if (exampleFolders.isEmpty()) {
            return;
        }
        for (File f : exampleFolders) {
            JDTUtils.copyDirectoryToWorkspace((File)f, (IContainer)project.getProject(), (boolean)true);
        }
    }

    private static void addLibraries(Set<File> libraries, IJavaProject project, IProgressMonitor monitor) throws FileNotFoundException, CoreException {
        IResource[] libFiles;
        if (libraries.isEmpty()) {
            return;
        }
        IFolder libFolder = project.getProject().getFolder((IPath)new Path("lib"));
        libFolder.create(true, true, null);
        for (File sf : libraries) {
            JDTUtils.copyFileToWorkspace((File)sf, (IContainer)libFolder);
        }
        IClasspathEntry[] cpentries = project.getRawClasspath();
        IClasspathEntry[] newEntries = new IClasspathEntry[cpentries.length + libraries.size()];
        System.arraycopy(cpentries, 0, newEntries, 0, cpentries.length);
        int i = cpentries.length;
        IResource[] iResourceArray = libFiles = libFolder.members();
        int n = libFiles.length;
        int n2 = 0;
        while (n2 < n) {
            IResource res = iResourceArray[n2];
            newEntries[i] = JavaCore.newLibraryEntry((IPath)res.getLocation(), null, null);
            ++i;
            if (monitor.isCanceled()) {
                return;
            }
            ++n2;
        }
        project.setRawClasspath(newEntries, monitor);
    }

    private static void addSourceFolders(Set<File> sourceFolders, IJavaProject project, IProgressMonitor monitor) throws FileNotFoundException, CoreException {
        if (sourceFolders.isEmpty()) {
            return;
        }
        for (File sf : sourceFolders) {
            JDTUtils.copyDirectoryToWorkspace((File)sf, (IContainer)project.getProject(), (boolean)true);
        }
        IClasspathEntry[] cpentries = project.getRawClasspath();
        IClasspathEntry[] newEntries = new IClasspathEntry[cpentries.length + sourceFolders.size()];
        System.arraycopy(cpentries, 0, newEntries, 0, cpentries.length);
        int i = cpentries.length;
        for (File f : sourceFolders) {
            newEntries[i] = JavaCore.newSourceEntry((IPath)project.getProject().getFolder(f.getName()).getFullPath());
            ++i;
            if (!monitor.isCanceled()) continue;
            return;
        }
        project.setRawClasspath(newEntries, monitor);
    }
}

