/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.csv;

import com.jaspersoft.studio.data.AFileDataAdapterComposite;
import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.DateNumberFormatWidget;
import com.jaspersoft.studio.data.csv.CSVDataAdapterDescriptor;
import com.jaspersoft.studio.data.messages.Messages;
import com.jaspersoft.studio.swt.events.ChangeEvent;
import com.jaspersoft.studio.swt.events.ChangeListener;
import com.jaspersoft.studio.swt.widgets.table.ListContentProvider;
import com.jaspersoft.studio.swt.widgets.table.ListOrderButtons;
import com.jaspersoft.studio.utils.UIUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sf.jasperreports.data.DataAdapter;
import net.sf.jasperreports.data.csv.CsvDataAdapter;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.eclipse.util.StringUtils;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.data.JRCsvDataSource;
import org.eclipse.core.databinding.beans.typed.PojoProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class CSVDataAdapterComposite
extends AFileDataAdapterComposite {
    private Button btnCheckQEMode;
    private TableViewer tableViewer;
    private Table table;
    private Button btnDelete;
    private Button btnCheckSkipFirstLine;
    private Group grpFieldSeparator;
    private Button btnRadioFieldComma;
    private Button btnRadioFieldTab;
    private Button btnRadioFieldNewLineUnix;
    private Button btnRadioFieldSpace;
    private Button btnRadioFieldSemicolon;
    private Button btnRadioFieldOther;
    private Text textFieldOther;
    private Group grpRowSeparator;
    private Button btnRadioRowComma;
    private Button btnRadioRowTab;
    private Button btnRadioRowNewLineUnix;
    private Button btnRadioRowNewLineWin;
    private Button btnRadioRowSpace;
    private Button btnRadioRowSemicolon;
    private Button btnRadioRowOther;
    private Text textRowOther;
    private DateNumberFormatWidget dnf;
    private List<String> rows;
    private Combo cEncoding;

    public CSVDataAdapterComposite(Composite parent, int style, JasperReportsContext jrContext) {
        super(parent, style, jrContext);
        Button[] buttons;
        this.setLayout((Layout)new GridLayout(1, false));
        this.rows = new ArrayList<String>();
        Composite composite = new Composite((Composite)this, 0);
        GridLayout gl_composite = new GridLayout(3, false);
        gl_composite.marginHeight = 0;
        composite.setLayout((Layout)gl_composite);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.createFileNameWidgets(composite);
        this.btnCheckQEMode = new Button((Composite)this, 32);
        this.btnCheckQEMode.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnCheckQEMode.setText(Messages.CSVDataAdapterComposite_2);
        Composite composite_1 = new Composite((Composite)this, 0);
        GridLayout gl_composite_1 = new GridLayout(1, false);
        gl_composite_1.marginWidth = 0;
        gl_composite_1.marginHeight = 0;
        composite_1.setLayout((Layout)gl_composite_1);
        composite_1.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        CTabFolder tabFolder = new CTabFolder(composite_1, 0);
        tabFolder.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        tabFolder.setSelectionBackground(Display.getDefault().getSystemColor(35));
        CTabItem tbtmColumns = new CTabItem(tabFolder, 0);
        tbtmColumns.setText(Messages.CSVDataAdapterComposite_3);
        tabFolder.setSelection(0);
        Composite composite_2 = new Composite((Composite)tabFolder, 0);
        tbtmColumns.setControl((Control)composite_2);
        composite_2.setLayout((Layout)new GridLayout(1, false));
        Group grpColumnNames = new Group(composite_2, 0);
        grpColumnNames.setText(Messages.CSVDataAdapterComposite_4);
        grpColumnNames.setLayout((Layout)new GridLayout(1, false));
        grpColumnNames.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Button btnGetCSVColumnsName = new Button((Composite)grpColumnNames, 0);
        btnGetCSVColumnsName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        btnGetCSVColumnsName.setText(Messages.CSVDataAdapterComposite_5);
        Composite composite_3 = new Composite((Composite)grpColumnNames, 0);
        GridLayout gl_composite_3 = new GridLayout(2, false);
        gl_composite_3.marginWidth = 0;
        gl_composite_3.marginHeight = 0;
        composite_3.setLayout((Layout)gl_composite_3);
        GridData gdComposite3 = new GridData(4, 4, true, true);
        gdComposite3.heightHint = 150;
        composite_3.setLayoutData((Object)gdComposite3);
        composite_3.setBounds(0, 0, 64, 64);
        this.table = new Table(composite_3, 68098);
        GridData gd = new GridData(1808);
        gd.widthHint = 100;
        this.table.setLayoutData((Object)gd);
        this.table.setHeaderVisible(true);
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, false));
        this.table.setLayout((Layout)tlayout);
        this.tableViewer = new TableViewer(this.table);
        TableViewerColumn vcol = new TableViewerColumn(this.tableViewer, 0);
        TableColumn col = vcol.getColumn();
        col.setText(Messages.CSVDataAdapterComposite_6);
        this.tableViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        vcol.setEditingSupport(new EditingSupport((ColumnViewer)this.tableViewer){

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)CSVDataAdapterComposite.this.tableViewer.getTable());
            }

            protected boolean canEdit(Object element) {
                return true;
            }

            protected Object getValue(Object element) {
                return element;
            }

            protected void setValue(Object element, Object value) {
                int s = CSVDataAdapterComposite.this.table.getSelectionIndex();
                List lstr = (List)CSVDataAdapterComposite.this.tableViewer.getInput();
                if (s >= 0 && s < lstr.size()) {
                    lstr.set(s, (String)value);
                }
                CSVDataAdapterComposite.this.tableViewer.refresh(true);
            }
        });
        this.tableViewer.setInput(this.rows);
        Composite composite_4 = new Composite(composite_3, 0);
        GridLayout gl_composite_4 = new GridLayout(1, false);
        gl_composite_4.marginWidth = 0;
        gl_composite_4.marginHeight = 0;
        composite_4.setLayout((Layout)gl_composite_4);
        composite_4.setLayoutData((Object)new GridData(4, 4, false, true, 1, 1));
        Button btnAdd = new Button(composite_4, 0);
        GridData gd_btnAdd = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_btnAdd.widthHint = 100;
        btnAdd.setLayoutData((Object)gd_btnAdd);
        btnAdd.setText(Messages.CSVDataAdapterComposite_7);
        this.btnDelete = new Button(composite_4, 0);
        GridData gd_btnDelete = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_btnDelete.widthHint = 100;
        this.btnDelete.setLayoutData((Object)gd_btnDelete);
        this.btnDelete.setText(Messages.CSVDataAdapterComposite_8);
        this.btnDelete.setEnabled(false);
        ListOrderButtons lb = new ListOrderButtons();
        lb.createOrderButtons(composite_4, this.tableViewer);
        lb.addChangeListener(new ChangeListener(){

            public void changed(ChangeEvent event) {
                CSVDataAdapterComposite.this.pchangesuport.firePropertyChange("dirty", false, true);
            }
        });
        Group grpOther = new Group(composite_2, 0);
        grpOther.setText(Messages.CSVDataAdapterComposite_9);
        grpOther.setLayout((Layout)new GridLayout(3, false));
        grpOther.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.dnf = new DateNumberFormatWidget((Composite)grpOther);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.dnf.setLayoutData(gd);
        this.btnCheckSkipFirstLine = new Button((Composite)grpOther, 32);
        this.btnCheckSkipFirstLine.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        this.btnCheckSkipFirstLine.setText(Messages.CSVDataAdapterComposite_14);
        Label lbl = new Label((Composite)grpOther, 0);
        lbl.setText(Messages.CSVDataAdapterComposite_37);
        lbl.setLayoutData((Object)new GridData(128));
        this.cEncoding = new Combo((Composite)grpOther, 2052);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.cEncoding.setItems(StringUtils.getEncodings());
        this.cEncoding.setLayoutData((Object)gd);
        CTabItem tbtmSeparators = new CTabItem(tabFolder, 0);
        tbtmSeparators.setText(Messages.CSVDataAdapterComposite_15);
        Composite composite_5 = new Composite((Composite)tabFolder, 0);
        tbtmSeparators.setControl((Control)composite_5);
        composite_5.setLayout((Layout)new GridLayout(1, false));
        this.grpFieldSeparator = new Group(composite_5, 0);
        this.grpFieldSeparator.setText(Messages.CSVDataAdapterComposite_16);
        this.grpFieldSeparator.setLayout((Layout)new GridLayout(3, true));
        this.grpFieldSeparator.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.grpFieldSeparator.setBounds(0, 0, 70, 82);
        this.btnRadioFieldComma = new Button((Composite)this.grpFieldSeparator, 16);
        this.btnRadioFieldComma.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnRadioFieldComma.setText(Messages.CSVDataAdapterComposite_17);
        this.btnRadioFieldTab = new Button((Composite)this.grpFieldSeparator, 16);
        this.btnRadioFieldTab.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnRadioFieldTab.setText(Messages.CSVDataAdapterComposite_18);
        this.btnRadioFieldNewLineUnix = new Button((Composite)this.grpFieldSeparator, 16);
        this.btnRadioFieldNewLineUnix.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnRadioFieldNewLineUnix.setText(Messages.CSVDataAdapterComposite_19);
        this.btnRadioFieldSpace = new Button((Composite)this.grpFieldSeparator, 16);
        this.btnRadioFieldSpace.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnRadioFieldSpace.setText(Messages.CSVDataAdapterComposite_20);
        this.btnRadioFieldSemicolon = new Button((Composite)this.grpFieldSeparator, 16);
        this.btnRadioFieldSemicolon.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnRadioFieldSemicolon.setText(Messages.CSVDataAdapterComposite_21);
        Composite fieldComposite = new Composite((Composite)this.grpFieldSeparator, 0);
        fieldComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        GridLayout gl_composite_6 = new GridLayout(2, false);
        gl_composite_6.marginWidth = 0;
        gl_composite_6.marginHeight = 0;
        fieldComposite.setLayout((Layout)gl_composite_6);
        this.btnRadioFieldOther = new Button(fieldComposite, 16);
        this.btnRadioFieldOther.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnRadioFieldOther.setText(Messages.CSVDataAdapterComposite_22);
        this.textFieldOther = new Text(fieldComposite, 2048);
        this.textFieldOther.setLayoutData((Object)new GridData(768));
        this.textFieldOther.setEnabled(false);
        this.textFieldOther.setTextLimit(1);
        this.grpRowSeparator = new Group(composite_5, 0);
        this.grpRowSeparator.setText(Messages.CSVDataAdapterComposite_23);
        this.grpRowSeparator.setLayout((Layout)new GridLayout(3, true));
        this.grpRowSeparator.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnRadioRowComma = new Button((Composite)this.grpRowSeparator, 16);
        this.btnRadioRowComma.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnRadioRowComma.setText(Messages.CSVDataAdapterComposite_24);
        this.btnRadioRowTab = new Button((Composite)this.grpRowSeparator, 16);
        this.btnRadioRowTab.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnRadioRowTab.setText(Messages.CSVDataAdapterComposite_25);
        this.btnRadioRowNewLineUnix = new Button((Composite)this.grpRowSeparator, 16);
        this.btnRadioRowNewLineUnix.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnRadioRowNewLineUnix.setText(Messages.CSVDataAdapterComposite_26);
        this.btnRadioRowNewLineWin = new Button((Composite)this.grpRowSeparator, 16);
        this.btnRadioRowNewLineWin.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnRadioRowNewLineWin.setText(Messages.CSVDataAdapterComposite_27);
        this.btnRadioRowSpace = new Button((Composite)this.grpRowSeparator, 16);
        this.btnRadioRowSpace.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnRadioRowSpace.setText(Messages.CSVDataAdapterComposite_28);
        this.btnRadioRowSemicolon = new Button((Composite)this.grpRowSeparator, 16);
        this.btnRadioRowSemicolon.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnRadioRowSemicolon.setText(Messages.CSVDataAdapterComposite_29);
        Composite rowComposite = new Composite((Composite)this.grpRowSeparator, 0);
        rowComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        GridLayout gl_composite_7 = new GridLayout(2, false);
        gl_composite_7.marginWidth = 0;
        gl_composite_7.marginHeight = 0;
        rowComposite.setLayout((Layout)gl_composite_7);
        this.btnRadioRowOther = new Button(rowComposite, 16);
        this.btnRadioRowOther.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnRadioRowOther.setText(Messages.CSVDataAdapterComposite_30);
        this.textRowOther = new Text(rowComposite, 2048);
        gd = new GridData();
        gd.widthHint = 100;
        this.textRowOther.setLayoutData((Object)gd);
        this.textRowOther.setEnabled(false);
        new Label((Composite)this.grpRowSeparator, 0);
        new Label((Composite)this.grpRowSeparator, 0);
        Group grpSpecialCharacters = new Group(composite_5, 0);
        grpSpecialCharacters.setText(Messages.CSVDataAdapterComposite_31);
        grpSpecialCharacters.setLayout((Layout)new GridLayout(4, false));
        grpSpecialCharacters.setLayoutData((Object)new GridData(1808));
        lbl = new Label((Composite)grpSpecialCharacters, 1);
        lbl.setText("\\n");
        UIUtil.setBold((Control)lbl);
        new Label((Composite)grpSpecialCharacters, 0).setText(Messages.CSVDataAdapterComposite_32);
        lbl = new Label((Composite)grpSpecialCharacters, 1);
        lbl.setText("\\r");
        UIUtil.setBold((Control)lbl);
        Label text_b = new Label((Composite)grpSpecialCharacters, 0);
        text_b.setText(Messages.CSVDataAdapterComposite_33);
        lbl = new Label((Composite)grpSpecialCharacters, 1);
        lbl.setText("\\r\\n");
        UIUtil.setBold((Control)lbl);
        Label text_c = new Label((Composite)grpSpecialCharacters, 0);
        text_c.setText(Messages.CSVDataAdapterComposite_34);
        gd = new GridData();
        gd.widthHint = 250;
        text_c.setLayoutData((Object)gd);
        lbl = new Label((Composite)grpSpecialCharacters, 1);
        lbl.setText("\\t");
        UIUtil.setBold((Control)lbl);
        Label text_d = new Label((Composite)grpSpecialCharacters, 0);
        text_d.setText(Messages.CSVDataAdapterComposite_35);
        lbl = new Label((Composite)grpSpecialCharacters, 1);
        lbl.setText("\\\\");
        UIUtil.setBold((Control)lbl);
        Label text_e = new Label((Composite)grpSpecialCharacters, 0);
        text_e.setText(Messages.CSVDataAdapterComposite_36);
        new Label((Composite)grpSpecialCharacters, 0);
        btnGetCSVColumnsName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    CSVDataAdapterComposite.this.getCSVColumns();
                }
                catch (IOException e1) {
                    UIUtils.showError((Throwable)e1);
                }
                catch (Exception e2) {
                    UIUtils.showError((Throwable)e2);
                }
            }
        });
        btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CSVDataAdapterComposite.this.rows.add(CSVDataAdapterComposite.this.createDataModelEntry());
                if (CSVDataAdapterComposite.this.rows.size() == 1) {
                    CSVDataAdapterComposite.this.btnDelete.setEnabled(true);
                }
                CSVDataAdapterComposite.this.tableViewer.refresh();
                CSVDataAdapterComposite.this.setTableSelection(-1);
                CSVDataAdapterComposite.this.pchangesuport.firePropertyChange("dirty", false, true);
            }
        });
        this.btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CSVDataAdapterComposite.this.removeEntries();
            }
        });
        this.table.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u007f') {
                    CSVDataAdapterComposite.this.removeEntries();
                }
            }
        });
        this.tableViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (CSVDataAdapterComposite.this.rows.size() <= 0) {
                    CSVDataAdapterComposite.this.btnDelete.setEnabled(false);
                    CSVDataAdapterComposite.this.btnCheckSkipFirstLine.setSelection(false);
                } else {
                    CSVDataAdapterComposite.this.btnDelete.setEnabled(true);
                }
            }
        });
        Button[] buttonArray = buttons = new Button[]{this.btnRadioFieldComma, this.btnRadioFieldNewLineUnix, this.btnRadioFieldSemicolon, this.btnRadioFieldSpace, this.btnRadioFieldTab, this.btnRadioFieldOther, this.btnRadioRowComma, this.btnRadioRowNewLineUnix, this.btnRadioRowNewLineWin, this.btnRadioRowSemicolon, this.btnRadioRowSpace, this.btnRadioRowTab, this.btnRadioRowOther};
        int n = buttons.length;
        int n2 = 0;
        while (n2 < n) {
            Button button = buttonArray[n2];
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CSVDataAdapterComposite.this.enableOtherButton((Button)e.widget);
                }
            });
            ++n2;
        }
    }

    protected void bindWidgets(DataAdapter dataAdapter) {
        this.doBindFileNameWidget(dataAdapter);
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)this.btnCheckQEMode), PojoProperties.value((String)"queryExecuterMode").observe((Object)dataAdapter));
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)this.btnCheckSkipFirstLine), PojoProperties.value((String)"useFirstRowAsHeader").observe((Object)dataAdapter));
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)this.cEncoding), PojoProperties.value((String)"encoding").observe((Object)dataAdapter));
        CsvDataAdapter csvDataAdapter = (CsvDataAdapter)dataAdapter;
        List listColumnNames = csvDataAdapter.getColumnNames();
        if (listColumnNames != null && listColumnNames.size() > 0) {
            for (String str : listColumnNames) {
                this.rows.add(str);
            }
            this.tableViewer.refresh();
            this.setTableSelection(-1);
            this.btnDelete.setEnabled(true);
        }
        this.dnf.bindWidgets((DataAdapter)csvDataAdapter, this.bindingContext, csvDataAdapter.getLocale(), csvDataAdapter.getTimeZone());
        Proxy proxy = new Proxy(csvDataAdapter);
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)this.btnRadioFieldComma), PojoProperties.value((String)"fieldComma").observe((Object)proxy));
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)this.btnRadioFieldTab), PojoProperties.value((String)"fieldTab").observe((Object)proxy));
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)this.btnRadioFieldSpace), PojoProperties.value((String)"fieldSpace").observe((Object)proxy));
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)this.btnRadioFieldSemicolon), PojoProperties.value((String)"fieldSemicolon").observe((Object)proxy));
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)this.btnRadioFieldNewLineUnix), PojoProperties.value((String)"fieldNewLineUnix").observe((Object)proxy));
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.textFieldOther), PojoProperties.value((String)"fieldDelimiter").observe((Object)proxy));
        String fieldDelimiter = csvDataAdapter.getFieldDelimiter();
        if (fieldDelimiter != null) {
            if (",".equals(fieldDelimiter)) {
                this.btnRadioFieldComma.setSelection(true);
            } else if ("\t".equals(fieldDelimiter)) {
                this.btnRadioFieldTab.setSelection(true);
            } else if (" ".equals(fieldDelimiter)) {
                this.btnRadioFieldSpace.setSelection(true);
            } else if (";".equals(fieldDelimiter)) {
                this.btnRadioFieldSemicolon.setSelection(true);
            } else if ("\n".equals(fieldDelimiter)) {
                this.btnRadioFieldNewLineUnix.setSelection(true);
            } else {
                this.btnRadioFieldOther.setSelection(true);
                this.textFieldOther.setText(Misc.addSlashesString((String)fieldDelimiter));
                this.textFieldOther.setEnabled(true);
            }
        }
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)this.btnRadioRowComma), PojoProperties.value((String)"rowComma").observe((Object)proxy));
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)this.btnRadioRowTab), PojoProperties.value((String)"rowTab").observe((Object)proxy));
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)this.btnRadioRowSpace), PojoProperties.value((String)"rowSpace").observe((Object)proxy));
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)this.btnRadioRowSemicolon), PojoProperties.value((String)"rowSemicolon").observe((Object)proxy));
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)this.btnRadioRowNewLineUnix), PojoProperties.value((String)"rowNewLineUnix").observe((Object)proxy));
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)this.btnRadioRowNewLineWin), PojoProperties.value((String)"rowNewLineWin").observe((Object)proxy));
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.textRowOther), PojoProperties.value((String)"recordDelimiter").observe((Object)proxy));
        String recordDelimitier = csvDataAdapter.getRecordDelimiter();
        if (recordDelimitier != null) {
            if (",".equals(recordDelimitier)) {
                this.btnRadioRowComma.setSelection(true);
            } else if ("\t".equals(recordDelimitier)) {
                this.btnRadioRowTab.setSelection(true);
            } else if (" ".equals(recordDelimitier)) {
                this.btnRadioRowSpace.setSelection(true);
            } else if (";".equals(recordDelimitier)) {
                this.btnRadioRowSemicolon.setSelection(true);
            } else if ("\n".equals(recordDelimitier)) {
                this.btnRadioRowNewLineUnix.setSelection(true);
            } else if ("\r\n".equals(recordDelimitier)) {
                this.btnRadioRowNewLineWin.setSelection(true);
            } else {
                this.btnRadioRowOther.setSelection(true);
                this.textRowOther.setText(Misc.addSlashesString((String)recordDelimitier));
                this.textRowOther.setEnabled(true);
            }
        }
    }

    public DataAdapterDescriptor getDataAdapter() {
        if (this.dataAdapterDesc == null) {
            this.dataAdapterDesc = new CSVDataAdapterDescriptor();
        }
        CsvDataAdapter csvDataAdapter = (CsvDataAdapter)this.dataAdapterDesc.getDataAdapter();
        csvDataAdapter.setQueryExecuterMode(this.btnCheckQEMode.getSelection());
        csvDataAdapter.setUseFirstRowAsHeader(this.btnCheckSkipFirstLine.getSelection());
        csvDataAdapter.setColumnNames(this.rows);
        csvDataAdapter.setDatePattern(this.dnf.getTextDatePattern());
        csvDataAdapter.setNumberPattern(this.dnf.getTextNumberPattern());
        csvDataAdapter.setLocale(this.dnf.getLocale());
        csvDataAdapter.setTimeZone(this.dnf.getTimeZone());
        if (this.btnRadioFieldComma.getSelection()) {
            csvDataAdapter.setFieldDelimiter(",");
        } else if (this.btnRadioFieldTab.getSelection()) {
            csvDataAdapter.setFieldDelimiter("\t");
        } else if (this.btnRadioFieldSpace.getSelection()) {
            csvDataAdapter.setFieldDelimiter(" ");
        } else if (this.btnRadioFieldSemicolon.getSelection()) {
            csvDataAdapter.setFieldDelimiter(";");
        } else if (this.btnRadioFieldNewLineUnix.getSelection()) {
            csvDataAdapter.setFieldDelimiter("\n");
        } else if (this.btnRadioFieldOther.getSelection()) {
            csvDataAdapter.setFieldDelimiter(Misc.removeSlashesString((String)(String.valueOf(this.textFieldOther.getText()) + " ")));
        }
        if (csvDataAdapter.getFieldDelimiter() == null || csvDataAdapter.getFieldDelimiter().isEmpty()) {
            csvDataAdapter.setFieldDelimiter(";");
        }
        if (this.btnRadioRowComma.getSelection()) {
            csvDataAdapter.setRecordDelimiter(",");
        } else if (this.btnRadioRowTab.getSelection()) {
            csvDataAdapter.setRecordDelimiter("\t");
        } else if (this.btnRadioRowSpace.getSelection()) {
            csvDataAdapter.setRecordDelimiter(" ");
        } else if (this.btnRadioRowSemicolon.getSelection()) {
            csvDataAdapter.setRecordDelimiter(";");
        } else if (this.btnRadioRowNewLineUnix.getSelection()) {
            csvDataAdapter.setRecordDelimiter("\n");
        } else if (this.btnRadioRowNewLineWin.getSelection()) {
            csvDataAdapter.setRecordDelimiter("\r\n");
        } else if (this.btnRadioRowOther.getSelection()) {
            csvDataAdapter.setRecordDelimiter(Misc.removeSlashesString((String)this.textRowOther.getText()));
        }
        return this.dataAdapterDesc;
    }

    private String createDataModelEntry() {
        int i = 0;
        StringBuffer column = new StringBuffer("COLUMN_" + i);
        while (!this.isColumnValid(column.toString())) {
            column.setLength(0);
            column.append("COLUMN_" + ++i);
        }
        return column.toString();
    }

    private void removeEntries() {
        int[] indices = this.table.getSelectionIndices();
        if (indices.length > 0) {
            ArrayList<String> toDel = new ArrayList<String>();
            int i = 0;
            while (i < indices.length) {
                toDel.add(this.rows.get(indices[i]));
                ++i;
            }
            this.rows.removeAll(toDel);
            this.tableViewer.refresh();
            this.setTableSelection(indices[0]);
            this.pchangesuport.firePropertyChange("dirty", false, true);
        }
    }

    private void setTableSelection(int index) {
        if (this.rows != null && this.rows.size() > 0) {
            if (index == 0) {
                this.table.setSelection(index);
            } else if (index > 0 && index < this.rows.size() - 1) {
                this.table.setSelection(index - 1);
            } else {
                this.table.setSelection(this.rows.size() - 1);
            }
        }
    }

    private void enableOtherButton(Button button) {
        if (this.btnRadioFieldOther.equals(button)) {
            this.textFieldOther.setEnabled(true);
            this.btnRadioFieldComma.setSelection(false);
            this.btnRadioFieldNewLineUnix.setSelection(false);
            this.btnRadioFieldSemicolon.setSelection(false);
            this.btnRadioFieldSpace.setSelection(false);
            this.btnRadioFieldTab.setSelection(false);
        } else if (this.btnRadioRowOther.equals(button)) {
            this.textRowOther.setEnabled(true);
            this.btnRadioRowComma.setSelection(false);
            this.btnRadioRowNewLineUnix.setSelection(false);
            this.btnRadioRowNewLineWin.setSelection(false);
            this.btnRadioRowSemicolon.setSelection(false);
            this.btnRadioRowSpace.setSelection(false);
            this.btnRadioRowTab.setSelection(false);
        } else if (this.grpFieldSeparator.equals(button.getParent())) {
            this.btnRadioFieldOther.setSelection(false);
            this.textFieldOther.setEnabled(false);
        } else if (this.grpRowSeparator.equals(button.getParent())) {
            this.btnRadioRowOther.setSelection(false);
            this.textRowOther.setEnabled(false);
        }
    }

    @Override
    protected void fireFileChanged(boolean showWarning) {
        try {
            super.fireFileChanged(showWarning);
            if (showWarning) {
                if (UIUtils.showConfirmation((String)Messages.CSVDataAdapterComposite_0, (String)Messages.CSVDataAdapterComposite_1)) {
                    this.getCSVColumns();
                }
            } else {
                this.getCSVColumns();
            }
        }
        catch (IOException e) {
            UIUtils.showError((Throwable)e);
        }
        catch (Exception e) {
            UIUtils.showError((Throwable)e);
        }
    }

    private void getCSVColumns() throws IOException, Exception {
        if (Misc.isNullOrEmpty((String)this.textFileName.getText())) {
            return;
        }
        JRCsvDataSource ds = new JRCsvDataSource(this.getJrContext(), this.textFileName.getText());
        ds.setUseFirstRowAsHeader(true);
        if (this.btnRadioFieldComma.getSelection()) {
            ds.setFieldDelimiter(',');
        } else if (this.btnRadioFieldTab.getSelection()) {
            ds.setFieldDelimiter('\t');
        } else if (this.btnRadioFieldSpace.getSelection()) {
            ds.setFieldDelimiter(' ');
        } else if (this.btnRadioFieldSemicolon.getSelection()) {
            ds.setFieldDelimiter(';');
        } else if (this.btnRadioFieldNewLineUnix.getSelection()) {
            ds.setFieldDelimiter('\n');
        } else if (this.btnRadioFieldOther.getSelection()) {
            ds.setFieldDelimiter(Misc.removeSlashesString((String)(String.valueOf(this.textFieldOther.getText()) + " ")).charAt(0));
        } else if (ds.getFieldDelimiter() == ' ') {
            ds.setFieldDelimiter(';');
        }
        if (this.btnRadioRowComma.getSelection()) {
            ds.setRecordDelimiter(",");
        } else if (this.btnRadioRowTab.getSelection()) {
            ds.setRecordDelimiter("\t");
        } else if (this.btnRadioRowSpace.getSelection()) {
            ds.setRecordDelimiter(" ");
        } else if (this.btnRadioRowSemicolon.getSelection()) {
            ds.setRecordDelimiter(";");
        } else if (this.btnRadioRowNewLineUnix.getSelection()) {
            ds.setRecordDelimiter("\n");
        } else if (this.btnRadioRowNewLineWin.getSelection()) {
            ds.setRecordDelimiter("\r\n");
        } else if (this.btnRadioRowOther.getSelection()) {
            ds.setRecordDelimiter(Misc.removeSlashesString((String)this.textRowOther.getText()));
        } else if (ds.getRecordDelimiter().equals("")) {
            ds.setRecordDelimiter("\n");
        }
        this.rows.clear();
        ds.next();
        Map names = ds.getColumnNames();
        if (names != null) {
            TreeMap<Integer, String> map = new TreeMap<Integer, String>();
            for (Map.Entry entry : names.entrySet()) {
                map.put((Integer)entry.getValue(), (String)entry.getKey());
            }
            for (Map.Entry entry : map.entrySet()) {
                this.rows.add((String)entry.getValue());
            }
        }
        this.tableViewer.refresh();
        this.setTableSelection(-1);
        this.btnDelete.setEnabled(true);
        this.pchangesuport.firePropertyChange("dirty", false, true);
        ds.close();
    }

    private boolean isColumnValid(String column) {
        if (column == null || "".equals(column)) {
            return false;
        }
        for (String row : this.rows) {
            if (!row.equals(column)) continue;
            return false;
        }
        return true;
    }

    public String getHelpContextId() {
        return "com.jaspersoft.studio.doc.".concat("adapter_csv");
    }

    @Override
    protected String[] getFileExtensions() {
        return new String[]{"*.csv", "*.*"};
    }

    class Proxy {
        private CsvDataAdapter da;

        public Proxy(CsvDataAdapter da) {
            this.da = da;
        }

        public boolean isFieldComma() {
            return this.da.getFieldDelimiter() != null && this.da.getFieldDelimiter().equals(",");
        }

        public void setFieldComma(boolean b) {
            this.da.setFieldDelimiter(",");
        }

        public boolean isFieldTab() {
            return this.da.getFieldDelimiter() != null && this.da.getFieldDelimiter().equals("\t");
        }

        public void setFieldTab(boolean b) {
            this.da.setFieldDelimiter("\t");
        }

        public boolean isFieldSpace() {
            return this.da.getFieldDelimiter() != null && this.da.getFieldDelimiter().equals(" ");
        }

        public void setFieldSpace(boolean b) {
            this.da.setFieldDelimiter(" ");
        }

        public boolean isFieldSemicolon() {
            return this.da.getFieldDelimiter() != null && this.da.getFieldDelimiter().equals(";");
        }

        public void setFieldSemicolon(boolean b) {
            this.da.setFieldDelimiter(";");
        }

        public boolean isFieldNewLineUnix() {
            return this.da.getFieldDelimiter() != null && this.da.getFieldDelimiter().equals("\n");
        }

        public void setFieldNewLineUnix(boolean b) {
            this.da.setFieldDelimiter("\n");
        }

        public boolean isRowComma() {
            return this.da.getRecordDelimiter() != null && this.da.getRecordDelimiter().equals(",");
        }

        public void setRowComma(boolean b) {
            this.da.setRecordDelimiter(",");
        }

        public boolean isRowTab() {
            return this.da.getRecordDelimiter() != null && this.da.getRecordDelimiter().equals("\t");
        }

        public void setRowTab(boolean b) {
            this.da.setRecordDelimiter("\t");
        }

        public boolean isRowSpace() {
            return this.da.getRecordDelimiter() != null && this.da.getRecordDelimiter().equals(" ");
        }

        public void setRowSpace(boolean b) {
            this.da.setRecordDelimiter(" ");
        }

        public boolean isRowSemicolon() {
            return this.da.getRecordDelimiter() != null && this.da.getRecordDelimiter().equals(";");
        }

        public void setRowSemicolon(boolean b) {
            this.da.setRecordDelimiter(";");
        }

        public boolean isRowNewLineUnix() {
            return this.da.getRecordDelimiter() != null && this.da.getRecordDelimiter().equals("\n");
        }

        public void setRowNewLineUnix(boolean b) {
            this.da.setRecordDelimiter("\n");
        }

        public boolean isRowNewLineWin() {
            return this.da.getRecordDelimiter() != null && this.da.getRecordDelimiter().equals("\r\n");
        }

        public void setRowNewLineWin(boolean b) {
            this.da.setRecordDelimiter("\r\n");
        }
    }
}

