/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.querydesigner.json;

import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.designer.tree.NodeBoldStyledLabelProvider;
import com.jaspersoft.studio.data.designer.tree.TreeBasedQueryDesigner;
import com.jaspersoft.studio.data.messages.Messages;
import com.jaspersoft.studio.data.querydesigner.json.JsonDataManager;
import com.jaspersoft.studio.data.querydesigner.json.JsonLineStyler;
import com.jaspersoft.studio.data.querydesigner.json.JsonTreeContentProvider;
import com.jaspersoft.studio.data.querydesigner.json.JsonTreeCustomStatus;
import com.jaspersoft.studio.data.querydesigner.xpath.XMLTreeCustomStatus;
import com.jaspersoft.studio.dnd.NodeDragListener;
import com.jaspersoft.studio.dnd.NodeTransfer;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.datasource.json.JsonSupportNode;
import com.jaspersoft.studio.wizards.ContextHelpIDs;
import net.sf.jasperreports.data.DataFile;
import net.sf.jasperreports.data.json.JsonDataAdapter;
import net.sf.jasperreports.data.json.JsonExpressionLanguageEnum;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRDataset;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.progress.UIJob;

public class JsonQueryDesigner
extends TreeBasedQueryDesigner {
    private static final int JOB_DELAY = 300;
    private JsonDataManager jsonDataManager = new JsonDataManager(this.getLanguage());
    private DecorateTreeViewerJob decorateJob;
    private JsonLoaderJob jsonLoaderJob;
    private NodeBoldStyledLabelProvider<JsonSupportNode> treeLabelProvider;
    private JsonLineStyler lineStyler = new JsonLineStyler();
    private Composite toolbarComposite;

    public JsonQueryDesigner() {
        this.decorateJob = new DecorateTreeViewerJob();
        this.jsonLoaderJob = new JsonLoaderJob();
        this.treeLabelProvider = new NodeBoldStyledLabelProvider();
    }

    protected String getLanguage() {
        return JsonExpressionLanguageEnum.JSON.getName();
    }

    public Control createToolbar(Composite parent) {
        if (this.showAdditionalInfo()) {
            this.toolbarComposite = new Composite(parent, 0);
            this.toolbarComposite.setBackgroundMode(2);
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.toolbarComposite.setLayout((Layout)layout);
            this.toolbarComposite.setLayoutData((Object)new GridData(4, 4, true, false));
            Button btn = new Button(this.toolbarComposite, 8);
            btn.setText(Messages.JsonQueryDesigner_ReadFieldsBtn);
            btn.setLayoutData((Object)new GridData(131072, 4, true, false));
            btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    JsonQueryDesigner.this.container.doGetFields();
                }
            });
            return this.toolbarComposite;
        }
        return null;
    }

    public Control getToolbarControl() {
        return this.toolbarComposite;
    }

    public Control createControl(Composite parent) {
        Control createdControl = super.createControl(parent);
        this.queryTextArea.addLineStyleListener((LineStyleListener)this.lineStyler);
        return createdControl;
    }

    protected void createTreeViewer(Composite parent) {
        super.createTreeViewer(parent);
        if (this.showAdditionalInfo()) {
            this.addDragSupport();
            this.createContextualMenu();
        }
        this.addDoubleClickSupport();
    }

    protected IBaseLabelProvider getTreeLabelProvider() {
        return this.treeLabelProvider;
    }

    protected IContentProvider getTreeContentProvider() {
        return new JsonTreeContentProvider();
    }

    protected void decorateTreeUsingQueryText() {
        if (this.jsonDataManager.getJsonSupportModel() != null) {
            this.decorateJob.cancel();
            this.decorateJob.schedule(300L);
        }
    }

    private boolean showAdditionalInfo() {
        return this.container.getContainerType() == 2;
    }

    private void addDoubleClickSupport() {
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TreeSelection s = (TreeSelection)JsonQueryDesigner.this.treeViewer.getSelection();
                if (s.getFirstElement() instanceof JsonSupportNode) {
                    JsonSupportNode jsonNode = (JsonSupportNode)s.getFirstElement();
                    String queryExpression = JsonQueryDesigner.this.jsonDataManager.getQueryExpression(null, jsonNode);
                    JsonQueryDesigner.this.queryTextArea.setText(queryExpression);
                }
            }
        });
    }

    protected void refreshTreeViewerContent(DataAdapterDescriptor da) {
        if (!this.isRefreshing) {
            this.container.getQueryStatus().showInfo("");
            this.treeViewer.setInput((Object)JsonTreeCustomStatus.LOADING_JSON);
            if (da != null && da.getDataAdapter() instanceof JsonDataAdapter) {
                this.jsonLoaderJob.updateDataFile(((JsonDataAdapter)da.getDataAdapter()).getDataFile());
                this.jsonLoaderJob.schedule();
            } else {
                this.treeViewer.getTree().removeAll();
                this.treeViewer.setInput((Object)JsonTreeCustomStatus.FILE_NOT_FOUND);
                this.isRefreshing = false;
            }
        }
    }

    private void addDragSupport() {
        int ops = 3;
        Transfer[] transfers = new Transfer[]{NodeTransfer.getInstance(), PluginTransfer.getInstance()};
        this.treeViewer.addDragSupport(ops, transfers, (DragSourceListener)new NodeDragListener((StructuredViewer)this.treeViewer){

            public void dragStart(DragSourceEvent event) {
                TreeSelection s = (TreeSelection)JsonQueryDesigner.this.treeViewer.getSelection();
                if (s.getFirstElement() instanceof JsonSupportNode) {
                    JsonSupportNode jsonNode = (JsonSupportNode)s.getFirstElement();
                    jsonNode.setExpression(JsonQueryDesigner.this.jsonDataManager.getQueryExpression(JsonQueryDesigner.this.queryTextArea.getText(), jsonNode));
                    event.doit = !s.isEmpty();
                } else {
                    event.doit = false;
                }
            }

            public void dragFinished(DragSourceEvent event) {
                if (!event.doit) {
                    return;
                }
            }
        });
    }

    private void createContextualMenu() {
        Menu contextMenu = new Menu((Control)this.treeViewer.getTree());
        final MenuItem setRecordNodeItem = new MenuItem(contextMenu, 8);
        setRecordNodeItem.setText(Messages.JsonQueryDesigner_ItemSetRecordNode);
        setRecordNodeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object sel = ((IStructuredSelection)JsonQueryDesigner.this.treeViewer.getSelection()).getFirstElement();
                if (sel instanceof JsonSupportNode) {
                    String queryExpression = JsonQueryDesigner.this.jsonDataManager.getQueryExpression(null, (JsonSupportNode)sel);
                    JsonQueryDesigner.this.queryTextArea.setText(queryExpression);
                }
            }
        });
        new MenuItem(contextMenu, 2);
        final MenuItem addNodeAsFieldItem1 = new MenuItem(contextMenu, 8);
        addNodeAsFieldItem1.setText(Messages.JsonQueryDesigner_ItemAddNode);
        addNodeAsFieldItem1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object sel = ((IStructuredSelection)JsonQueryDesigner.this.treeViewer.getSelection()).getFirstElement();
                if (sel instanceof JsonSupportNode) {
                    String queryExpression = JsonQueryDesigner.this.jsonDataManager.getQueryExpression(JsonQueryDesigner.this.queryTextArea.getText(), (JsonSupportNode)sel);
                    ((JsonSupportNode)sel).setExpression(queryExpression);
                    JsonQueryDesigner.this.createField((ANode)((JsonSupportNode)sel));
                }
            }
        });
        final MenuItem addNodeAsFieldItem2 = new MenuItem(contextMenu, 8);
        addNodeAsFieldItem2.setText(Messages.JsonQueryDesigner_ItemAddNodeAbsolute);
        addNodeAsFieldItem2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object sel = ((IStructuredSelection)JsonQueryDesigner.this.treeViewer.getSelection()).getFirstElement();
                if (sel instanceof JsonSupportNode) {
                    String queryExpression = JsonQueryDesigner.this.jsonDataManager.getQueryExpression(null, (JsonSupportNode)sel);
                    ((JsonSupportNode)sel).setExpression(queryExpression);
                    JsonQueryDesigner.this.createField((ANode)((JsonSupportNode)sel));
                }
            }
        });
        new MenuItem(contextMenu, 2);
        MenuItem expandAllItem = new MenuItem(contextMenu, 8);
        expandAllItem.setText(Messages.JsonQueryDesigner_ItemExpandAll);
        expandAllItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JsonQueryDesigner.this.treeViewer.expandAll();
            }
        });
        MenuItem collapseAllItem = new MenuItem(contextMenu, 8);
        collapseAllItem.setText(Messages.JsonQueryDesigner_ItemCollapseAll);
        collapseAllItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JsonQueryDesigner.this.treeViewer.collapseAll();
            }
        });
        MenuItem resetRefreshDocItem = new MenuItem(contextMenu, 8);
        resetRefreshDocItem.setText(Messages.JsonQueryDesigner_ItemResetRefresh);
        resetRefreshDocItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JsonQueryDesigner.this.refreshTreeViewerContent(JsonQueryDesigner.this.container.getDataAdapter());
            }
        });
        this.treeViewer.getTree().setMenu(contextMenu);
        contextMenu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent e) {
                Object selEl = ((IStructuredSelection)JsonQueryDesigner.this.treeViewer.getSelection()).getFirstElement();
                if (selEl instanceof JsonSupportNode) {
                    addNodeAsFieldItem1.setEnabled(true);
                    addNodeAsFieldItem2.setEnabled(true);
                    setRecordNodeItem.setEnabled(true);
                } else {
                    setRecordNodeItem.setEnabled(false);
                    addNodeAsFieldItem1.setEnabled(false);
                    addNodeAsFieldItem2.setEnabled(false);
                }
            }

            public void menuHidden(MenuEvent e) {
            }
        });
    }

    public void dispose() {
        if (this.decorateJob != null) {
            this.decorateJob.cancel();
            this.decorateJob = null;
        }
        if (this.jsonLoaderJob != null) {
            this.jsonLoaderJob.cancel();
            this.jsonLoaderJob = null;
        }
        super.dispose();
    }

    public String getContextHelpId() {
        return ContextHelpIDs.WIZARD_QUERY_DIALOG;
    }

    private final class DecorateTreeViewerJob
    extends UIJob {
        public DecorateTreeViewerJob() {
            super(Messages.JsonQueryDesigner_Job);
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (JsonQueryDesigner.this.control != null && !JsonQueryDesigner.this.control.isDisposed()) {
                monitor.beginTask(Messages.JsonQueryDesigner_JobTask, -1);
                String query = JsonQueryDesigner.this.queryTextArea.getText();
                JsonQueryDesigner.this.treeLabelProvider.setSelectedNodes(JsonQueryDesigner.this.jsonDataManager.getSelectableNodes(query));
                JsonQueryDesigner.this.treeViewer.refresh();
                monitor.done();
                return Status.OK_STATUS;
            }
            return Status.CANCEL_STATUS;
        }
    }

    private final class JsonLoaderJob
    extends Job {
        private DataFile dataFile;

        public JsonLoaderJob() {
            super(Messages.JsonQueryDesigner_JsonLoaderJobName);
            this.dataFile = null;
            this.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    IStatus result = event.getResult();
                    if (Status.OK_STATUS.equals(result)) {
                        UIUtils.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (JsonQueryDesigner.this.treeViewer != null && !JsonQueryDesigner.this.treeViewer.getTree().isDisposed()) {
                                    JsonQueryDesigner.this.treeViewer.setInput((Object)((JsonLoaderJob)(this).JsonLoaderJob.this).JsonQueryDesigner.this.jsonDataManager.getJsonSupportModel());
                                    JsonQueryDesigner.this.decorateTreeUsingQueryText();
                                }
                                JsonQueryDesigner.this.isRefreshing = false;
                            }
                        });
                    }
                }
            });
            this.setPriority(30);
        }

        public void updateDataFile(DataFile dataFile) {
            this.dataFile = dataFile;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                if (this.dataFile != null) {
                    JsonQueryDesigner.this.jsonDataManager.loadJsonDataFile(this.dataFile, JsonQueryDesigner.this.getjConfig(), (JRDataset)JsonQueryDesigner.this.getjDataset());
                    return Status.OK_STATUS;
                }
            }
            catch (Exception e) {
                UIUtils.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (JsonQueryDesigner.this.treeViewer != null && !JsonQueryDesigner.this.treeViewer.getTree().isDisposed()) {
                            JsonQueryDesigner.this.container.getQueryStatus().showError((Throwable)e);
                            JsonQueryDesigner.this.treeViewer.getTree().removeAll();
                            JsonQueryDesigner.this.treeViewer.setInput((Object)XMLTreeCustomStatus.ERROR_LOADING_XML);
                        }
                        JsonQueryDesigner.this.isRefreshing = false;
                    }
                });
            }
            return Status.CANCEL_STATUS;
        }
    }
}

