/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.querydesigner.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.util.JsonUtil;

public class JsonQueryHelper {
    private static final String PROPERTY_SEPARATOR = ".";
    private static final String ARRAY_LEFT = "[";
    private static final String ARRAY_RIGHT = "]";
    private static final String ATTRIBUTE_LEFT = "(";
    private static final String ATTRIBUTE_RIGHT = ")";
    private ObjectMapper mapper;

    public JsonQueryHelper(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public JsonQueryHelper() {
        this.mapper = this.getDefaultObjectMapper();
    }

    private ObjectMapper getDefaultObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        return mapper;
    }

    public JsonNode getJsonData(JsonNode rootNode, String jsonExpression) throws JRException {
        if (jsonExpression == null || jsonExpression.length() == 0) {
            return rootNode;
        }
        JsonNode tempNode = rootNode;
        StringTokenizer tokenizer = new StringTokenizer(jsonExpression, PROPERTY_SEPARATOR);
        while (tokenizer.hasMoreTokens()) {
            String currentToken = tokenizer.nextToken();
            int currentTokenLength = currentToken.length();
            int indexOfLeftSquareBracket = currentToken.indexOf(ARRAY_LEFT);
            if (indexOfLeftSquareBracket != -1) {
                if (currentToken.lastIndexOf(ARRAY_RIGHT) != currentTokenLength - 1) {
                    throw new JRException("Invalid expression: " + jsonExpression + "; current token " + currentToken + " not ended properly");
                }
                if (indexOfLeftSquareBracket > 0) {
                    String property = currentToken.substring(0, indexOfLeftSquareBracket);
                    tempNode = this.goDownPathWithAttribute(tempNode, property);
                }
                String arrayOperators = currentToken.substring(indexOfLeftSquareBracket);
                StringTokenizer arrayOpsTokenizer = new StringTokenizer(arrayOperators, ARRAY_RIGHT);
                while (arrayOpsTokenizer.hasMoreTokens()) {
                    if (tempNode == null || tempNode.isMissingNode() || !tempNode.isArray()) {
                        return null;
                    }
                    String currentArrayOperator = arrayOpsTokenizer.nextToken();
                    tempNode = tempNode.path(Integer.parseInt(currentArrayOperator.substring(1)));
                }
                continue;
            }
            tempNode = this.goDownPathWithAttribute(tempNode, currentToken);
        }
        return tempNode;
    }

    protected JsonNode goDownPathWithAttribute(JsonNode rootNode, String pathWithAttributeExpression) throws JRException {
        int indexOfLeftRoundBracket = pathWithAttributeExpression.indexOf(ATTRIBUTE_LEFT);
        if (indexOfLeftRoundBracket != -1) {
            if (pathWithAttributeExpression.indexOf(ATTRIBUTE_RIGHT) != pathWithAttributeExpression.length() - 1) {
                throw new JRException("Invalid attribute selection expression: " + pathWithAttributeExpression);
            }
            if (rootNode != null && !rootNode.isMissingNode()) {
                String path = pathWithAttributeExpression.substring(0, indexOfLeftRoundBracket);
                String attributeExpression = pathWithAttributeExpression.substring(indexOfLeftRoundBracket + 1, pathWithAttributeExpression.length() - 1);
                ArrayNode result = null;
                if (rootNode.isObject()) {
                    if (!rootNode.path(path).isMissingNode()) {
                        if (rootNode.path(path).isObject()) {
                            if (this.isValidExpression(rootNode.path(path), attributeExpression)) {
                                result = rootNode.path(path);
                            }
                        } else if (rootNode.path(path).isArray()) {
                            result = this.mapper.createArrayNode();
                            for (JsonNode node : rootNode.path(path)) {
                                if (!this.isValidExpression(node, attributeExpression)) continue;
                                result.add(node);
                            }
                        }
                    }
                } else if (rootNode.isArray()) {
                    result = this.mapper.createArrayNode();
                    for (JsonNode node : rootNode) {
                        JsonNode deeperNode = node.path(path);
                        if (deeperNode.isMissingNode()) continue;
                        if (deeperNode.isArray()) {
                            for (JsonNode arrayNode : deeperNode) {
                                if (!this.isValidExpression(arrayNode, attributeExpression)) continue;
                                result.add(arrayNode);
                            }
                            continue;
                        }
                        if (!this.isValidExpression(deeperNode, attributeExpression)) continue;
                        result.add(deeperNode);
                    }
                }
                return result;
            }
        } else {
            return this.goDownPath(rootNode, pathWithAttributeExpression);
        }
        return rootNode;
    }

    private JsonNode goDownPath(JsonNode rootNode, String simplePath) {
        if (rootNode != null && !rootNode.isMissingNode()) {
            JsonNode result = null;
            if (rootNode.isObject()) {
                result = rootNode.path(simplePath);
            } else if (rootNode.isArray()) {
                result = this.mapper.createArrayNode();
                for (JsonNode node : rootNode) {
                    JsonNode deeperNode = node.path(simplePath);
                    if (deeperNode.isMissingNode()) continue;
                    if (deeperNode.isArray()) {
                        for (JsonNode arrayNode : deeperNode) {
                            ((ArrayNode)result).add(arrayNode);
                        }
                        continue;
                    }
                    ((ArrayNode)result).add(deeperNode);
                }
            }
            return result;
        }
        return rootNode;
    }

    private boolean isValidExpression(JsonNode operand, String attributeExpression) throws JRException {
        return JsonUtil.evaluateJsonExpression((JsonNode)operand, (String)attributeExpression);
    }
}

