/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.xml;

import com.jaspersoft.studio.data.AWizardDataEditorComposite;
import com.jaspersoft.studio.data.Activator;
import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.DataAdapterEditor;
import com.jaspersoft.studio.data.FieldTypeGuesser;
import com.jaspersoft.studio.data.IWizardDataEditorProvider;
import com.jaspersoft.studio.data.fields.IFieldsProvider;
import com.jaspersoft.studio.data.xml.XMLDataAdapterEditor;
import com.jaspersoft.studio.data.xml.XMLWizardDataEditorComposite;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.XMLUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.utils.parameter.ParameterUtil;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import net.sf.jasperreports.data.DataAdapterService;
import net.sf.jasperreports.data.DataFile;
import net.sf.jasperreports.data.DataFileStream;
import net.sf.jasperreports.data.DataFileUtils;
import net.sf.jasperreports.data.xml.XmlDataAdapter;
import net.sf.jasperreports.data.xml.XmlDataAdapterImpl;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.ParameterContributorContext;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.query.JRXPathQueryExecuterFactory;
import net.sf.jasperreports.engine.util.JRXmlUtils;
import net.sf.jasperreports.engine.util.xml.JRXPathExecuter;
import net.sf.jasperreports.engine.util.xml.JRXPathExecuterFactory;
import net.sf.jasperreports.engine.util.xml.JRXPathExecuterUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLDataAdapterDescriptor
extends DataAdapterDescriptor
implements IFieldsProvider,
IWizardDataEditorProvider {
    public static final long serialVersionUID = 10200L;
    private boolean recursiveFind;
    private boolean considerEmptyNodes;

    public XmlDataAdapterImpl getDataAdapter() {
        if (this.dataAdapter == null) {
            this.dataAdapter = new XmlDataAdapterImpl();
        }
        return (XmlDataAdapterImpl)this.dataAdapter;
    }

    public DataAdapterEditor getEditor() {
        return new XMLDataAdapterEditor();
    }

    public Image getIcon(int size) {
        if (size == 16) {
            return Activator.getDefault().getImage("icons/blue-document-code.png");
        }
        return null;
    }

    public boolean supportsGetFieldsOperation(JasperReportsConfiguration jConfig, JRDataset jDataset) {
        return true;
    }

    public List<JRDesignField> getFields(DataAdapterService con, JasperReportsConfiguration jConfig, JRDataset jDataset) throws JRException, UnsupportedOperationException {
        JRDataSource ds;
        Document doc;
        ArrayList<JRDesignField> fields;
        HashMap<String, Serializable> parameters;
        IProgressMonitor monitor;
        block8: {
            monitor = (IProgressMonitor)jConfig.getMap().get("monitor");
            parameters = new HashMap<String, Serializable>();
            parameters.put("REPORT_PARAMETERS_MAP", new HashMap());
            con.contributeParameters(parameters);
            ParameterUtil.setParameters((JasperReportsConfiguration)jConfig, (JRDataset)jDataset, parameters);
            parameters.put("REPORT_MAX_COUNT", Integer.valueOf(1000));
            if (monitor != null && monitor.isCanceled()) {
                return null;
            }
            this.setRecursiveRetrieval(jConfig);
            this.setConsiderEmptyNodes(jConfig);
            fields = new ArrayList<JRDesignField>();
            XmlDataAdapterImpl d = this.getDataAdapter();
            DataFile df = d.getDataFile();
            doc = null;
            DataFileStream ins = null;
            try {
                try {
                    ins = DataFileUtils.instance((ParameterContributorContext)new ParameterContributorContext((JasperReportsContext)jConfig, null, null)).getDataStream(df, parameters);
                    doc = JRXmlUtils.parse((InputStream)ins, (boolean)XMLUtils.isNamespaceAware((XmlDataAdapter)d, (JasperDesign)jConfig.getJasperDesign()));
                }
                catch (Exception e) {
                    UIUtils.showError((Throwable)e);
                    IOUtils.closeQuietly(ins);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(ins);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)ins);
        }
        if (doc != null) {
            fields.addAll(this.getFieldsFromDocument(doc, jConfig, jDataset));
        }
        if ((ds = (JRDataSource)parameters.get("REPORT_DATA_SOURCE")) == null) {
            ds = new JRXPathQueryExecuterFactory().createQueryExecuter((JasperReportsContext)jConfig, jDataset, ParameterUtil.convertMap(parameters, (JRDataset)jDataset)).createDatasource();
        }
        FieldTypeGuesser.guessTypes(ds, fields, ds.next(), monitor);
        return fields;
    }

    protected List<JRDesignField> getFieldsFromDocument(Document doc, JasperReportsConfiguration jConfig, JRDataset jDataset) throws JRException {
        JRXPathExecuterFactory xPathExecuterFactory = JRXPathExecuterUtils.getXPathExecuterFactory((JasperReportsContext)jConfig);
        JRXPathExecuter xPathExecuter = xPathExecuterFactory.getXPathExecuter();
        NodeList nodes = xPathExecuter.selectNodeList((Node)doc, jDataset.getQuery().getText());
        LinkedHashMap<String, JRDesignField> fieldsMap = new LinkedHashMap<String, JRDesignField>();
        int nIdx = 0;
        while (nIdx < nodes.getLength()) {
            Node currNode = nodes.item(nIdx);
            if (this.considerEmptyNodes || StringUtils.isNotBlank((String)XMLUtils.getChildText((Node)currNode))) {
                this.addMainNodeField(fieldsMap, currNode);
            }
            this.findDirectChildrenAttributes(currNode, fieldsMap, "");
            if (currNode.getNodeType() == 1) {
                NodeList childNodes = currNode.getChildNodes();
                this.findChildFields(childNodes, fieldsMap, "");
            }
            ++nIdx;
        }
        return new ArrayList<JRDesignField>(fieldsMap.values());
    }

    private void findDirectChildrenAttributes(Node node, LinkedHashMap<String, JRDesignField> fieldsMap, String prefix) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            int i = 0;
            while (i < attributes.getLength()) {
                Node item = attributes.item(i);
                if (item.getNodeType() == 2) {
                    this.addNewField(item.getNodeName(), fieldsMap, item, prefix);
                }
                ++i;
            }
        }
    }

    private void findChildFields(NodeList nodes, LinkedHashMap<String, JRDesignField> fieldsMap, String prefix) {
        if (nodes != null) {
            ArrayList childrenNames = new ArrayList();
            int i = 0;
            while (i < nodes.getLength()) {
                Node item = nodes.item(i);
                String nodeName = item.getNodeName();
                if (!(item.getNodeType() != 1 && item.getNodeType() != 2 || childrenNames.contains(nodeName))) {
                    if (this.recursiveFind) {
                        this.findDirectChildrenAttributes(item, fieldsMap, String.valueOf(prefix) + nodeName + "/");
                    }
                    if (this.considerEmptyNodes || StringUtils.isNotBlank((String)XMLUtils.getChildText((Node)item))) {
                        this.addNewField(nodeName, fieldsMap, item, prefix);
                    }
                    if (this.recursiveFind && item.hasChildNodes()) {
                        this.findChildFields(item.getChildNodes(), fieldsMap, String.valueOf(prefix) + nodeName + "/");
                    }
                }
                ++i;
            }
        }
    }

    protected void setRecursiveRetrieval(JasperReportsConfiguration jconfig) {
        this.recursiveFind = jconfig.getPropertyBoolean("xmlChildrenRecursiveRetrieval", false);
    }

    protected void setConsiderEmptyNodes(JasperReportsConfiguration jConfig) {
        this.considerEmptyNodes = jConfig.getPropertyBoolean("com.jaspersoft.studio.data.preferences.XMLQueryEditorPreferencePage.considerEmptyNodes", false);
    }

    private void addNewField(String nodeName, LinkedHashMap<String, JRDesignField> fieldsMap, Node item, String prefix) {
        JRDesignField f = new JRDesignField();
        String description = "";
        f.setName(ModelUtils.getNameForField(new ArrayList<JRDesignField>(fieldsMap.values()), (String)nodeName));
        f.setValueClass(String.class);
        if (item.getNodeType() == 2) {
            description = String.valueOf(prefix) + "@" + item.getNodeName();
            f.setDescription(description);
        } else {
            description = String.valueOf(prefix) + item.getNodeName();
            f.setDescription(description);
        }
        f.getPropertiesMap().setProperty("net.sf.jasperreports.xpath.field.expression", description);
        if (!fieldsMap.containsKey(description)) {
            fieldsMap.put(description, f);
        }
    }

    private void addMainNodeField(LinkedHashMap<String, JRDesignField> fieldsMap, Node item) {
        JRDesignField f = new JRDesignField();
        f.setName(ModelUtils.getNameForField(new ArrayList<JRDesignField>(fieldsMap.values()), (String)item.getNodeName()));
        f.setValueClass(String.class);
        f.setDescription(".");
        f.getPropertiesMap().setProperty("net.sf.jasperreports.xpath.field.expression", ".");
        fieldsMap.put(".", f);
    }

    public AWizardDataEditorComposite createDataEditorComposite(Composite parent, WizardPage page) {
        return new XMLWizardDataEditorComposite(parent, page, this);
    }

    public String[] getLanguages() {
        return new String[]{"XPath", "xpath2"};
    }
}

