/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.xmla;

import com.jaspersoft.studio.data.xmla.DataSourceTreeElement;
import com.jaspersoft.studio.data.xmla.MetadataDiscover;
import java.util.Iterator;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;

public class CatalogElement
implements DataSourceTreeElement {
    private String dataSourceInfo;
    private String catalogName;
    private String description;
    private String roles;
    private String dateModified;
    private MetadataDiscover parent;

    public CatalogElement(MetadataDiscover svm, SOAPElement rowNode, String myDataSourceInfo) {
        this.parent = svm;
        this.dataSourceInfo = myDataSourceInfo;
        this.catalogName = this.getRowValue(rowNode, "CATALOG_NAME");
        this.description = this.getRowValue(rowNode, "DESCRIPTION");
        this.roles = this.getRowValue(rowNode, "ROLES");
        this.dateModified = this.getRowValue(rowNode, "DATE_MODIFIED");
    }

    private String getRowValue(SOAPElement cellElement, String tagName) {
        try {
            Iterator dimensionNameNode = cellElement.getChildElements(this.parent.getSoapFactory().createName(tagName, "", "urn:schemas-microsoft-com:xml-analysis:rowset"));
            String value = null;
            if (dimensionNameNode.hasNext()) {
                SOAPElement valueElement = (SOAPElement)dimensionNameNode.next();
                value = valueElement.getValue();
                return value;
            }
        }
        catch (SOAPException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public DataSourceTreeElement[] getChildren() {
        return this.parent.getCubeList(this.dataSourceInfo, this.catalogName);
    }

    @Override
    public String toString() {
        if (this.catalogName == null) {
            return "not initialized";
        }
        return this.catalogName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getRoles() {
        return this.roles;
    }

    public String getDateModified() {
        return this.dateModified;
    }

    @Override
    public String getDataSourceInfo() {
        return this.dataSourceInfo;
    }
}

