/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.xmla;

import com.jaspersoft.studio.data.xmla.DataSourceTreeElement;
import com.jaspersoft.studio.data.xmla.MetadataDiscover;
import java.util.Iterator;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;

public class CubeElement
implements DataSourceTreeElement {
    private String dataSourceInfo;
    private String catalogName;
    private String cubeName;
    private String cubeType;
    private String lastSchemaUpdate;
    private String lastDataUpdate;
    private String isDrillthroughEnabled;
    private String isLinkable;
    private String isWriteEnabled;
    private String isSQLEnabled;
    private MetadataDiscover parent;

    public CubeElement(MetadataDiscover svm, SOAPElement rowNode, String myDataSourceInfo) {
        this.parent = svm;
        this.dataSourceInfo = myDataSourceInfo;
        this.catalogName = this.getRowValue(rowNode, "CATALOG_NAME");
        this.cubeName = this.getRowValue(rowNode, "CUBE_NAME");
        this.cubeType = this.getRowValue(rowNode, "CUBE_TYPE");
        this.lastSchemaUpdate = this.getRowValue(rowNode, "LAST_SCHEMA_UPDATE");
        this.lastDataUpdate = this.getRowValue(rowNode, "LAST_DATA_UPDATE");
        this.isDrillthroughEnabled = this.getRowValue(rowNode, "IS_DRILLTHROUGH_ENABLED");
        this.isLinkable = this.getRowValue(rowNode, "IS_LINKABLE");
        this.isWriteEnabled = this.getRowValue(rowNode, "IS_WRITE_ENABLED");
        this.isSQLEnabled = this.getRowValue(rowNode, "IS_SQL_ENABLED");
    }

    private String getRowValue(SOAPElement cellElement, String tagName) {
        try {
            Iterator dimensionNameNode = cellElement.getChildElements(this.parent.getSoapFactory().createName(tagName, "", "urn:schemas-microsoft-com:xml-analysis:rowset"));
            String value = null;
            if (dimensionNameNode.hasNext()) {
                SOAPElement valueElement = (SOAPElement)dimensionNameNode.next();
                value = valueElement.getValue();
                return value;
            }
        }
        catch (SOAPException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public DataSourceTreeElement[] getChildren() {
        return null;
    }

    @Override
    public String toString() {
        if (this.cubeName == null) {
            return "not initialized";
        }
        return this.cubeName;
    }

    public String getCubeType() {
        return this.cubeType;
    }

    public String getLastSchemaUpdate() {
        return this.lastSchemaUpdate;
    }

    public String getLastDataUpdate() {
        return this.lastDataUpdate;
    }

    public String isDrillThroughEnable() {
        return this.isDrillthroughEnabled;
    }

    public String isLinkable() {
        return this.isLinkable;
    }

    public String isWriteEnabled() {
        return this.isWriteEnabled;
    }

    public String isSqlEnabled() {
        return this.isSQLEnabled;
    }

    @Override
    public String getDataSourceInfo() {
        return this.dataSourceInfo;
    }

    public String getCubeName() {
        return this.cubeName;
    }

    public String getCatalogName() {
        return this.catalogName;
    }
}

