/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.xmla;

import com.jaspersoft.studio.data.xmla.CatalogElement;
import com.jaspersoft.studio.data.xmla.CubeElement;
import com.jaspersoft.studio.data.xmla.DataSourceElement;
import com.jaspersoft.studio.data.xmla.DataSourceTreeElement;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;

public class MetadataDiscover {
    public static final String XMLA_URI = "urn:schemas-microsoft-com:xml-analysis";
    public static final String ROW_URI = "urn:schemas-microsoft-com:xml-analysis:rowset";
    private static String soapMessageFactoryClass = null;
    private static String soapConnectionFactoryClass = null;
    private String requestType;
    private SOAPConnection connection;
    private SOAPFactory sf;
    private String url;
    private String username;
    private String password;

    public static void setAxisSOAPClientConfig() {
        try {
            if (soapMessageFactoryClass == null && (soapMessageFactoryClass = System.getProperty("javax.xml.soap.MessageFactory")) == null) {
                soapMessageFactoryClass = MessageFactory.newInstance().getClass().getName();
            }
        }
        catch (SOAPException sOAPException) {}
        try {
            if (soapConnectionFactoryClass == null && (soapConnectionFactoryClass = System.getProperty("javax.xml.soap.SOAPConnectionFactory")) == null) {
                soapConnectionFactoryClass = SOAPConnectionFactory.newInstance().getClass().getName();
            }
        }
        catch (SOAPException sOAPException) {}
    }

    public static void restoreSOAPClientConfig() {
        if (soapMessageFactoryClass != null) {
            System.setProperty("javax.xml.soap.MessageFactory", soapMessageFactoryClass);
        }
        if (soapConnectionFactoryClass != null) {
            System.setProperty("javax.xml.soap.SOAPConnectionFactory", soapConnectionFactoryClass);
        }
    }

    public MetadataDiscover(String url, String username, String password) {
        this.url = url;
        this.username = username;
        this.password = password;
    }

    private String getRequestType() {
        return this.requestType == null ? "DISCOVER_DATASOURCES" : this.requestType;
    }

    private void setRequestType(String requestType) {
        this.requestType = requestType;
    }

    protected SOAPMessage createQueryMessage(Map<String, String> paraList) {
        try {
            MessageFactory mf = MessageFactory.newInstance();
            SOAPMessage message = mf.createMessage();
            MimeHeaders mh = message.getMimeHeaders();
            mh.setHeader("SOAPAction", "\"urn:schemas-microsoft-com:xml-analysis:Discover\"");
            mh.setHeader("Content-Type", "text/xml; charset=utf-8");
            mh.setHeader("Accept", "application/soap+xml, application/dime, multipart/related, text/*");
            SOAPPart soapPart = message.getSOAPPart();
            SOAPEnvelope envelope = soapPart.getEnvelope();
            SOAPBody body = envelope.getBody();
            Name nDiscover = envelope.createName("Discover", "", XMLA_URI);
            SOAPElement eDiscover = body.addChildElement(nDiscover);
            Name nRequest = envelope.createName("RequestType", "", XMLA_URI);
            SOAPElement eRequest = eDiscover.addChildElement(nRequest);
            eRequest.addTextNode(this.getRequestType());
            Name nRestiction = envelope.createName("Restrictions", "", XMLA_URI);
            SOAPElement eRestriction = eDiscover.addChildElement(nRestiction);
            Name nRestictionList = envelope.createName("RestrictionList", "", XMLA_URI);
            eRestriction.addChildElement(nRestictionList);
            paraList.put("Format", "Tabular");
            paraList.put("Content", "SchemaData");
            this.addParameterList(envelope, eDiscover, "Properties", "PropertyList", paraList);
            message.saveChanges();
            return message;
        }
        catch (SOAPException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void addParameterList(SOAPEnvelope envelope, SOAPElement eParent, String typeName, String listName, Map<String, String> params) throws SOAPException {
        Name nPara = envelope.createName(typeName, "", XMLA_URI);
        SOAPElement eType = eParent.addChildElement(nPara);
        nPara = envelope.createName(listName, "", XMLA_URI);
        SOAPElement eList = eType.addChildElement(nPara);
        if (params == null) {
            return;
        }
        for (String tag : params.keySet()) {
            String value = params.get(tag);
            nPara = envelope.createName(tag, "", XMLA_URI);
            SOAPElement eTag = eList.addChildElement(nPara);
            eTag.addTextNode(value);
        }
    }

    protected SOAPConnection createSOAPConnection() {
        try {
            SOAPConnectionFactory scf = SOAPConnectionFactory.newInstance();
            SOAPConnection soapConnection = scf.createConnection();
            return soapConnection;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SOAPMessage executeDiscover(Map<String, String> paraList) {
        try {
            try {
                SOAPMessage resultMessage;
                MetadataDiscover.setAxisSOAPClientConfig();
                this.sf = SOAPFactory.newInstance();
                this.connection = this.createSOAPConnection();
                SOAPMessage queryMessage = this.createQueryMessage(paraList);
                URL soapURL = new URL(this.getSoapUrl());
                SOAPMessage sOAPMessage = resultMessage = this.connection.call(queryMessage, (Object)soapURL);
                return sOAPMessage;
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                return null;
            }
            catch (SOAPException e) {
                e.printStackTrace();
                return null;
            }
            finally {
                MetadataDiscover.restoreSOAPClientConfig();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    protected String getSoapUrl() throws MalformedURLException {
        String soapUrl;
        if (this.username == null || this.username.length() == 0) {
            soapUrl = this.url;
        } else {
            URL urlObj = new URL(this.url);
            soapUrl = String.valueOf(urlObj.getProtocol()) + "://" + this.username;
            if (this.password != null && this.password.length() > 0) {
                soapUrl = String.valueOf(soapUrl) + ":" + this.password;
            }
            soapUrl = String.valueOf(soapUrl) + "@" + urlObj.getHost() + ":" + urlObj.getPort() + urlObj.getPath();
        }
        return soapUrl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected SOAPElement getRowsSet(SOAPMessage reply, SOAPEnvelope soapEnvelope) {
        SOAPElement rootElement = null;
        try {
            SOAPBody soapBody = soapEnvelope.getBody();
            SOAPElement eElement = null;
            SOAPFault fault = soapBody.getFault();
            if (fault != null) {
                throw new RuntimeException(fault.getFaultString());
            }
            Name eName = soapEnvelope.createName("DiscoverResponse", "", XMLA_URI);
            Iterator responseElements = soapBody.getChildElements(eName);
            if (!responseElements.hasNext()) return null;
            Object eObj = responseElements.next();
            if (eObj == null) {
                return null;
            }
            eElement = (SOAPElement)eObj;
            Name rName = soapEnvelope.createName("return", "", XMLA_URI);
            Iterator returnElements = eElement.getChildElements(rName);
            SOAPElement returnElement = null;
            if (returnElements.hasNext()) {
                Object eObj2 = returnElements.next();
                if (eObj2 == null) {
                    return null;
                }
                returnElement = (SOAPElement)eObj2;
            } else {
                Name rName2 = soapEnvelope.createName("return", "", "");
                returnElements = eElement.getChildElements(rName2);
                if (!returnElements.hasNext()) return null;
                Object eObj3 = returnElements.next();
                if (eObj3 == null) {
                    return null;
                }
                returnElement = (SOAPElement)eObj3;
            }
            Name rootName = soapEnvelope.createName("root", "", ROW_URI);
            Iterator rootElements = returnElement.getChildElements(rootName);
            if (!rootElements.hasNext()) return null;
            Object eObj4 = rootElements.next();
            if (eObj4 != null) return (SOAPElement)eObj4;
            return null;
        }
        catch (SOAPException ex) {
            ex.printStackTrace();
        }
        return rootElement;
    }

    public SOAPFactory getSoapFactory() {
        return this.sf;
    }

    public DataSourceTreeElement[] getDatasources() {
        this.setRequestType("DISCOVER_DATASOURCES");
        SOAPMessage response = this.executeDiscover(new HashMap<String, String>());
        SOAPPart soapPart = response.getSOAPPart();
        try {
            SOAPEnvelope soapEnvelope = soapPart.getEnvelope();
            SOAPElement rowSet = this.getRowsSet(response, soapEnvelope);
            ArrayList<DataSourceElement> result = new ArrayList<DataSourceElement>();
            Name rowElement = soapEnvelope.createName("row", "", ROW_URI);
            Iterator rowValuesElement = rowSet.getChildElements(rowElement);
            while (rowValuesElement.hasNext()) {
                SOAPElement cellElement = (SOAPElement)rowValuesElement.next();
                result.add(new DataSourceElement(this, cellElement));
            }
            return result.toArray(new DataSourceTreeElement[result.size()]);
        }
        catch (SOAPException e) {
            e.printStackTrace();
            return null;
        }
    }

    public DataSourceTreeElement[] getCatalogList(String datasourceName) {
        this.setRequestType("DBSCHEMA_CATALOGS");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("DataSourceInfo", datasourceName);
        SOAPMessage response = this.executeDiscover(param);
        SOAPPart soapPart = response.getSOAPPart();
        try {
            SOAPEnvelope soapEnvelope = soapPart.getEnvelope();
            SOAPElement rowSet = this.getRowsSet(response, soapEnvelope);
            ArrayList<CatalogElement> result = new ArrayList<CatalogElement>();
            Name rowElement = soapEnvelope.createName("row", "", ROW_URI);
            Iterator rowValuesElement = rowSet.getChildElements(rowElement);
            while (rowValuesElement.hasNext()) {
                SOAPElement cellElement = (SOAPElement)rowValuesElement.next();
                result.add(new CatalogElement(this, cellElement, datasourceName));
            }
            return result.toArray(new DataSourceTreeElement[result.size()]);
        }
        catch (SOAPException e) {
            e.printStackTrace();
            return null;
        }
    }

    public DataSourceTreeElement[] getCubeList(String datasourceName, String catalogName) {
        this.setRequestType("MDSCHEMA_CUBES");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("DataSourceInfo", datasourceName);
        param.put("Catalog", catalogName);
        SOAPMessage response = this.executeDiscover(param);
        SOAPPart soapPart = response.getSOAPPart();
        try {
            SOAPEnvelope soapEnvelope = soapPart.getEnvelope();
            SOAPElement rowSet = this.getRowsSet(response, soapEnvelope);
            ArrayList<CubeElement> result = new ArrayList<CubeElement>();
            Name rowElement = soapEnvelope.createName("row", "", ROW_URI);
            Iterator rowValuesElement = rowSet.getChildElements(rowElement);
            while (rowValuesElement.hasNext()) {
                SOAPElement cellElement = (SOAPElement)rowValuesElement.next();
                result.add(new CubeElement(this, cellElement, datasourceName));
            }
            return result.toArray(new DataSourceTreeElement[result.size()]);
        }
        catch (SOAPException e) {
            e.printStackTrace();
            return null;
        }
    }
}

