/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.xmla;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.adapter.IDataAdapterCreator;
import com.jaspersoft.studio.data.xmla.XmlaDataAdapterDescriptor;
import java.util.UUID;
import net.sf.jasperreports.data.DataAdapter;
import net.sf.jasperreports.data.xmla.XmlaDataAdapterImpl;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.SecureStorageUtils;
import org.eclipse.equinox.security.storage.StorageException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLACreator
implements IDataAdapterCreator {
    public DataAdapterDescriptor buildFromXML(Document docXML) {
        XmlaDataAdapterImpl result = new XmlaDataAdapterImpl();
        NamedNodeMap rootAttributes = docXML.getChildNodes().item(0).getAttributes();
        String connectionName = rootAttributes.getNamedItem("name").getTextContent();
        result.setName(connectionName);
        NodeList children = docXML.getChildNodes().item(0).getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node node = children.item(i);
            if (node.getNodeName().equals("connectionParameter")) {
                String paramName = node.getAttributes().getNamedItem("name").getTextContent();
                if (paramName.equals("SavePassword")) {
                    result.setSavePassword(node.getTextContent().equals("true"));
                }
                if (paramName.equals("catalog")) {
                    result.setCatalog(node.getTextContent());
                }
                if (paramName.equals("cube")) {
                    result.setCube(node.getTextContent());
                }
                if (paramName.equals("Password")) {
                    result.setPassword(this.getPasswordValue(node.getTextContent()));
                }
                if (paramName.equals("Username")) {
                    result.setUsername(node.getTextContent());
                }
                if (paramName.equals("datasource")) {
                    result.setDatasource(node.getTextContent());
                }
                if (paramName.equals("url")) {
                    result.setXmlaUrl(node.getTextContent());
                }
            }
            ++i;
        }
        XmlaDataAdapterDescriptor desc = new XmlaDataAdapterDescriptor();
        desc.setDataAdapter((DataAdapter)result);
        return desc;
    }

    public String getID() {
        return "com.jaspersoft.ireport.designer.connection.JRXMLADataSourceConnection";
    }

    private String getPasswordValue(String passwordFieldTxt) {
        return JaspersoftStudioPlugin.shouldUseSecureStorage() ? this.getSecretStorageKey(passwordFieldTxt) : passwordFieldTxt;
    }

    private String getSecretStorageKey(String pass) {
        try {
            UUID uuidKey = UUID.randomUUID();
            SecureStorageUtils.saveToDefaultSecurePreferences((String)"net.sf.jasperreports.data.adapter", (String)uuidKey.toString(), (String)pass);
            return uuidKey.toString();
        }
        catch (StorageException e) {
            UIUtils.showError((Throwable)e);
            return pass;
        }
    }
}

