/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.widgets.map.support;

import com.jaspersoft.studio.widgets.map.core.LatLng;
import com.jaspersoft.studio.widgets.map.core.MapType;
import com.jaspersoft.studio.widgets.map.core.Marker;
import com.jaspersoft.studio.widgets.map.messages.Messages;
import com.jaspersoft.studio.widgets.map.support.JSMapSupport;
import java.util.List;
import org.eclipse.swt.browser.Browser;

public class BaseJSMapSupport
implements JSMapSupport {
    private Browser browser;
    private String mapId;

    public BaseJSMapSupport(Browser browser) {
        this(browser, "myMap");
    }

    public BaseJSMapSupport(Browser browser, String mapId) {
        this.browser = browser;
        this.mapId = mapId;
    }

    @Override
    public LatLng getMapCenter() {
        return new LatLng((Double)this.getBrowserControl().evaluate("return " + this.mapId + ".getCenter().lat();"), (Double)this.getBrowserControl().evaluate("return " + this.mapId + ".getCenter().lng();"));
    }

    @Override
    public void setMapCenter(LatLng position) {
        String positionVar = "new google.maps.LatLng(" + position.getLat() + "," + position.getLng() + ")";
        this.getBrowserControl().evaluate(String.valueOf(this.mapId) + ".setCenter(" + positionVar + ");");
    }

    @Override
    public void setPanTo(LatLng position) {
        String positionVar = "new google.maps.LatLng(" + position.getLat() + "," + position.getLng() + ")";
        this.getBrowserControl().evaluate(String.valueOf(this.mapId) + ".panTo(" + positionVar + ");");
    }

    @Override
    public int getZoomLevel() {
        return ((Double)this.getBrowserControl().evaluate("return " + this.mapId + ".getZoom();")).intValue();
    }

    @Override
    public void setZoomLevel(int newZoomLevel) {
        this.getBrowserControl().evaluate(String.valueOf(this.mapId) + ".setZoom(" + newZoomLevel + ");");
    }

    @Override
    public void addNewMarker(Marker newMarker) {
        String markerPosition = "new google.maps.LatLng(" + newMarker.getPosition().getLat() + "," + newMarker.getPosition().getLng() + ")";
        this.getBrowserControl().evaluate(String.valueOf(this.mapId) + ".addMarker(" + markerPosition + ");");
    }

    @Override
    public void removeMarker(Marker oldMarker) {
        throw new UnsupportedOperationException(Messages.BaseJSMapSupport_UnsupportedMethodError);
    }

    @Override
    public void removeMarker(int markerIndex) {
        this.getBrowserControl().evaluate(String.valueOf(this.mapId) + ".removeMarkerByIndex(" + markerIndex + ")");
    }

    @Override
    public void clearMarkers() {
        this.getBrowserControl().evaluate(String.valueOf(this.mapId) + ".clearAllMarkers();");
    }

    @Override
    public List<Marker> getMarkers() {
        throw new UnsupportedOperationException(Messages.BaseJSMapSupport_UnsupportedMethodError);
    }

    @Override
    public int getMarkersNum() {
        return ((Double)this.getBrowserControl().evaluate("return " + this.mapId + ".mapMarkers.length;")).intValue();
    }

    @Override
    public void updateMarkerPosition(int markerIdx, LatLng newPosition) {
        String newPositionStr = "new google.maps.LatLng(" + newPosition.getLat() + "," + newPosition.getLng() + ")";
        this.getBrowserControl().evaluate(String.valueOf(this.mapId) + ".mapMarkers[" + markerIdx + "].setPosition(" + newPositionStr + ");");
    }

    @Override
    public void highlightMarker(int markerIdx) {
        this.getBrowserControl().evaluate(String.valueOf(this.mapId) + ".bounceMarker(" + markerIdx + ");");
    }

    @Override
    public Browser getBrowserControl() {
        return this.browser;
    }

    @Override
    public void setMapType(MapType mapType) {
        this.getBrowserControl().evaluate(String.valueOf(this.mapId) + ".setMapType(" + mapType.getGoogleConstant() + ");");
    }

    @Override
    public MapType getMapType() {
        return MapType.fromStringID((String)this.getBrowserControl().evaluate("return " + this.mapId + ".getMapType();"));
    }

    @Override
    public Object evaluateJavascript(String snippet) {
        return this.getBrowserControl().evaluate(snippet);
    }
}

