/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.widgets.map.support;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.widgets.map.core.Animation;
import com.jaspersoft.studio.widgets.map.core.LatLng;
import com.jaspersoft.studio.widgets.map.core.MarkerOptions;
import com.jaspersoft.studio.widgets.map.support.MapCredentials;
import java.net.URLEncoder;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class GMapUtils {
    public static final int OPTIONS_LAT_INDEX = 0;
    public static final int OPTIONS_LNG_INDEX = 1;
    public static final int OPTIONS_DRAGGABLE_INDEX = 2;
    public static final int OPTIONS_ANIMATION_INDEX = 3;
    public static final int OPTIONS_VISIBLE_INDEX = 4;
    public static final int OPTIONS_CLICKABLE_INDEX = 5;

    public static MarkerOptions getMarkerOptions(Object[] arguments) {
        MarkerOptions options = new MarkerOptions();
        options.setPosition(new LatLng((Double)arguments[0], (Double)arguments[1]));
        options.setDraggable((Boolean)arguments[2]);
        options.setAnimation(GMapUtils.getMarkerAnimation((Double)arguments[3]));
        options.setVisible((Boolean)arguments[4]);
        options.setClickable((Boolean)arguments[5]);
        return options;
    }

    public static LatLng getPosition(Object[] arguments) {
        return new LatLng((Double)arguments[0], (Double)arguments[1]);
    }

    public static Animation getMarkerAnimation(Double value) {
        if (value != null) {
            switch (value.intValue()) {
                case 1: {
                    return Animation.BOUNCE;
                }
                case 2: {
                    return Animation.DROP;
                }
            }
            return null;
        }
        return null;
    }

    public static LatLng getAddressCoordinates(String addressText, MapCredentials mapCredentials) {
        LatLng coordinates = null;
        HttpGet locateAddressGET = null;
        String apikeyDetails = "";
        if (mapCredentials != null) {
            apikeyDetails = "key=" + mapCredentials.getApiKey() + "&";
        }
        try {
            try {
                String addressUrlEncoded = URLEncoder.encode(addressText, "UTF-8");
                locateAddressGET = new HttpGet("https://maps.google.com/maps/api/geocode/json?" + apikeyDetails + "address=" + addressUrlEncoded);
                Throwable throwable = null;
                Object var7_9 = null;
                try (CloseableHttpClient httpclient = HttpClients.createDefault();){
                    CloseableHttpResponse response = httpclient.execute((HttpUriRequest)locateAddressGET);
                    int httpRetCode = response.getStatusLine().getStatusCode();
                    if (httpRetCode == 200) {
                        JsonNode location;
                        String responseBodyAsString = EntityUtils.toString((HttpEntity)response.getEntity());
                        System.out.println(responseBodyAsString);
                        ObjectMapper mapper = new ObjectMapper();
                        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
                        mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
                        mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
                        JsonNode jsonRoot = mapper.readTree(responseBodyAsString);
                        if (jsonRoot != null && jsonRoot.path("results") != null && jsonRoot.path("results").has(0) && jsonRoot.path("results").get(0).path("geometry") != null && (location = jsonRoot.path("results").get(0).path("geometry").path("location")) != null) {
                            JsonNode lat = location.get("lat");
                            JsonNode lng = location.get("lng");
                            coordinates = new LatLng(lat.asDouble(), lng.asDouble());
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (locateAddressGET != null) {
                    locateAddressGET.releaseConnection();
                }
            }
        }
        finally {
            if (locateAddressGET != null) {
                locateAddressGET.releaseConnection();
            }
        }
        return coordinates;
    }

    public static MapCredentials getMapCredentials(JasperReportsConfiguration jConfig) {
        MapCredentials credentials = null;
        if (jConfig != null && jConfig.getJasperDesign() != null) {
            String key = jConfig.getJasperDesign().getProperty("net.sf.jasperreports.components.map.key");
            credentials = new MapCredentials(key);
        }
        return credentials;
    }
}

