/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.widgets.map.ui;

import com.jaspersoft.studio.widgets.map.core.LatLng;
import com.jaspersoft.studio.widgets.map.core.MapType;
import com.jaspersoft.studio.widgets.map.support.MapCredentials;
import com.jaspersoft.studio.widgets.map.ui.GMapsCenterPanel;
import net.sf.jasperreports.eclipse.ui.util.PersistentLocationDialog;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class GMapCenterDialog
extends PersistentLocationDialog {
    private GMapsCenterPanel mapPanel;
    private MapCredentials mapCredentials;
    protected LatLng mapCenter = new LatLng(45.439722, 12.331944);
    protected int zoomLevel = 12;
    protected MapType mapType = MapType.ROADMAP;
    protected String address;

    protected GMapCenterDialog(Shell parentShell, MapCredentials mapCredentials) {
        super(parentShell);
        this.mapCredentials = mapCredentials;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Map");
    }

    protected Point getInitialSize() {
        return new Point(800, 600);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        try {
            this.mapPanel = new GMapsCenterPanel(container, 0, this.mapCredentials){

                @Override
                public void setMapCenter(LatLng mapCenter) {
                    super.setMapCenter(mapCenter);
                    GMapCenterDialog.this.mapCenter = mapCenter;
                }

                @Override
                public void setZoomLevel(int zoomLevel) {
                    super.setZoomLevel(zoomLevel);
                    GMapCenterDialog.this.zoomLevel = zoomLevel;
                }

                @Override
                public void setMapType(MapType mapType) {
                    super.setMapType(mapType);
                    GMapCenterDialog.this.mapType = mapType;
                }

                @Override
                public void setAddress(String address) {
                    super.setAddress(address);
                    GMapCenterDialog.this.address = address;
                }

                @Override
                protected void handleMapCenterChanged(LatLng position) {
                    super.handleMapCenterChanged(position);
                    this.setMapCenter(position);
                }

                @Override
                protected void handleMapZoomChanged(int newZoomLevel) {
                    this.setZoomLevel(newZoomLevel);
                }

                @Override
                protected void handleAddressChanged(String address) {
                    this.setAddress(address);
                }

                @Override
                protected void handleMapTypeChanged(MapType mapType) {
                    this.setMapType(mapType);
                }
            };
            this.mapPanel.setAddress(this.address);
            this.mapPanel.setMapCenter(this.mapCenter);
            this.mapPanel.setMapType(this.mapType);
            this.mapPanel.setZoomLevel(this.zoomLevel);
        }
        catch (Throwable e) {
            UIUtils.showError((Throwable)e);
        }
        return container;
    }

    public GMapsCenterPanel getMapPanel() {
        return this.mapPanel;
    }

    public void setMapCenter(LatLng mapCenter) {
        this.mapCenter = mapCenter;
    }

    public LatLng getMapCenter() {
        return this.mapCenter;
    }

    public void setMapType(MapType mapType) {
        this.mapType = mapType;
    }

    public MapType getMapType() {
        return this.mapType;
    }

    public void setZoomLevel(int zoomLevel) {
        this.zoomLevel = zoomLevel;
    }

    public int getZoomLevel() {
        return this.zoomLevel;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getAddress() {
        return this.address;
    }

    public boolean close() {
        if (this.mapPanel != null) {
            this.mapPanel.dispose();
        }
        return super.close();
    }
}

