/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.widgets.map.ui;

import com.jaspersoft.studio.widgets.map.MapActivator;
import com.jaspersoft.studio.widgets.map.browserfunctions.GMapEnabledFunction;
import com.jaspersoft.studio.widgets.map.browserfunctions.TestJavaCallSupport;
import com.jaspersoft.studio.widgets.map.browserfunctions.UpdateMapCenter;
import com.jaspersoft.studio.widgets.map.browserfunctions.UpdateMapType;
import com.jaspersoft.studio.widgets.map.browserfunctions.UpdateZoomLevel;
import com.jaspersoft.studio.widgets.map.messages.Messages;
import com.jaspersoft.studio.widgets.map.support.BaseJSMapSupport;
import com.jaspersoft.studio.widgets.map.support.BaseJavaMapSupport;
import com.jaspersoft.studio.widgets.map.support.JSMapSupport;
import com.jaspersoft.studio.widgets.map.support.JavaMapSupport;
import com.jaspersoft.studio.widgets.map.support.MapCredentials;
import com.jaspersoft.studio.widgets.map.ui.MapUIUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.apache.commons.io.FileUtils;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressAdapter;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class MapTile {
    private static final String MAP_JS_API_URL = "https://maps.googleapis.com/maps/api/js";
    private List<GMapEnabledFunction> functions;
    private JSMapSupport jsMapSupp;
    private JavaMapSupport javaMapSupp;
    protected Browser mapControl;
    private String mapURL;
    private String apiKey;
    private Path tmpMapDirectory;

    public MapTile(Composite parent, int style, MapCredentials credentials) {
        this(parent, style, MapActivator.getFileLocation("mapfiles/gmaps_library/map.html"), credentials);
    }

    public MapTile(Composite parent, int style, String mapURL, MapCredentials credentials) {
        this.createBrowser(parent, style);
        this.addListeners();
        this.mapURL = mapURL;
        this.apiKey = credentials != null ? credentials.getApiKey() : null;
    }

    protected void createBrowser(Composite parent, int style) {
        this.mapControl = new Browser(parent, style | 0x800);
        this.mapControl.addListener(35, new Listener(){

            public void handleEvent(Event event) {
                event.doit = false;
            }
        });
        if (MapUIUtils.isGoogleMapWidgetDisabled()) {
            String disabledMapURL = MapActivator.getFileLocation("mapfiles/gmaps_library/map_disabled.html");
            this.mapControl.setUrl(this.fixMapURL(disabledMapURL));
            this.mapControl.setJavascriptEnabled(false);
        }
    }

    protected void addListeners() {
    }

    public void configureJavaSupport(BaseJavaMapSupport javaSupport) {
        if (this.javaMapSupp != null) {
            throw new RuntimeException(Messages.MapTile_JavaSupportAlreadyDefinedError);
        }
        this.javaMapSupp = javaSupport;
    }

    public void configureJavascriptSupport(BaseJSMapSupport jsSupport) {
        if (this.jsMapSupp != null) {
            throw new RuntimeException(Messages.MapTile_JavascriptSupportAlreadyDefined);
        }
        this.jsMapSupp = jsSupport;
    }

    public void configureFunctions(List<GMapEnabledFunction> functs) {
        this.functions = new ArrayList<GMapEnabledFunction>(functs);
    }

    public void setLayoutData(Object layoutData) {
        this.mapControl.setLayoutData(layoutData);
    }

    public JSMapSupport getJavascriptMapSupport() {
        if (this.jsMapSupp == null) {
            this.jsMapSupp = new BaseJSMapSupport(this.mapControl);
        }
        return this.jsMapSupp;
    }

    public boolean hasJavaMapSupport() {
        return this.javaMapSupp != null;
    }

    public JavaMapSupport getJavaMapSupport() {
        if (this.javaMapSupp == null) {
            this.javaMapSupp = new BaseJavaMapSupport(this.mapControl);
        }
        return this.javaMapSupp;
    }

    public List<GMapEnabledFunction> getFunctions() {
        if (this.functions == null) {
            this.functions = new ArrayList<GMapEnabledFunction>(4);
            this.functions.add(new TestJavaCallSupport(this.mapControl, "javaCall_TestJavaCallSupport", this.getJavaMapSupport()));
            this.functions.add(new UpdateZoomLevel(this.mapControl, "javaCall_UpdateZoomLevel", this.getJavaMapSupport()));
            this.functions.add(new UpdateMapCenter(this.mapControl, "javaCall_UpdateMapCenter", this.getJavaMapSupport()));
            this.functions.add(new UpdateMapType(this.mapControl, "javaCall_UpdateMapType", this.getJavaMapSupport()));
        }
        return this.functions;
    }

    public Browser getMapControl() {
        return this.mapControl;
    }

    public void activateMapTile() {
        this.getJavaMapSupport();
        this.getJavascriptMapSupport();
        this.getFunctions();
        if (!MapUIUtils.isGoogleMapWidgetDisabled()) {
            this.mapControl.addProgressListener((ProgressListener)new ProgressAdapter(){

                public void completed(ProgressEvent event) {
                    MapTile.this.mapControl.evaluate("mapSetup();", true);
                }
            });
            if (this.apiKey != null) {
                try {
                    File origMapFile = new File(this.mapURL);
                    this.tmpMapDirectory = Files.createTempDirectory("gmaplibrary", new FileAttribute[0]);
                    FileUtils.copyDirectory((File)origMapFile.getParentFile(), (File)this.tmpMapDirectory.toFile());
                    String origMapHtmlCode = Files.readString(origMapFile.toPath());
                    File tmpMapFile = Files.createTempFile(this.tmpMapDirectory, "map", ".html", new FileAttribute[0]).toFile();
                    origMapHtmlCode = origMapHtmlCode.replace(MAP_JS_API_URL, "https://maps.googleapis.com/maps/api/js?key=" + this.apiKey);
                    Files.writeString(tmpMapFile.toPath(), (CharSequence)origMapHtmlCode, new OpenOption[0]);
                    this.mapControl.setUrl(this.fixMapURL(tmpMapFile.getAbsolutePath()));
                }
                catch (IOException e) {
                    MapActivator.logError(Messages.MapTile_ErrorMsgBadApiKey, e);
                    UIUtils.showError((String)Messages.MapTile_ErrorMsgBadApiKey, (Throwable)e);
                    this.mapControl.setUrl(this.fixMapURL(this.mapURL));
                }
            } else {
                this.mapControl.setUrl(this.fixMapURL(this.mapURL));
            }
        }
    }

    private String fixMapURL(String mapURL) {
        if (UIUtils.isWindows()) {
            mapURL = "file:///" + mapURL.replace("\\", "/");
        }
        return mapURL;
    }

    public void dispose() {
        if (this.tmpMapDirectory != null) {
            try {
                FileUtils.deleteDirectory((File)this.tmpMapDirectory.toFile());
            }
            catch (IOException e) {
                MapActivator.logError(Messages.MapTile_ErrorTemporaryDirectoryDelete, e);
            }
        }
        if (this.mapControl != null) {
            this.mapControl.dispose();
        }
    }
}

