/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.hibernate.classpath;

import com.jaspersoft.studio.hibernate.HibernateActivator;
import com.jaspersoft.studio.hibernate.messages.Messages;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.osgi.framework.Bundle;

public class HibernateClasspathContainer
implements IClasspathContainer {
    public static final IPath ID = new Path("com.jaspersoft.studio.data.hibernate.HIBERNATE_5_4_24_FINAL_CONTAINER");
    private IPath path;

    public HibernateClasspathContainer(IPath path) {
        this.path = path;
    }

    public IClasspathEntry[] getClasspathEntries() {
        ArrayList<IClasspathEntry> hibernateItems = new ArrayList<IClasspathEntry>();
        Bundle bundle = HibernateActivator.getDefault().getBundle();
        Enumeration urls = bundle.findEntries("lib/", "*.jar", false);
        while (urls.hasMoreElements()) {
            URL url = (URL)urls.nextElement();
            try {
                Path binpath;
                URL fileURL = FileLocator.toFileURL((URL)url);
                URI uri = new URI(fileURL.getProtocol(), fileURL.getUserInfo(), fileURL.getHost(), fileURL.getPort(), fileURL.getPath(), fileURL.getQuery(), null);
                Path srcpath = binpath = new Path(new File(uri).getAbsolutePath());
                hibernateItems.add(JavaCore.newLibraryEntry((IPath)binpath, (IPath)srcpath, (IPath)new Path("/")));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return hibernateItems.toArray(new IClasspathEntry[hibernateItems.size()]);
    }

    public String getDescription() {
        return Messages.HibernateClasspathContainer_Description;
    }

    public int getKind() {
        return 1;
    }

    public IPath getPath() {
        return this.path;
    }
}

