/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.indexing;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileVisitResult;
import java.nio.file.attribute.BasicFileAttributes;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.internal.compiler.util.JRTUtil;
import org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.index.Index;
import org.eclipse.jdt.internal.core.index.IndexLocation;
import org.eclipse.jdt.internal.core.search.JavaSearchDocument;
import org.eclipse.jdt.internal.core.search.indexing.BinaryContainer;
import org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.eclipse.jdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.jdt.internal.core.search.processing.JobManager;

public class AddJrtToIndex
extends BinaryContainer {
    IFile resource;
    private IndexLocation indexFileURL;
    private final boolean forceIndexUpdate;
    static final char JAR_SEPARATOR = "|".charAt(0);

    public AddJrtToIndex(IFile resource, IndexLocation indexFile, IndexManager manager, boolean updateIndex) {
        super(resource.getFullPath(), manager);
        this.resource = resource;
        this.indexFileURL = indexFile;
        this.forceIndexUpdate = updateIndex;
    }

    public AddJrtToIndex(IPath jrtPath, IndexLocation indexFile, IndexManager manager, boolean updateIndex) {
        super(jrtPath, manager);
        this.indexFileURL = indexFile;
        this.forceIndexUpdate = updateIndex;
    }

    public boolean equals(Object o) {
        if (o instanceof AddJrtToIndex) {
            if (this.resource != null) {
                return this.resource.equals((Object)((AddJrtToIndex)o).resource);
            }
            if (this.containerPath != null) {
                return this.containerPath.equals((Object)((AddJrtToIndex)o).containerPath);
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.resource != null) {
            return this.resource.hashCode();
        }
        if (this.containerPath != null) {
            return this.containerPath.hashCode();
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean execute(IProgressMonitor progressMonitor) {
        if (this.isCancelled) return true;
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return true;
        }
        if (this.hasPreBuiltIndex()) {
            boolean added = this.manager.addIndex(this.containerPath, this.indexFileURL);
            if (added) {
                return true;
            }
            this.indexFileURL = null;
        }
        try {
            if (this.manager.getIndexForUpdate(this.containerPath, false, false) != null) {
                if (!JobManager.VERBOSE) return true;
                org.eclipse.jdt.internal.core.util.Util.verbose("-> no indexing required (index already exists) for " + String.valueOf(this.containerPath));
                return true;
            }
            Index index = this.manager.getIndexForUpdate(this.containerPath, true, true);
            if (index == null) {
                if (!JobManager.VERBOSE) return true;
                org.eclipse.jdt.internal.core.util.Util.verbose("-> index could not be created for " + String.valueOf(this.containerPath));
                return true;
            }
            index.separator = JAR_SEPARATOR;
            ReadWriteMonitor monitor = index.monitor;
            if (monitor == null) {
                if (!JobManager.VERBOSE) return true;
                org.eclipse.jdt.internal.core.util.Util.verbose("-> index for " + String.valueOf(this.containerPath) + " just got deleted");
                return true;
            }
            try {
                IPath container;
                String fileName;
                monitor.enterWrite();
                if (this.resource != null) {
                    File file;
                    URI location;
                    block34: {
                        location = this.resource.getLocationURI();
                        if (location == null) {
                            return false;
                        }
                        if (JavaModelManager.JRT_ACCESS_VERBOSE) {
                            System.out.println("(" + String.valueOf(Thread.currentThread()) + ") [AddJrtFileToIndex.execute()] Creating ZipFile on " + location.getPath());
                        }
                        file = null;
                        try {
                            file = org.eclipse.jdt.internal.core.util.Util.toLocalFile(location, progressMonitor);
                        }
                        catch (CoreException e) {
                            if (!JobManager.VERBOSE) break block34;
                            org.eclipse.jdt.internal.core.util.Util.verbose("-> failed to index " + location.getPath() + " because of the following exception:");
                            e.printStackTrace();
                        }
                    }
                    if (file == null) {
                        if (!JobManager.VERBOSE) return false;
                        org.eclipse.jdt.internal.core.util.Util.verbose("-> failed to index " + location.getPath() + " because the file could not be fetched");
                        return false;
                    }
                    fileName = file.getAbsolutePath();
                    container = this.resource.getFullPath().makeRelative();
                } else {
                    fileName = this.containerPath.toOSString();
                    container = this.containerPath;
                }
                if (JobManager.VERBOSE) {
                    org.eclipse.jdt.internal.core.util.Util.verbose("-> indexing " + fileName);
                }
                long initialTime = System.currentTimeMillis();
                String[] paths = index.queryDocumentNames("");
                if (paths != null) {
                    boolean needToReindex;
                    int max = paths.length;
                    SimpleLookupTable indexedFileNames = new SimpleLookupTable(max == 0 ? 33 : max + 11);
                    int i = 0;
                    while (true) {
                        if (i >= max) {
                            JRTUtil.walkModuleImage((File)new File(fileName), (JRTUtil.JrtFileVisitor)new JrtTraverser(indexedFileNames), (int)1);
                            boolean bl = needToReindex = indexedFileNames.elementSize != max;
                        }
                        indexedFileNames.put((Object)paths[i], (Object)FILE_INDEX_STATE.DELETED);
                        ++i;
                    }
                    if (!needToReindex) {
                        Object[] valueTable = indexedFileNames.valueTable;
                        int i2 = 0;
                        int l = valueTable.length;
                        while (i2 < l) {
                            if (valueTable[i2] == FILE_INDEX_STATE.DELETED) {
                                needToReindex = true;
                                break;
                            }
                            ++i2;
                        }
                        if (!needToReindex) {
                            if (JobManager.VERBOSE) {
                                org.eclipse.jdt.internal.core.util.Util.verbose("-> no indexing required (index is consistent with library) for " + fileName + " (" + (System.currentTimeMillis() - initialTime) + "ms)");
                            }
                            this.manager.saveIndex(index);
                            return true;
                        }
                    }
                }
                if (!this.manager.resetIndex(this.containerPath)) {
                    this.manager.removeIndex(this.containerPath);
                    return false;
                }
                File jrt = new File(fileName);
                JRTUtil.walkModuleImage((File)jrt, (JRTUtil.JrtFileVisitor)new JrtIndexer(jrt, SearchEngine.getDefaultSearchParticipant(), index, container, this.manager), (int)1);
                if (this.forceIndexUpdate) {
                    this.manager.savePreBuiltIndex(index);
                } else {
                    this.manager.saveIndex(index);
                }
                if (!JobManager.VERBOSE) return true;
                org.eclipse.jdt.internal.core.util.Util.verbose("-> done indexing of " + fileName + " (" + (System.currentTimeMillis() - initialTime) + "ms)");
                return true;
            }
            finally {
                monitor.exitWrite();
            }
        }
        catch (IOException e) {
            org.eclipse.jdt.internal.core.util.Util.log(e, "Failed to index " + String.valueOf(this.containerPath));
            this.manager.removeIndex(this.containerPath);
            return false;
        }
    }

    @Override
    public String getJobFamily() {
        if (this.resource != null) {
            return super.getJobFamily();
        }
        return this.containerPath.toOSString();
    }

    @Override
    protected Integer updatedIndexState() {
        Integer updateState = null;
        updateState = this.hasPreBuiltIndex() ? IndexManager.REUSE_STATE : IndexManager.REBUILDING_STATE;
        return updateState;
    }

    public String toString() {
        return "indexing " + this.containerPath.toString();
    }

    protected boolean hasPreBuiltIndex() {
        return !this.forceIndexUpdate && this.indexFileURL != null && this.indexFileURL.exists();
    }

    static enum FILE_INDEX_STATE {
        EXISTS,
        DELETED;

    }

    private class JrtIndexer
    extends JrtTraverser {
        final SearchParticipant participant;
        final IPath indexPath;
        final IndexManager indexManager;
        final IPath container;
        final Index index;
        final File jrt;

        public JrtIndexer(File jrt, SearchParticipant participant, Index index, IPath container, IndexManager indexManager) {
            this.jrt = jrt;
            this.participant = participant != null ? participant : SearchEngine.getDefaultSearchParticipant();
            this.index = index;
            IndexLocation indexLocation = index.getIndexLocation();
            this.indexPath = indexLocation != null ? new Path(indexLocation.getCanonicalFilePath()) : null;
            this.container = container;
            this.indexManager = indexManager;
        }

        @Override
        public FileVisitResult visitFile(java.nio.file.Path path, java.nio.file.Path mod, BasicFileAttributes attrs) throws IOException {
            String name = JRTUtil.sanitizedFileName((java.nio.file.Path)path);
            if (Util.isClassFileName((String)name) && AddJrtToIndex.this.isValidPackageNameForClassOrisModule(name)) {
                try {
                    String fullPath = path.toString();
                    byte[] classFileBytes = JRTUtil.getClassfileContent((File)this.jrt, (String)fullPath, (String)mod.toString());
                    String docFullPath = this.container.toString() + JAR_SEPARATOR + mod.toString() + JAR_SEPARATOR + fullPath;
                    JavaSearchDocument entryDocument = new JavaSearchDocument(docFullPath, classFileBytes, this.participant);
                    this.indexManager.indexDocument(entryDocument, this.participant, this.index, this.indexPath);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return FileVisitResult.CONTINUE;
        }
    }

    private class JrtTraverser
    implements JRTUtil.JrtFileVisitor<java.nio.file.Path> {
        SimpleLookupTable indexedFileNames;

        public JrtTraverser() {
        }

        public JrtTraverser(SimpleLookupTable indexedFileNames) {
            this.indexedFileNames = indexedFileNames;
        }

        public FileVisitResult visitPackage(java.nio.file.Path dir, java.nio.file.Path mod, BasicFileAttributes attrs) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        public FileVisitResult visitFile(java.nio.file.Path path, java.nio.file.Path mod, BasicFileAttributes attrs) throws IOException {
            String name = JRTUtil.sanitizedFileName((java.nio.file.Path)path);
            if (Util.isClassFileName((String)name) && AddJrtToIndex.this.isValidPackageNameForClassOrisModule(name)) {
                this.indexedFileNames.put((Object)name, (Object)FILE_INDEX_STATE.EXISTS);
            }
            return FileVisitResult.CONTINUE;
        }

        public FileVisitResult visitModule(java.nio.file.Path path, String name) throws IOException {
            return FileVisitResult.CONTINUE;
        }
    }
}

