/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.book.bundle;

import com.jaspersoft.studio.book.bundle.BookTemplateEngine;
import com.jaspersoft.studio.book.bundle.PartContainer;
import com.jaspersoft.studio.book.messages.MessagesByKeys;
import com.jaspersoft.studio.book.wizards.BookWizardDataSourceDynamicPage;
import com.jaspersoft.studio.book.wizards.BookWizardFieldsDynamicPage;
import com.jaspersoft.studio.book.wizards.BookWizardSectionsDynamicPage;
import com.jaspersoft.studio.compatibility.JRXmlWriterHelper;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.wizards.ReportNewWizard;
import com.jaspersoft.studio.wizards.WizardUtils;
import com.jaspersoft.templates.ReportBundle;
import com.jaspersoft.templates.TemplateBundle;
import com.jaspersoft.templates.TemplateEngine;
import com.jaspersoft.templates.WizardTemplateBundle;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRReportTemplate;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ui.ide.IDE;

public class BookTemplateBundle
extends WizardTemplateBundle {
    public static final String COVER_SETTING = "book_cover";
    public static final String TOC_SETTING = "book_toc";
    public static final String BACK_COVER_SETTING = "book_backcover";
    private BookWizardDataSourceDynamicPage step1 = null;
    private BookWizardFieldsDynamicPage step2 = null;
    private BookWizardSectionsDynamicPage step3 = null;
    private PartContainer coverPart = null;
    private PartContainer backcoverPart = null;
    private PartContainer tocPart = null;
    private PartContainer mainPart = null;
    private URL mainTemplteURL = null;

    public BookTemplateBundle(URL url, boolean isExternal, JasperReportsContext jrContext) throws Exception {
        super(url, isExternal, jrContext);
        if (isExternal) {
            this.loadExternalResources(url);
        } else {
            this.loadInternalResources(url);
        }
        this.mainTemplteURL = url;
    }

    public IFile doFinish(ReportNewWizard mainWizard, IProgressMonitor monitor) throws CoreException {
        IFile reportFile = null;
        Map settings = mainWizard.getSettings();
        String containerName = (String)settings.get("containerNameKey");
        String fileName = (String)settings.get("fileNameKey");
        monitor.beginTask(String.valueOf(Messages.ReportNewWizard_3) + fileName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            this.throwCoreException(String.format(Messages.ReportNewWizard_4, containerName));
        }
        JasperReportsConfiguration jConfig = mainWizard.getConfig();
        HashMap<String, Object> templateSettings = new HashMap<String, Object>();
        JRDesignDataset dataset = WizardUtils.createDataset((JasperReportsContext)jConfig, (boolean)true, (Map)settings);
        templateSettings.put("main_dataset", dataset);
        templateSettings.put("containerNameKey", containerName);
        templateSettings.put("fileNameKey", fileName);
        if (settings.containsKey("dataset_fields")) {
            templateSettings.put("main_fields", settings.get("dataset_fields"));
        }
        if (settings.containsKey("group_fields")) {
            templateSettings.put("main_group_fields", settings.get("group_fields"));
        }
        if (settings.containsKey(COVER_SETTING)) {
            templateSettings.put(COVER_SETTING, settings.get(COVER_SETTING));
        } else {
            templateSettings.put(COVER_SETTING, true);
        }
        if (settings.containsKey(TOC_SETTING)) {
            templateSettings.put(TOC_SETTING, settings.get(TOC_SETTING));
        } else {
            templateSettings.put(TOC_SETTING, true);
        }
        if (settings.containsKey(BACK_COVER_SETTING)) {
            templateSettings.put(BACK_COVER_SETTING, settings.get(BACK_COVER_SETTING));
        } else {
            templateSettings.put(BACK_COVER_SETTING, true);
        }
        TemplateEngine templateEngine = this.getTemplateEngine();
        Closeable stream = null;
        try {
            this.saveReportBundleResources(monitor, (TemplateBundle)this, this.getReportContainer(mainWizard));
            ReportBundle reportBundle = templateEngine.generateReportBundle((TemplateBundle)this, templateSettings, (JasperReportsContext)jConfig);
            if (this.step1.getDataAdapter() != null) {
                Object props = settings.get("dataset_properties");
                JRPropertiesMap pmap = new JRPropertiesMap();
                if (props != null && props instanceof JRPropertiesMap) {
                    pmap = (JRPropertiesMap)props;
                }
                templateEngine.setReportDataAdapter(reportBundle, this.step1.getDataAdapter(), pmap, jConfig);
            }
            reportFile = this.saveBundleIntoFile(reportBundle, mainWizard, jConfig, monitor);
            IDE.setDefaultEditor((IFile)reportFile, (String)"com.jaspersoft.studio.book.editors.JRBookEditor");
            this.saveSections(containerName, fileName, templateSettings, monitor);
            this.clearLoadedParts();
        }
        catch (Exception e) {
            UIUtils.showError((Throwable)e);
        }
        FileUtils.closeStream(stream);
        return reportFile;
    }

    private void clearLoadedParts() {
        if (this.coverPart != null) {
            this.coverPart.clearDesign();
        }
        if (this.backcoverPart != null) {
            this.backcoverPart.clearDesign();
        }
        if (this.tocPart != null) {
            this.tocPart.clearDesign();
        }
        if (this.mainPart != null) {
            this.mainPart.clearDesign();
        }
    }

    protected void saveSections(String containerName, String fileName, Map<String, Object> templateSettings, IProgressMonitor monitor) {
        boolean crateMain;
        boolean createToc;
        boolean createBackcover;
        boolean createCover;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        IContainer container = (IContainer)resource;
        String prefix = fileName.replace(".jrxml", "");
        boolean bl = createCover = (Boolean)templateSettings.get(COVER_SETTING) != false && this.coverPart != null;
        if (createCover) {
            this.saveDesignResource(this.coverPart.getJasperDesign(), container, String.valueOf(prefix) + "_cover.jrxml", monitor);
        }
        boolean bl2 = createBackcover = (Boolean)templateSettings.get(BACK_COVER_SETTING) != false && this.backcoverPart != null;
        if (createBackcover) {
            this.saveDesignResource(this.backcoverPart.getJasperDesign(), container, String.valueOf(prefix) + "_backcover.jrxml", monitor);
        }
        boolean bl3 = createToc = (Boolean)templateSettings.get(TOC_SETTING) != false && this.tocPart != null;
        if (createToc) {
            this.saveDesignResource(this.tocPart.getJasperDesign(), container, String.valueOf(prefix) + "_toc.jrxml", monitor);
        }
        boolean bl4 = crateMain = this.mainPart != null;
        if (crateMain) {
            this.saveDesignResource(this.mainPart.getJasperDesign(), container, String.valueOf(prefix) + "_main.jrxml", monitor);
        }
    }

    protected void saveDesignResource(JasperDesign design, IContainer container, String resourceName, IProgressMonitor monitor) {
        block8: {
            if (design != null) {
                IFile resourceFile = null;
                resourceFile = container instanceof IProject ? ((IProject)container).getFile(resourceName) : (container instanceof IFolder ? ((IFolder)container).getFile(resourceName) : container.getFile(container.getFullPath().append(resourceName)));
                ByteArrayInputStream stream = null;
                try {
                    try {
                        String contents = JRXmlWriterHelper.writeReport((JasperReportsConfiguration)JasperReportsConfiguration.getDefaultInstance(), (JRReport)design, (IFile)resourceFile, (boolean)false);
                        stream = new ByteArrayInputStream(contents.getBytes());
                        if (resourceFile.exists()) {
                            resourceFile.setContents((InputStream)stream, true, true, monitor);
                        } else {
                            resourceFile.create((InputStream)stream, true, monitor);
                        }
                        this.saveAdditionalDesignResources(design, container, monitor);
                    }
                    catch (Exception exception) {
                        FileUtils.closeStream(stream);
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    FileUtils.closeStream(stream);
                    throw throwable;
                }
                FileUtils.closeStream((Closeable)stream);
            }
        }
    }

    protected void saveAdditionalDesignResources(JasperDesign jd, IContainer container, IProgressMonitor monitor) {
        String res;
        ArrayList<String> additionalResourceNames = new ArrayList<String>();
        List list = ModelUtils.getAllGElements((JasperDesign)jd);
        for (JRDesignElement el : list) {
            JRSubreport sr;
            JRImage im;
            if (el instanceof JRImage && (res = this.evalResourceName((im = (JRImage)el).getExpression())) != null) {
                additionalResourceNames.add(res);
            }
            if (!(el instanceof JRSubreport) || !(res = this.evalResourceName((sr = (JRSubreport)el).getExpression())).endsWith(".jasper")) continue;
            res = String.valueOf(res.substring(0, res.length() - ".jasper".length())) + ".jrxml";
            additionalResourceNames.add(res);
        }
        List templates = this.getJasperDesign().getTemplatesList();
        for (JRReportTemplate t : templates) {
            res = this.evalResourceName(t.getSourceExpression());
            if (res == null) continue;
            additionalResourceNames.add(res);
        }
        for (String resourceName : additionalResourceNames) {
            IFile resourceFile = container.getFile((IPath)new Path(resourceName));
            InputStream is = null;
            try {
                try {
                    if (!resourceFile.exists() && (is = this.getAdditionalResource(resourceName)) != null) {
                        resourceFile.create(is, true, monitor);
                    }
                }
                catch (Exception e) {
                    UIUtils.showError((Throwable)e);
                    FileUtils.closeStream(is);
                    continue;
                }
            }
            catch (Throwable throwable) {
                FileUtils.closeStream(is);
                throw throwable;
            }
            FileUtils.closeStream(is);
        }
    }

    public InputStream getAdditionalResource(String name) {
        String url = this.mainTemplteURL.toString();
        String mainFileName = new File(this.mainTemplteURL.getFile()).getName();
        url = String.valueOf(url.substring(0, url.length() - mainFileName.length())) + name;
        try {
            URL resourceURL = new URL(url);
            return resourceURL.openStream();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void wizardClosed() {
        this.step1 = null;
        this.step2 = null;
        this.step3 = null;
    }

    public WizardPage[] getCustomWizardPages() {
        boolean showSectionsPage;
        ArrayList<Object> result = new ArrayList<Object>();
        if (this.step1 == null) {
            this.step1 = new BookWizardDataSourceDynamicPage(this);
        }
        if (this.step2 == null) {
            this.step2 = new BookWizardFieldsDynamicPage(this);
        }
        if ((showSectionsPage = this.shouldShowSectionsPage()) || this.step3 == null) {
            this.step3 = new BookWizardSectionsDynamicPage(this);
        }
        result.add((Object)this.step1);
        result.add((Object)this.step2);
        if (showSectionsPage) {
            result.add((Object)this.step3);
        }
        return result.toArray(new WizardPage[result.size()]);
    }

    private boolean shouldShowSectionsPage() {
        Object showSectionsProperty = this.getProperty("template.booksections.showpage");
        boolean showSectionsPage = true;
        if (showSectionsProperty instanceof String) {
            showSectionsPage = Boolean.parseBoolean((String)showSectionsProperty);
        }
        return showSectionsPage;
    }

    public BookWizardDataSourceDynamicPage getStep1() {
        return this.step1;
    }

    public BookWizardFieldsDynamicPage getStep2() {
        return this.step2;
    }

    public BookWizardSectionsDynamicPage getStep3() {
        return this.shouldShowSectionsPage() ? this.step3 : null;
    }

    public JasperDesign getCover() {
        if (this.coverPart != null) {
            return this.coverPart.getJasperDesign();
        }
        return null;
    }

    public JasperDesign getBackCover() {
        if (this.backcoverPart != null) {
            return this.backcoverPart.getJasperDesign();
        }
        return null;
    }

    public JasperDesign getTOC() {
        if (this.tocPart != null) {
            return this.tocPart.getJasperDesign();
        }
        return null;
    }

    public JasperDesign getMain() {
        if (this.mainPart != null) {
            return this.mainPart.getJasperDesign();
        }
        return null;
    }

    protected void readProperties() {
        super.readProperties();
        this.templateEngine = new BookTemplateEngine();
    }

    private void loadExternalResources(URL templateDocument) {
        File reportFile = new File(templateDocument.getFile());
        if (reportFile.exists()) {
            String prefix = reportFile.getName().replace(".jrxml", "");
            String coverName = String.valueOf(prefix) + "_cover.jrxml.part";
            String backCoverName = String.valueOf(prefix) + "_backcover.jrxml.part";
            String tocName = String.valueOf(prefix) + "_toc.jrxml.part";
            String mainName = String.valueOf(prefix) + "_main.jrxml.part";
            String parentPath = reportFile.getParentFile() + File.separator;
            this.coverPart = new PartContainer(String.valueOf(parentPath) + coverName);
            this.backcoverPart = new PartContainer(String.valueOf(parentPath) + backCoverName);
            this.tocPart = new PartContainer(String.valueOf(parentPath) + tocName);
            this.mainPart = new PartContainer(String.valueOf(parentPath) + mainName);
        }
    }

    private PartContainer getPartFromName(String hostPlugin, String fileName) {
        try {
            URL pathUrl = new URL("bundleentry", hostPlugin, fileName);
            return new PartContainer(pathUrl);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void loadInternalResources(URL templateDocument) {
        File reportFile = new File(templateDocument.getFile());
        String prefix = reportFile.getName().replace(".jrxml", "");
        String coverName = String.valueOf(prefix) + "_cover.jrxml.part";
        String backCoverName = String.valueOf(prefix) + "_backcover.jrxml.part";
        String tocName = String.valueOf(prefix) + "_toc.jrxml.part";
        String mainName = String.valueOf(prefix) + "_main.jrxml.part";
        String folder = "/templates/book/";
        this.coverPart = this.getPartFromName(templateDocument.getHost(), String.valueOf(folder) + coverName);
        this.backcoverPart = this.getPartFromName(templateDocument.getHost(), String.valueOf(folder) + backCoverName);
        this.tocPart = this.getPartFromName(templateDocument.getHost(), String.valueOf(folder) + tocName);
        this.mainPart = this.getPartFromName(templateDocument.getHost(), String.valueOf(folder) + mainName);
    }

    public String getLocalizedString(String key) {
        if (MessagesByKeys.hasTranslation(key)) {
            return MessagesByKeys.getString(key);
        }
        return super.getLocalizedString(key);
    }

    public boolean hasSupportForSubreport() {
        return false;
    }
}

