/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.book.bundle;

import com.jaspersoft.studio.templates.engine.DefaultTemplateEngine;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.templates.ReportBundle;
import com.jaspersoft.templates.TemplateBundle;
import com.jaspersoft.templates.TemplateEngineException;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRPart;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignQuery;
import net.sf.jasperreports.engine.design.JRDesignSection;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.part.PartComponent;
import net.sf.jasperreports.parts.subreport.StandardSubreportPartComponent;

public class BookTemplateEngine
extends DefaultTemplateEngine {
    public ReportBundle generateReportBundle(TemplateBundle template, Map<String, Object> settings, JasperReportsContext jContext) throws TemplateEngineException {
        JRDesignDataset dataset;
        JasperDesign jdCopy = null;
        try {
            jdCopy = ModelUtils.copyJasperDesign((JasperReportsContext)jContext, (JasperDesign)template.getJasperDesign());
        }
        catch (JRException e) {
            UIUtils.showError((Throwable)e);
            return null;
        }
        boolean hasCover = (Boolean)settings.get("book_cover");
        boolean hasToc = (Boolean)settings.get("book_toc");
        boolean hasBackCover = (Boolean)settings.get("book_backcover");
        String templateBaseName = (String)settings.get("fileNameKey");
        templateBaseName = templateBaseName.substring(0, templateBaseName.length() - ".jrxml".length());
        JRPart part = this.findPartByExpression(jdCopy, "\"cover\"");
        if (!hasCover) {
            this.deletePart(jdCopy, part);
        } else {
            this.setPartExpression(part, "\"" + templateBaseName + "_cover.jasper\"");
        }
        part = this.findPartByExpression(jdCopy, "\"toc\"");
        if (!hasToc) {
            this.deletePart(jdCopy, part);
        } else {
            this.setPartExpression(part, "\"" + templateBaseName + "_toc.jasper\"");
        }
        part = this.findPartByExpression(jdCopy, "\"backcover\"");
        if (!hasBackCover) {
            this.deletePart(jdCopy, part);
        } else {
            this.setPartExpression(part, "\"" + templateBaseName + "_backcover.jasper\"");
        }
        List fields = (List)settings.get("main_fields");
        if (fields != null) {
            for (Object obj : fields) {
                JRDesignField f = (JRDesignField)obj;
                try {
                    jdCopy.addField((JRField)f);
                }
                catch (JRException e) {
                    e.printStackTrace();
                }
            }
        }
        if ((dataset = (JRDesignDataset)settings.get("main_dataset")) != null) {
            jdCopy.getMainDesignDataset().setQuery((JRDesignQuery)dataset.getQuery());
        }
        ReportBundle rb = new ReportBundle(template);
        rb.setJasperDesign(jdCopy);
        return rb;
    }

    private JRPart findPartByExpression(JasperDesign jd, String expression) {
        JRGroup[] jRGroupArray = jd.getGroups();
        int n = jRGroupArray.length;
        int n2 = 0;
        while (n2 < n) {
            StandardSubreportPartComponent subComponent;
            PartComponent partComponent;
            JRPart part;
            JRGroup group = jRGroupArray[n2];
            JRPart[] jRPartArray = group.getGroupHeaderSection().getParts();
            int n3 = jRPartArray.length;
            int n4 = 0;
            while (n4 < n3) {
                part = jRPartArray[n4];
                partComponent = part.getComponent();
                if (partComponent != null && partComponent instanceof StandardSubreportPartComponent && (subComponent = (StandardSubreportPartComponent)partComponent).getExpression() != null && subComponent.getExpression().getText().equals(expression)) {
                    return part;
                }
                ++n4;
            }
            jRPartArray = group.getGroupFooterSection().getParts();
            n3 = jRPartArray.length;
            n4 = 0;
            while (n4 < n3) {
                part = jRPartArray[n4];
                partComponent = part.getComponent();
                if (partComponent != null && partComponent instanceof StandardSubreportPartComponent && (subComponent = (StandardSubreportPartComponent)partComponent).getExpression() != null && subComponent.getExpression().getText().equals(expression)) {
                    return part;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    private void deletePart(JasperDesign jd, JRPart partToDelete) {
        if (partToDelete == null) {
            return;
        }
        JRGroup[] jRGroupArray = jd.getGroups();
        int n = jRGroupArray.length;
        int n2 = 0;
        while (n2 < n) {
            JRPart part;
            JRGroup group = jRGroupArray[n2];
            JRPart[] jRPartArray = group.getGroupHeaderSection().getParts();
            int n3 = jRPartArray.length;
            int n4 = 0;
            while (n4 < n3) {
                part = jRPartArray[n4];
                if (part == partToDelete) {
                    ((JRDesignSection)group.getGroupFooterSection()).removePart(partToDelete);
                }
                ++n4;
            }
            jRPartArray = group.getGroupFooterSection().getParts();
            n3 = jRPartArray.length;
            n4 = 0;
            while (n4 < n3) {
                part = jRPartArray[n4];
                if (part == partToDelete) {
                    ((JRDesignSection)group.getGroupFooterSection()).removePart(partToDelete);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void setPartExpression(JRPart part, String expression) {
        if (part == null) {
            return;
        }
        PartComponent partComponent = part.getComponent();
        if (partComponent != null && partComponent instanceof StandardSubreportPartComponent) {
            StandardSubreportPartComponent subComponent = (StandardSubreportPartComponent)partComponent;
            subComponent.setExpression((JRExpression)new JRDesignExpression(expression));
        }
    }
}

