/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.book.editors.figures;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Timer;
import java.util.TimerTask;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Image;

public class BusyImageFigure
extends ImageFigure {
    protected boolean busy = false;
    private Timer timer = null;
    private int angle = 0;
    private int LINES = 12;
    private int blackPosition = 0;

    public boolean isBusy() {
        return this.busy;
    }

    public void setBusy(boolean busy) {
        if (busy != this.busy) {
            this.busy = busy;
            if (this.busy) {
                this.timer = new Timer();
                this.timer.scheduleAtFixedRate(new TimerTask(){

                    @Override
                    public void run() {
                        BusyImageFigure.this.angle += 360 / BusyImageFigure.this.LINES;
                        ++BusyImageFigure.this.blackPosition;
                        BusyImageFigure.this.blackPosition %= BusyImageFigure.this.LINES;
                        if (BusyImageFigure.this.angle >= 360) {
                            BusyImageFigure.this.angle = 0;
                        }
                        if (UIUtils.getDisplay() == null || UIUtils.getDisplay().isDisposed()) {
                            return;
                        }
                        UIUtils.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                BusyImageFigure.this.revalidate();
                                BusyImageFigure.this.notifyImageChanged();
                                BusyImageFigure.this.repaint();
                            }
                        });
                    }
                }, 0L, 150L);
            } else if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
        }
        this.busy = busy;
    }

    public BusyImageFigure(Image image) {
        super(image);
    }

    public void paint(Graphics g) {
        Rectangle area = this.getBounds().getShrinked(this.getInsets());
        if (this.busy) {
            Image icon = this.createBusyIcon();
            if (icon != null) {
                g.drawImage(icon, new Point(area.x + area.width / 2 - icon.getImageData().width / 2, area.y + area.height / 2 - icon.getImageData().height / 2));
                icon.dispose();
            } else {
                System.out.println("Icon is null!!");
            }
        } else if (this.getImage() != null) {
            g.pushState();
            try {
                Image image = this.getImage();
                int scaledX = (area.width - (int)Math.round((double)image.getImageData().width / g.getAbsoluteScale())) / 2 + area.x;
                int scaledY = (area.height - (int)Math.round((double)image.getImageData().height / g.getAbsoluteScale())) / 2 + area.y;
                int scaledHeight = (int)Math.round((double)image.getImageData().height / g.getAbsoluteScale());
                int scaledWidth = (int)Math.round((double)image.getImageData().width / g.getAbsoluteScale());
                g.drawImage(image, 0, 0, image.getImageData().width, image.getImageData().height, scaledX, scaledY, scaledWidth, scaledHeight);
                g.restoreState();
            }
            finally {
                g.popState();
            }
        }
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        return new Dimension(150, 130);
    }

    private Image createBusyIcon() {
        int w = 36;
        int h = 36;
        BufferedImage bufImage = new BufferedImage(w, h, 2);
        Graphics2D g2 = bufImage.createGraphics();
        int cx = w / 2;
        int cy = h / 2;
        int lineSize = 6;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setStroke(new BasicStroke(1.5f, 1, 1));
        g2.setPaint(Color.white);
        g2.fillRect(0, 0, bufImage.getWidth(), bufImage.getHeight());
        g2.rotate(Math.PI * (double)this.angle / 180.0, cx, cy);
        int i = 0;
        while (i < this.LINES) {
            int alpha = this.LINES - this.blackPosition - i;
            if (alpha < 0) {
                alpha += this.LINES;
            }
            g2.setColor(new Color(115, 115, 146, (int)(255.0f / (float)this.LINES * (float)alpha)));
            g2.drawLine(cx + lineSize, cy, cx + lineSize * 2, cy);
            g2.rotate(-0.5235987755982988, cx, cy);
            ++i;
        }
        return UIUtils.awt2Swt((BufferedImage)bufImage);
    }
}

