/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.book.editparts;

import com.jaspersoft.studio.book.ReportThumbnailsManager;
import com.jaspersoft.studio.book.dnd.PageEditPartTracker;
import com.jaspersoft.studio.book.editors.figures.BookPagesFigure;
import com.jaspersoft.studio.book.messages.Messages;
import com.jaspersoft.studio.book.model.MReportPart;
import com.jaspersoft.studio.book.model.MReportPartContainer;
import com.jaspersoft.studio.book.model.commands.CreatePartAfterCommand;
import com.jaspersoft.studio.book.model.commands.RemoveChildrenCommand;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.utils.ExpressionUtil;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRExpression;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.editpolicies.OrderedLayoutEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class BookPagesEditPart
extends AbstractGraphicalEditPart {
    private BookPagesFigure figure = null;
    private PageEditPartTracker dragTracker;
    private ImageFigure sourceFeedbackFigure = null;
    private PropertyChangeListener updatePart = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent arg0) {
            BookPagesEditPart.this.figure.updateText();
            BookPagesEditPart.this.refresh();
        }
    };

    public BookPagesEditPart() {
        this.dragTracker = new PageEditPartTracker((EditPart)this);
    }

    public void setModel(Object model) {
        MReportPart bookModel;
        if (this.getModel() != null) {
            bookModel = (MReportPart)((Object)this.getModel());
            bookModel.getPropertyChangeSupport().removePropertyChangeListener(this.updatePart);
        }
        super.setModel(model);
        if (this.getModel() != null) {
            bookModel = (MReportPart)((Object)this.getModel());
            bookModel.getPropertyChangeSupport().addPropertyChangeListener(this.updatePart);
        }
    }

    protected IFigure createFigure() {
        if (this.figure == null) {
            Image cachedFigureSwtImage = null;
            if (this.getModel() != null && ((MReportPart)((Object)this.getModel())).getValue() != null) {
                MReportPart bookModel = (MReportPart)((Object)this.getModel());
                cachedFigureSwtImage = ReportThumbnailsManager.popElementImage(bookModel.getValue().getUUID().toString());
            }
            this.figure = new BookPagesFigure((MReportPart)((Object)this.getModel()), cachedFigureSwtImage);
        }
        return this.figure;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new OrderedLayoutEditPolicy(){

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }

            protected EditPart getInsertionReference(Request request) {
                return null;
            }

            protected Command createMoveChildCommand(EditPart child, EditPart after) {
                if (BookPagesEditPart.this.dragTracker.getContainer() != null) {
                    CompoundCommand cc = new CompoundCommand();
                    MReportPartContainer sourceContainer = (MReportPartContainer)((Object)child.getParent().getModel());
                    MReportPartContainer targetContainer = BookPagesEditPart.this.dragTracker.getContainer().getBookModel();
                    MReportPart movedElement = (MReportPart)((Object)child.getModel());
                    MReportPart afterElement = BookPagesEditPart.this.dragTracker.getAfterPart() != null ? (MReportPart)((Object)BookPagesEditPart.this.dragTracker.getAfterPart().getModel()) : null;
                    Image partImage = ((BookPagesFigure)((BookPagesEditPart)child).getFigure()).getThubmnailImage();
                    if (partImage != null) {
                        ReportThumbnailsManager.pushElementImage(movedElement.getValue().getUUID().toString(), partImage);
                    }
                    RemoveChildrenCommand removeCommand = new RemoveChildrenCommand(sourceContainer, movedElement);
                    cc.add((Command)removeCommand);
                    CreatePartAfterCommand createCommmand = new CreatePartAfterCommand(targetContainer, movedElement.getValue(), afterElement);
                    cc.add((Command)createCommmand);
                    return cc;
                }
                return null;
            }

            protected Command createAddCommand(EditPart child, EditPart after) {
                return this.createMoveChildCommand(child, after);
            }
        });
        NonResizableEditPolicy selectionPolicy = new NonResizableEditPolicy(){

            protected IFigure createDragSourceFeedbackFigure() {
                if (BookPagesEditPart.this.sourceFeedbackFigure == null) {
                    BookPagesEditPart.this.sourceFeedbackFigure = new ImageFigure(((BookPagesFigure)BookPagesEditPart.this.getFigure()).getThubmnailImage());
                }
                this.addFeedback((IFigure)BookPagesEditPart.this.sourceFeedbackFigure);
                return BookPagesEditPart.this.sourceFeedbackFigure;
            }

            public Command getCommand(Request request) {
                return null;
            }
        };
        selectionPolicy.setDragAllowed(true);
        this.installEditPolicy("Selection Feedback", (EditPolicy)selectionPolicy);
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ComponentEditPolicy(){

            protected Command createDeleteCommand(GroupRequest deleteRequest) {
                return new RemoveChildrenCommand((MReportPartContainer)((MReportPart)((Object)this.getHost().getModel())).getParent(), (MReportPart)((Object)this.getHost().getModel()));
            }
        });
    }

    public Command getCommand(Request request) {
        if (this.getParent() == null) {
            return null;
        }
        return super.getCommand(request);
    }

    public DragTracker getDragTracker(Request request) {
        return this.dragTracker;
    }

    public void showTargetFeedback(Request request) {
        if (this.getParent() != null) {
            this.getParent().showTargetFeedback(request);
        }
    }

    public void eraseTargetFeedback(Request request) {
        if (this.getParent() != null) {
            this.getParent().eraseTargetFeedback(request);
        }
    }

    public void performRequest(Request req) {
        if (req.getType() == "open") {
            JasperReportsConfiguration jConfig;
            MReportPart part = (MReportPart)((Object)this.getModel());
            JRExpression expression = (JRExpression)part.getPropertyValue("component_expression");
            String path = ExpressionUtil.cachedExpressionEvaluationString((JRExpression)expression, (JasperReportsConfiguration)(jConfig = part.getJasperConfiguration()));
            if (path == null) {
                return;
            }
            File file = this.getResource(path, jConfig);
            if (file != null && file.exists() && file.isFile()) {
                IFileStore fileStore = EFS.getLocalFileSystem().getStore(file.toURI());
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            } else {
                MessageDialog.openError((Shell)UIUtils.getShell(), (String)Messages.BookPagesEditPart_errorTitle, (String)Messages.BookPagesEditPart_errorDescription);
            }
        }
    }

    private File getResource(String location, JasperReportsConfiguration context) {
        File jrxmFile;
        File f = ReportThumbnailsManager.findFile(location, context);
        if (location.toLowerCase().endsWith(".jasper") && (jrxmFile = ReportThumbnailsManager.findFile(location = String.valueOf(location.substring(0, location.length() - ".jasper".length())) + ".jrxml", context)) != null && jrxmFile.exists()) {
            f = jrxmFile;
            return f;
        }
        return f;
    }

    public void deactivate() {
        if (this.figure != null) {
            this.figure.dispose();
        }
        if (this.getModel() != null) {
            APropertyNode bookModel = (APropertyNode)this.getModel();
            bookModel.getPropertyChangeSupport().removePropertyChangeListener(this.updatePart);
        }
        super.deactivate();
    }
}

