/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.book.editparts;

import com.jaspersoft.studio.book.ReportThumbnailsManager;
import com.jaspersoft.studio.book.dnd.PageEditPartTracker;
import com.jaspersoft.studio.book.editors.figures.BookPagesFigure;
import com.jaspersoft.studio.book.editors.figures.BookSectionFigure;
import com.jaspersoft.studio.book.editparts.BookPagesEditPart;
import com.jaspersoft.studio.book.model.MGroupReportPartContainer;
import com.jaspersoft.studio.book.model.MReportPart;
import com.jaspersoft.studio.book.model.MReportPartContainer;
import com.jaspersoft.studio.book.model.commands.CreatePartAfterCommand;
import com.jaspersoft.studio.book.model.commands.CreatePartCommand;
import com.jaspersoft.studio.book.model.commands.RemoveChildrenCommand;
import com.jaspersoft.studio.book.model.commands.RemoveSectionCommand;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.INode;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Transposer;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.editpolicies.OrderedLayoutEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.swt.graphics.Image;

public class BookSectionEditPart
extends AbstractGraphicalEditPart {
    private BookSectionFigure figure = null;
    private PageEditPartTracker dragTracker;
    private PropertyChangeListener updatePart = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent arg0) {
            BookSectionEditPart.this.figure.repaint();
            BookSectionEditPart.this.refresh();
        }
    };

    public BookSectionEditPart() {
        this.dragTracker = new PageEditPartTracker((EditPart)this);
    }

    public void setModel(Object model) {
        MReportPartContainer bookModel;
        if (this.getModel() != null) {
            bookModel = (MReportPartContainer)((Object)this.getModel());
            bookModel.getPropertyChangeSupport().removePropertyChangeListener(this.updatePart);
        }
        super.setModel(model);
        if (this.getModel() != null) {
            bookModel = (MReportPartContainer)((Object)this.getModel());
            bookModel.getPropertyChangeSupport().addPropertyChangeListener(this.updatePart);
        }
    }

    protected IFigure createFigure() {
        if (this.figure == null) {
            this.figure = new BookSectionFigure(this);
        }
        return this.figure;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new OrderedLayoutEditPolicy(){

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }

            protected EditPart getInsertionReference(Request request) {
                return null;
            }

            protected Command createMoveChildCommand(EditPart child, EditPart after) {
                if (BookSectionEditPart.this.dragTracker.getContainer() != null) {
                    if (BookSectionEditPart.this.dragTracker.getContainer().getChildren().isEmpty()) {
                        CompoundCommand cc = new CompoundCommand();
                        MReportPartContainer container = BookSectionEditPart.this.dragTracker.getContainer().getBookModel();
                        MReportPart partToCreate = (MReportPart)((Object)child.getModel());
                        MReportPartContainer sourceContainer = (MReportPartContainer)((Object)child.getParent().getModel());
                        MReportPart movedPart = (MReportPart)((Object)child.getModel());
                        Image partImage = ((BookPagesFigure)((BookPagesEditPart)child).getFigure()).getThubmnailImage();
                        if (partImage != null) {
                            ReportThumbnailsManager.pushElementImage(partToCreate.getValue().getUUID().toString(), partImage);
                        }
                        RemoveChildrenCommand removeCommand = new RemoveChildrenCommand(sourceContainer, movedPart);
                        cc.add((Command)removeCommand);
                        CreatePartCommand createCommand = new CreatePartCommand(container, partToCreate.getValue());
                        cc.add((Command)createCommand);
                        return cc;
                    }
                    MReportPartContainer sourceContainer = (MReportPartContainer)((Object)child.getParent().getModel());
                    MReportPartContainer targetContainer = BookSectionEditPart.this.dragTracker.getContainer().getBookModel();
                    MReportPart movedPart = (MReportPart)((Object)child.getModel());
                    MReportPart afterElement = BookSectionEditPart.this.dragTracker.getAfterPart() != null ? (MReportPart)((Object)BookSectionEditPart.this.dragTracker.getAfterPart().getModel()) : null;
                    CompoundCommand cc = new CompoundCommand();
                    Image partImage = ((BookPagesFigure)((BookPagesEditPart)child).getFigure()).getThubmnailImage();
                    if (partImage != null) {
                        ReportThumbnailsManager.pushElementImage(movedPart.getValue().getUUID().toString(), partImage);
                    }
                    RemoveChildrenCommand removeCommand = new RemoveChildrenCommand(sourceContainer, movedPart);
                    cc.add((Command)removeCommand);
                    CreatePartAfterCommand createCommand = new CreatePartAfterCommand(targetContainer, movedPart.getValue(), afterElement);
                    cc.add((Command)createCommand);
                    return cc;
                }
                return null;
            }

            protected Command createAddCommand(EditPart child, EditPart after) {
                return this.createMoveChildCommand(child, after);
            }
        });
        NonResizableEditPolicy selectionPolicy = new NonResizableEditPolicy(){

            protected void showSelection() {
            }

            public Command getCommand(Request request) {
                return null;
            }
        };
        selectionPolicy.setDragAllowed(false);
        this.installEditPolicy("Selection Feedback", (EditPolicy)selectionPolicy);
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ComponentEditPolicy(){

            protected Command createDeleteCommand(GroupRequest deleteRequest) {
                if (BookSectionEditPart.this.getModel() instanceof MGroupReportPartContainer) {
                    return new RemoveSectionCommand((MGroupReportPartContainer)BookSectionEditPart.this.getBookModel());
                }
                return UnexecutableCommand.INSTANCE;
            }
        });
    }

    protected List<Object> getModelChildren() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (INode node : this.getBookModel().getChildren()) {
            if (!(node instanceof MReportPart)) continue;
            list.add(node);
        }
        return list;
    }

    public DragTracker getDragTracker(Request request) {
        return this.dragTracker;
    }

    private Point getLocationFromRequest(Request request) {
        return ((DropRequest)request).getLocation();
    }

    protected Integer getFeedbackIndexFor(Request request) {
        List children = this.getChildren();
        if (children.isEmpty()) {
            return -1;
        }
        Transposer transposer = new Transposer();
        Point pt = transposer.t(this.getLocationFromRequest(request));
        int multiplier = 1;
        while (multiplier < 10) {
            PrecisionPoint ptLeft = new PrecisionPoint(pt.x - 5 * multiplier, pt.y);
            PrecisionPoint ptRight = new PrecisionPoint(pt.x + 5 * multiplier, pt.y);
            EditPart itemLeft = this.getViewer().findObjectAt((Point)ptLeft);
            if (itemLeft != null) {
                return this.getChildren().indexOf(itemLeft);
            }
            EditPart itemRight = this.getViewer().findObjectAt((Point)ptRight);
            if (itemRight != null) {
                int rightItemIndex = this.getChildren().indexOf(itemRight);
                if (rightItemIndex == 0) {
                    return -1;
                }
                return rightItemIndex - 1;
            }
            ++multiplier;
        }
        return null;
    }

    public void showTargetFeedback(EditPart afterPart) {
        if (!this.figure.hasFeedback() || this.figure.afterPart() != afterPart) {
            this.figure.drawFeedback(afterPart);
            this.figure.erase();
        }
    }

    public void eraseTargetFeedback() {
        if (this.figure.hasFeedback()) {
            this.figure.clearFeedback();
            this.figure.erase();
        }
    }

    public MReportPartContainer getBookModel() {
        return (MReportPartContainer)((Object)this.getModel());
    }

    public boolean isLastPart(EditPart part) {
        if (this.getChildren().isEmpty()) {
            return false;
        }
        return this.getChildren().get(this.getChildren().size() - 1) == part;
    }

    public EditPart getFollowingPart(EditPart part) {
        int index = this.getChildren().indexOf(part);
        if (index > -1 && index < this.getChildren().size() - 1) {
            return (EditPart)this.getChildren().get(index + 1);
        }
        return null;
    }

    public void deactivate() {
        if (this.getModel() != null) {
            APropertyNode bookModel = (APropertyNode)this.getModel();
            bookModel.getPropertyChangeSupport().removePropertyChangeListener(this.updatePart);
        }
        super.deactivate();
    }
}

