/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.book.gallery.controls;

import com.jaspersoft.studio.book.gallery.commands.CompoundOperation;
import com.jaspersoft.studio.book.gallery.commands.CreateElementCommand;
import com.jaspersoft.studio.book.gallery.commands.DeleteItemCommand;
import com.jaspersoft.studio.book.gallery.controls.DropEffectLocation;
import com.jaspersoft.studio.book.gallery.controls.GalleryDropTargetListener;
import com.jaspersoft.studio.book.gallery.controls.GalleryTransfer;
import com.jaspersoft.studio.book.gallery.controls.render.DraggableGalleryItemRenderer;
import com.jaspersoft.studio.book.gallery.controls.render.DraggableGroupRenderer;
import com.jaspersoft.studio.book.gallery.controls.render.PageDragSourceEffect;
import com.jaspersoft.studio.book.gallery.interfaces.IElementOpener;
import com.jaspersoft.studio.book.gallery.interfaces.IGalleryElement;
import com.jaspersoft.studio.book.model.IReportPartContainer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.nebula.widgets.gallery.AbstractGalleryGroupRenderer;
import org.eclipse.nebula.widgets.gallery.AbstractGalleryItemRenderer;
import org.eclipse.nebula.widgets.gallery.Gallery;
import org.eclipse.nebula.widgets.gallery.GalleryItem;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEffect;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.part.ResourceTransfer;

public class GalleryComposite
extends Composite {
    private IWorkbench executionWorkbench;
    private static final int GALLERY_HEIGHT = 150;
    private static final int GALLERY_WIDTH = 150;
    private List<ModifyListener> modifyListeners = new ArrayList<ModifyListener>();
    private List<IGalleryElement> elements = new ArrayList<IGalleryElement>();
    private Gallery pageGallery;
    private GalleryItem elementGroups;
    private PageDragSourceEffect dragSourceEffect;
    private DropEffectLocation dropTargetEffect = new DropEffectLocation();
    protected MenuItem deleteAction = null;
    protected List<IElementOpener> openers = new ArrayList<IElementOpener>();
    private IReportPartContainer partsContainer;

    public GalleryComposite(IWorkbench executionWorkbench, Composite parent, int style) {
        super(parent, style);
        this.executionWorkbench = executionWorkbench;
        this.createControl();
    }

    private void createControl() {
        this.setLayout((Layout)new GridLayout(1, false));
        this.pageGallery = new Gallery((Composite)this, 0x10000A00);
        this.pageGallery.setLayoutData((Object)new GridData(1808));
        this.elementGroups = new GalleryItem(this.pageGallery, 0);
        DraggableGroupRenderer gr = new DraggableGroupRenderer();
        gr.setMinMargin(2);
        gr.setItemSize(150, 150);
        gr.setAutoMargin(true);
        gr.setDropTargetLocation(this.dropTargetEffect);
        this.pageGallery.setGroupRenderer((AbstractGalleryGroupRenderer)gr);
        DraggableGalleryItemRenderer ir = new DraggableGalleryItemRenderer();
        ir.setShowLabels(true);
        this.pageGallery.setItemRenderer((AbstractGalleryItemRenderer)ir);
        this.dragSourceEffect = new PageDragSourceEffect(this.pageGallery, 150, 150);
        Transfer[] types = new Transfer[]{GalleryTransfer.getInstance()};
        DragSource galleryDragSource = new DragSource((Control)this.pageGallery, 2);
        galleryDragSource.setTransfer(types);
        galleryDragSource.setDragSourceEffect((DragSourceEffect)this.dragSourceEffect);
        galleryDragSource.addDragListener(new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                GalleryTransfer.getInstance().setSourceGallery(GalleryComposite.this);
            }

            public void dragSetData(DragSourceEvent event) {
            }

            public void dragFinished(DragSourceEvent event) {
                GalleryTransfer.getInstance().setSourceGallery(null);
            }
        });
        DropTarget gallryDropTarget = new DropTarget((Control)this.pageGallery, 2);
        types = new Transfer[]{GalleryTransfer.getInstance(), ResourceTransfer.getInstance()};
        gallryDropTarget.setTransfer(types);
        gallryDropTarget.addDropListener((DropTargetListener)new GalleryDropTargetListener());
        Menu popupMenu = new Menu((Control)this.pageGallery);
        this.pageGallery.setMenu(popupMenu);
        this.pageGallery.addMouseListener((MouseListener)new GalleryRightClick());
        this.initializeDeleteAction();
    }

    public void callModifyLiteners() {
        Event e = new Event();
        e.widget = this.pageGallery;
        e.data = this.elements;
        ModifyEvent event = new ModifyEvent(e);
        for (ModifyListener listener : this.modifyListeners) {
            listener.modifyText(event);
        }
    }

    public void createItem(IGalleryElement element, int index) {
        GalleryItem item = null;
        if (index != -1) {
            item = new GalleryItem(this.elementGroups, 0, index);
            this.elements.add(index, element);
        } else {
            item = new GalleryItem(this.elementGroups, 0);
            this.elements.add(element);
        }
        item.setText(element.getTitle());
        item.setData((Object)element);
        Image elementImage = element.getImage();
        item.setImage(elementImage);
        item.setSelectedImage(elementImage);
        this.callModifyLiteners();
    }

    public IGalleryElement removeItem(int index) {
        IGalleryElement removedElement = this.elements.remove(index);
        this.elementGroups.remove(index);
        this.callModifyLiteners();
        return removedElement;
    }

    public void addElementOpener(IElementOpener opener) {
        this.openers.add(opener);
        Menu menu = this.pageGallery.getMenu();
        MenuItem[] items = menu.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].dispose();
            ++i;
        }
        this.initializeAddActions();
        this.initializeDeleteAction();
    }

    public void addModifyListener(ModifyListener listener) {
        this.modifyListeners.add(listener);
    }

    public boolean removeModifyListener(ModifyListener listener) {
        if (this.modifyListeners.contains(listener)) {
            this.modifyListeners.remove(listener);
            return true;
        }
        return false;
    }

    public int getContentSize() {
        return this.elementGroups.getItemCount();
    }

    public int getIndexOf(IGalleryElement container) {
        return this.elements.indexOf(container);
    }

    public IGalleryElement getElementAt(int index) {
        return this.elements.get(index);
    }

    public List<IGalleryElement> getElements() {
        return this.elements;
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public boolean isSelectionEmpty() {
        return this.pageGallery.getSelection().length == 0;
    }

    public List<IGalleryElement> getSelectedElements() {
        ArrayList<IGalleryElement> result = new ArrayList<IGalleryElement>();
        GalleryItem[] galleryItemArray = this.pageGallery.getSelection();
        int n = galleryItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            GalleryItem item = galleryItemArray[n2];
            result.add((IGalleryElement)item.getData());
            ++n2;
        }
        return result;
    }

    public void addElements(List<IGalleryElement> elements) {
        int i = 0;
        while (i < elements.size()) {
            this.createItem(elements.get(i), i);
            ++i;
        }
        this.pageGallery.redraw();
    }

    protected DropEffectLocation getDropTargetEffect() {
        return this.dropTargetEffect;
    }

    protected void initializeDeleteAction() {
        this.deleteAction = new MenuItem(this.pageGallery.getMenu(), 0);
        this.deleteAction.setText("Delete");
        this.deleteAction.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompoundOperation cc = new CompoundOperation("Delete Elements");
                GalleryItem[] galleryItemArray = GalleryComposite.this.pageGallery.getSelection();
                int n = galleryItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    GalleryItem item = galleryItemArray[n2];
                    DeleteItemCommand deleteCommand = new DeleteItemCommand(GalleryComposite.this, (IGalleryElement)item.getData());
                    cc.add(deleteCommand);
                    ++n2;
                }
                GalleryComposite.this.executeCommand(cc);
                GalleryComposite.this.pageGallery.redraw();
            }
        });
    }

    protected void initializeAddActions() {
        for (IElementOpener opener : this.openers) {
            MenuItem addAction = new MenuItem(this.pageGallery.getMenu(), 0);
            addAction.setText(opener.getActionText());
            addAction.setData((Object)opener);
            addAction.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IGalleryElement[] elements;
                    CompoundOperation cc = new CompoundOperation("Add Elements");
                    IElementOpener opener = (IElementOpener)e.widget.getData();
                    IGalleryElement[] iGalleryElementArray = elements = opener.openResources();
                    int n = elements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IGalleryElement element = iGalleryElementArray[n2];
                        CreateElementCommand createCommand = new CreateElementCommand(GalleryComposite.this, element);
                        cc.add(createCommand);
                        ++n2;
                    }
                    GalleryComposite.this.executeCommand(cc);
                    GalleryComposite.this.pageGallery.redraw();
                }
            });
        }
    }

    protected Gallery getGallery() {
        return this.pageGallery;
    }

    protected void clearDropEffect(boolean removeMouseMoveFeedback) {
        if (removeMouseMoveFeedback) {
            this.dragSourceEffect.disposeImage();
        }
        this.dropTargetEffect.setItem(null);
        this.pageGallery.redraw();
    }

    public void executeCommand(AbstractOperation operation) {
        if (this.executionWorkbench != null) {
            IOperationHistory operationHistory = this.executionWorkbench.getOperationSupport().getOperationHistory();
            IUndoContext undoContext = this.executionWorkbench.getOperationSupport().getUndoContext();
            operation.addContext(undoContext);
            try {
                operationHistory.execute((IUndoableOperation)operation, (IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        } else {
            try {
                operation.execute((IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
    }

    public void setPartsContainer(IReportPartContainer partsContainer) {
        this.partsContainer = partsContainer;
    }

    public IReportPartContainer getPartsContainer() {
        return this.partsContainer;
    }

    protected class GalleryRightClick
    implements MouseListener {
        public void mouseUp(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
            boolean allDeselected;
            boolean bl = allDeselected = e.button == 3 && GalleryComposite.this.pageGallery.getItem(new Point(e.x, e.y)) == null;
            if (allDeselected) {
                GalleryComposite.this.pageGallery.deselectAll();
            }
            if (GalleryComposite.this.deleteAction != null) {
                GalleryComposite.this.deleteAction.setEnabled(!allDeselected);
            }
        }

        public void mouseDoubleClick(MouseEvent e) {
        }
    }
}

