/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.book.model.commands;

import com.jaspersoft.studio.book.model.MBookReport;
import com.jaspersoft.studio.book.model.MGroupReportPartContainer;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import org.eclipse.gef.commands.Command;

public class RemoveSectionCommand
extends Command {
    private MGroupReportPartContainer sectionToRemove = null;
    private MBookReport parent;
    private int oldIndex = -1;

    public RemoveSectionCommand(MGroupReportPartContainer sectionToRemove) {
        this.sectionToRemove = sectionToRemove;
        this.parent = (MBookReport)sectionToRemove.getParent();
    }

    public boolean canExecute() {
        return this.sectionToRemove != null && !this.sectionToRemove.isDetail();
    }

    public void execute() {
        this.oldIndex = this.parent.getValue().getGroupsList().indexOf(this.sectionToRemove.getJrgroup());
        this.parent.getValue().removeGroup((JRGroup)this.sectionToRemove.getJrgroup());
    }

    public boolean canUndo() {
        return this.oldIndex > -1;
    }

    public void undo() {
        JRDesignDataset mainDataset = (JRDesignDataset)this.parent.getValue().getMainDataset();
        try {
            mainDataset.addGroup(this.oldIndex, this.sectionToRemove.getJrgroup());
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }
}

