/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.sql;

import com.jaspersoft.studio.data.sql.SQLQueryDesigner;
import com.jaspersoft.studio.data.sql.model.AMSQLObject;
import com.jaspersoft.studio.data.sql.model.ISubQuery;
import com.jaspersoft.studio.data.sql.model.MDBObjects;
import com.jaspersoft.studio.data.sql.model.metadata.MSQLColumn;
import com.jaspersoft.studio.data.sql.model.metadata.MSqlSchema;
import com.jaspersoft.studio.data.sql.model.metadata.MSqlTable;
import com.jaspersoft.studio.data.sql.model.query.AMKeyword;
import com.jaspersoft.studio.data.sql.model.query.AMQueryObject;
import com.jaspersoft.studio.data.sql.model.query.MHaving;
import com.jaspersoft.studio.data.sql.model.query.MUnion;
import com.jaspersoft.studio.data.sql.model.query.MWhere;
import com.jaspersoft.studio.data.sql.model.query.expression.AMExpression;
import com.jaspersoft.studio.data.sql.model.query.from.MFrom;
import com.jaspersoft.studio.data.sql.model.query.from.MFromTable;
import com.jaspersoft.studio.data.sql.model.query.groupby.MGroupBy;
import com.jaspersoft.studio.data.sql.model.query.groupby.MGroupByColumn;
import com.jaspersoft.studio.data.sql.model.query.operand.AOperand;
import com.jaspersoft.studio.data.sql.model.query.operand.FieldOperand;
import com.jaspersoft.studio.data.sql.model.query.orderby.MOrderByColumn;
import com.jaspersoft.studio.data.sql.model.query.select.MSelect;
import com.jaspersoft.studio.data.sql.model.query.select.MSelectColumn;
import com.jaspersoft.studio.data.sql.model.query.subquery.MQueryTable;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MRoot;
import com.jaspersoft.studio.model.util.ModelVisitor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.swt.widgets.Display;

public class Util {
    public static boolean columnExists(MSQLColumn c, MDBObjects orderBy, List<MSqlTable> tables) {
        if (!tables.contains(c.getParent())) {
            return true;
        }
        for (INode n : orderBy.getChildren()) {
            if (!n.getValue().equals(c)) continue;
            return true;
        }
        return false;
    }

    public static List<AMSQLObject> getUsedColumns(ANode sel) {
        ArrayList<AMSQLObject> list = new ArrayList<AMSQLObject>();
        MDBObjects mgb = null;
        if (sel instanceof MDBObjects) {
            mgb = (MDBObjects)sel;
        } else if (sel instanceof AMQueryObject) {
            mgb = (MDBObjects)sel.getParent();
        }
        if (mgb != null) {
            for (INode n : mgb.getChildren()) {
                if (!(n instanceof MSelectColumn)) continue;
                list.add((AMSQLObject)n.getValue());
            }
        }
        return list;
    }

    public static List<MSqlTable> getTables(ANode sel) {
        ArrayList<MSqlTable> list = new ArrayList<MSqlTable>();
        ANode r = Util.getQueryRoot(sel);
        if (r != null) {
            for (INode n : r.getChildren()) {
                if (!(n instanceof MFrom)) continue;
                for (INode t : n.getChildren()) {
                    list.add((MSqlTable)t.getValue());
                    if (t.getChildren().isEmpty()) continue;
                    for (INode jt : t.getChildren()) {
                        if (!(jt.getValue() instanceof MSqlTable)) continue;
                        list.add((MSqlTable)jt.getValue());
                    }
                }
            }
        }
        return list;
    }

    public static ANode getQueryRoot(ANode n) {
        ANode root = n;
        while (!(root == null || root instanceof MRoot || root instanceof MUnion || root instanceof ISubQuery || root instanceof MFromTable && root.getValue() instanceof MQueryTable)) {
            root = root.getParent();
        }
        return root;
    }

    public static List<MFromTable> getFromTables(ANode sel) {
        ArrayList<MFromTable> list = new ArrayList<MFromTable>();
        ANode r = Util.getQueryRoot(sel);
        if (r != null) {
            for (INode n : r.getChildren()) {
                if (!(n instanceof MFrom)) continue;
                for (INode t : n.getChildren()) {
                    list.add((MFromTable)t);
                    if (t.getChildren().isEmpty()) continue;
                    for (INode jt : t.getChildren()) {
                        if (!(jt instanceof MFromTable)) continue;
                        list.add((MFromTable)jt);
                    }
                }
            }
        }
        return list;
    }

    public static MRoot getRoot(MSQLColumn mcol, AMExpression<?> mexpr) {
        if (mcol != null) {
            return mcol.getRoot();
        }
        ModelVisitor<INode> mv = new ModelVisitor<INode>((INode)mexpr.getRoot()){

            public boolean visit(INode n) {
                if (n instanceof AMQueryObject && n.getValue() instanceof ANode) {
                    ANode v = (ANode)((AMQueryObject)n).getValue();
                    this.setObject(v.getRoot());
                    return false;
                }
                return true;
            }
        };
        return (MRoot)mv.getObject();
    }

    public static ANode getOldNode(ANode target, final ANode src) {
        ModelVisitor<ANode> mv = new ModelVisitor<ANode>(target.getRoot()){

            public boolean visit(INode n) {
                if (src != n && src.equals(n)) {
                    this.setObject((ANode)n);
                    this.stop();
                }
                return true;
            }
        };
        return (ANode)mv.getObject();
    }

    public static <T extends AMKeyword> T getKeyword(ANode msc, Class<T> clazz) {
        ANode qroot = Util.getQueryRoot(msc);
        if (qroot != null) {
            for (INode n : qroot.getChildren()) {
                if (!clazz.isInstance(n)) continue;
                return (T)((AMKeyword)n);
            }
        }
        return null;
    }

    public static List<ANode> getAllNodes(Object data) {
        ArrayList<ANode> nodes = new ArrayList<ANode>();
        if (data.getClass().isArray()) {
            Object[] ar;
            Object[] objectArray = ar = (Object[])data;
            int n = ar.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (obj instanceof ANode) {
                    nodes.add((ANode)obj);
                }
                ++n2;
            }
        } else if (data instanceof ANode) {
            nodes.add((ANode)data);
        }
        return nodes;
    }

    public static void filterTables(List<ANode> node, Set<MSqlTable> tables, Set<MSQLColumn> cols, Set<ANode> others) {
        for (ANode n : node) {
            if (n instanceof MSqlTable) {
                tables.add((MSqlTable)n);
                continue;
            }
            if (n instanceof MSQLColumn) {
                cols.add((MSQLColumn)n);
                continue;
            }
            others.add(n);
        }
    }

    public static void cleanTableVersions(final MFromTable newTbl, final MFromTable oldTbl) {
        new ModelVisitor<Object>((INode)newTbl.getRoot()){

            public boolean visit(INode n) {
                if (n instanceof MSelectColumn && ((MSelectColumn)n).getMFromTable().equals(oldTbl)) {
                    ((MSelectColumn)n).setMFromTable(newTbl);
                    return false;
                }
                if (n instanceof MGroupByColumn && ((MGroupByColumn)n).getMFromTable().equals(oldTbl)) {
                    ((MGroupByColumn)n).setMFromTable(newTbl);
                    return false;
                }
                if (n instanceof MOrderByColumn && ((MOrderByColumn)n).getMFromTable().equals(oldTbl)) {
                    ((MOrderByColumn)n).setMFromTable(newTbl);
                    return false;
                }
                if (n instanceof AMExpression) {
                    for (AOperand op : ((AMExpression)n).getOperands()) {
                        if (!(op instanceof FieldOperand) || !((FieldOperand)op).getFromTable().equals(oldTbl)) continue;
                        ((FieldOperand)op).setFromTable(newTbl);
                    }
                    return false;
                }
                return true;
            }
        };
    }

    public static void refreshTables(MRoot rmeta, MRoot rquery, SQLQueryDesigner designer) {
        List<MSqlTable> oldTables = Util.getTables((ANode)rquery);
        HashSet<MSqlTable> newTables = new HashSet<MSqlTable>();
        for (MSqlTable mt : oldTables) {
            MSqlTable newTbl = Util.getTable(rmeta, mt, designer);
            if (newTbl == null) continue;
            newTables.add(newTbl);
        }
        for (MSqlTable t : newTables) {
            Util.replaceTable(rquery, t);
        }
        Display.getDefault().asyncExec(() -> {
            designer.setRefreshMetadata(true);
            rquery.getPropertyChangeSupport().firePropertyChange("tablesupdated", false, true);
            designer.setRefreshMetadata(false);
        });
    }

    public static void replaceTable(MRoot rquery, final MSqlTable mtable) {
        final String sqlTable = mtable.toSQLString();
        new ModelVisitor<MSqlTable>((INode)rquery){

            public boolean visit(INode n) {
                if (n instanceof MFromTable && ((MSqlTable)((MFromTable)n).getValue()).toSQLString().equals(sqlTable)) {
                    n.setValue((Object)mtable);
                }
                if (n instanceof MSelectColumn) {
                    MSQLColumn mc = this.getColumn(((MSelectColumn)n).getMFromTable(), (MSQLColumn)((MSelectColumn)n).getValue());
                    if (mc != null) {
                        n.setValue((Object)mc);
                    }
                    return false;
                }
                if (n instanceof MGroupByColumn) {
                    MSQLColumn mc = this.getColumn(((MGroupByColumn)n).getMFromTable(), (MSQLColumn)((MGroupByColumn)n).getValue());
                    if (mc != null) {
                        n.setValue((Object)mc);
                    }
                    return false;
                }
                if (n instanceof MOrderByColumn) {
                    MSQLColumn mc = this.getColumn(((MOrderByColumn)n).getMFromTable(), (MSQLColumn)((MOrderByColumn)n).getValue());
                    if (mc != null) {
                        n.setValue((Object)mc);
                    }
                    return false;
                }
                if (n instanceof AMExpression) {
                    for (AOperand op : ((AMExpression)n).getOperands()) {
                        MSQLColumn mc;
                        if (!(op instanceof FieldOperand) || (mc = this.getColumn(((FieldOperand)op).getFromTable(), ((FieldOperand)op).getMColumn())) == null) continue;
                        ((FieldOperand)op).setColumn(mc);
                    }
                    return false;
                }
                return true;
            }

            private MSQLColumn getColumn(MFromTable mtable2, MSQLColumn old) {
                if (mtable2 != null && mtable2.getValue() != null && old != null && ((MSqlTable)mtable2.getValue()).equals(old.getParent())) {
                    for (INode n : mtable2.getChildren()) {
                        if (!n.equals(old)) continue;
                        return (MSQLColumn)n;
                    }
                }
                return null;
            }
        };
    }

    public static MSqlTable getTable(MRoot rmeta, final MSqlTable mt, final SQLQueryDesigner designer) {
        MDBObjects msch = null;
        if (mt.getParent() != null) {
            if (mt.getParent() instanceof MSqlSchema) {
                msch = (MSqlSchema)mt.getParent();
            } else if (mt.getParent().getParent() instanceof MSqlSchema) {
                msch = (MSqlSchema)mt.getParent().getParent();
            }
        }
        final String schema = msch != null ? msch.getValue() : "";
        return (MSqlTable)new ModelVisitor<MSqlTable>((INode)rmeta){

            public boolean visit(INode n) {
                if (n instanceof MSqlSchema) {
                    MSqlSchema mschema = (MSqlSchema)n;
                    if (mschema.getValue() == null || !mschema.getValue().equalsIgnoreCase(schema) || mschema.isNotInMetadata()) {
                        return false;
                    }
                    designer.getDbMetadata().loadSchema(mschema);
                } else if (n instanceof MSqlTable && ((MSqlTable)n).getValue().equalsIgnoreCase(mt.getValue())) {
                    designer.getDbMetadata().loadTable((MSqlTable)n);
                    this.setObject((MSqlTable)n);
                    this.stop();
                }
                return true;
            }
        }.getObject();
    }

    public static MSqlTable getTable(MRoot rmeta, MSqlTable mtable) {
        return Util.getTable(rmeta, null, mtable.getSchema().getValue(), mtable.getValue());
    }

    public static MSqlTable getTable(MRoot rmeta, String cat, String schema, final String table) {
        if (schema == null && cat != null) {
            schema = cat;
        }
        final String schemaName = schema;
        ModelVisitor<MSqlTable> v = new ModelVisitor<MSqlTable>((INode)rmeta){

            public boolean visit(INode n) {
                if (n instanceof MSqlSchema) {
                    return Misc.nvl((String)((MSqlSchema)n).getValue()).equals(Misc.nvl((String)schemaName));
                }
                if (n instanceof MSqlTable && n.getValue().equals(table)) {
                    this.setObject((MSqlTable)n);
                    this.stop();
                }
                return true;
            }
        };
        return (MSqlTable)v.getObject();
    }

    public static void removeFrom(List<?> col, int from) {
        int i = col.size() - 1;
        while (i > from) {
            col.remove(i);
            --i;
        }
    }

    public static void copySubQuery(MFromTable mftj, MFromTable mtbl) {
        if (mftj.getValue() instanceof MQueryTable) {
            ArrayList children = new ArrayList(mftj.getChildren());
            for (INode n : children) {
                if (!(n instanceof MUnion) && !(n instanceof MSelect) && !(n instanceof MFrom) && !(n instanceof MWhere) && !(n instanceof MGroupBy) && !(n instanceof MHaving)) continue;
                mtbl.addChild((ANode)n);
            }
        }
    }

    public static MSelect createSelect(ANode parent) {
        MSelect ms = new MSelect(parent);
        new MFrom(parent);
        new MWhere(parent);
        new MGroupBy(parent);
        new MHaving(parent);
        return ms;
    }
}

