/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.sql.action.groupby;

import com.jaspersoft.studio.data.sql.SQLQueryDesigner;
import com.jaspersoft.studio.data.sql.Util;
import com.jaspersoft.studio.data.sql.action.AAction;
import com.jaspersoft.studio.data.sql.action.table.CreateTable;
import com.jaspersoft.studio.data.sql.dialogs.FromTableColumnsDialog;
import com.jaspersoft.studio.data.sql.messages.Messages;
import com.jaspersoft.studio.data.sql.model.metadata.MSQLColumn;
import com.jaspersoft.studio.data.sql.model.metadata.MSqlTable;
import com.jaspersoft.studio.data.sql.model.query.from.MFrom;
import com.jaspersoft.studio.data.sql.model.query.from.MFromTable;
import com.jaspersoft.studio.data.sql.model.query.groupby.MGroupBy;
import com.jaspersoft.studio.data.sql.model.query.groupby.MGroupByColumn;
import com.jaspersoft.studio.data.sql.model.query.groupby.MGroupByExpression;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.jface.viewers.TreeViewer;

public class CreateGroupByColumn
extends AAction {
    private CreateTable ct;
    private SQLQueryDesigner designer;

    public CreateGroupByColumn(SQLQueryDesigner designer, TreeViewer treeViewer) {
        super(Messages.CreateGroupByColumn_0, treeViewer);
        this.designer = designer;
    }

    @Override
    public boolean calculateEnabled(Object[] selection) {
        super.calculateEnabled(selection);
        return selection != null && selection.length == 1 && CreateGroupByColumn.isInSelect(selection[0]);
    }

    public static boolean isInSelect(Object element) {
        boolean b;
        boolean bl = b = element instanceof MGroupBy || element instanceof MGroupByColumn || element instanceof MGroupByExpression;
        if (b) {
            MFrom mfrom = Util.getKeyword((ANode)((ANode)element).getRoot(), MFrom.class);
            if (mfrom != null) {
                return !Misc.isNullOrEmpty((Collection)mfrom.getChildren());
            }
            return false;
        }
        return b;
    }

    public void run() {
        FromTableColumnsDialog dialog = new FromTableColumnsDialog(this.treeViewer.getControl().getShell());
        dialog.setSelection((ANode)this.selection[0]);
        if (dialog.open() == 0) {
            this.run(dialog.getColumns());
        }
    }

    public void run(Map<MSQLColumn, MFromTable> cols) {
        Object sel = this.selection[0];
        for (MSQLColumn t : cols.keySet()) {
            MFromTable mftable = cols.get(t);
            if (sel instanceof MGroupBy) {
                sel = this.run(t, mftable, (MGroupBy)sel, 0);
                continue;
            }
            if (sel instanceof MGroupByColumn) {
                sel = this.run(t, mftable, (MGroupByColumn)sel);
                continue;
            }
            if (!(sel instanceof MGroupByExpression)) continue;
            sel = this.run(t, mftable, (MGroupByExpression)sel);
        }
        this.selectInTree(sel);
    }

    public void run(Collection<MSQLColumn> nodes) {
        Object sel = this.selection[0];
        List<MFromTable> tbls = Util.getFromTables((ANode)sel);
        for (MSQLColumn t : nodes) {
            MSqlTable tbl = (MSqlTable)t.getParent();
            MFromTable mftable = null;
            for (MFromTable ft : tbls) {
                if (!((MSqlTable)ft.getValue()).equals(tbl)) continue;
                mftable = ft;
                break;
            }
            if (mftable == null) {
                if (this.ct == null) {
                    this.ct = new CreateTable(this.designer, this.treeViewer);
                }
                ANode r = Util.getQueryRoot((ANode)sel);
                for (INode n : r.getChildren()) {
                    if (!(n instanceof MFrom)) continue;
                    mftable = this.ct.run(tbl, (MFrom)n, -1);
                    break;
                }
            }
            if (sel instanceof MGroupBy) {
                sel = this.run(t, mftable, (MGroupBy)sel, 0);
                continue;
            }
            if (!(sel instanceof MGroupByColumn)) continue;
            sel = this.run(t, mftable, (MGroupByColumn)sel);
        }
        this.selectInTree(sel);
    }

    protected MGroupByColumn run(MSQLColumn node, MFromTable mfTable, MGroupByColumn mtable) {
        MGroupBy mfrom = (MGroupBy)mtable.getParent();
        return this.run(node, mfTable, mfrom, mfrom.getChildren().indexOf(mtable) + 1);
    }

    protected MGroupByColumn run(MSQLColumn node, MFromTable mfTable, MGroupByExpression mtable) {
        MGroupBy mfrom = (MGroupBy)mtable.getParent();
        return this.run(node, mfTable, mfrom, mfrom.getChildren().indexOf(mtable) + 1);
    }

    public MGroupByColumn run(MSQLColumn node, MFromTable mfTable, MGroupBy select, int index) {
        return new MGroupByColumn((ANode)select, node, mfTable, index);
    }
}

