/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.sql.action.select;

import com.jaspersoft.studio.data.sql.SQLQueryDesigner;
import com.jaspersoft.studio.data.sql.Util;
import com.jaspersoft.studio.data.sql.action.AAction;
import com.jaspersoft.studio.data.sql.action.table.CreateTable;
import com.jaspersoft.studio.data.sql.dialogs.FromTableColumnsDialog;
import com.jaspersoft.studio.data.sql.messages.Messages;
import com.jaspersoft.studio.data.sql.model.metadata.MSQLColumn;
import com.jaspersoft.studio.data.sql.model.metadata.MSqlTable;
import com.jaspersoft.studio.data.sql.model.query.from.MFrom;
import com.jaspersoft.studio.data.sql.model.query.from.MFromTable;
import com.jaspersoft.studio.data.sql.model.query.select.MSelect;
import com.jaspersoft.studio.data.sql.model.query.select.MSelectColumn;
import com.jaspersoft.studio.data.sql.model.query.select.MSelectSubQuery;
import com.jaspersoft.studio.data.sql.ui.gef.command.CreateColumnCommand;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.TreeViewer;

public class CreateColumn
extends AAction {
    private CreateTable ct;
    private SQLQueryDesigner designer;
    private boolean checkTables = true;

    public CreateColumn(SQLQueryDesigner designer, TreeViewer treeViewer) {
        super(Messages.CreateColumn_0, treeViewer);
        this.designer = designer;
    }

    @Override
    public boolean calculateEnabled(Object[] selection) {
        super.calculateEnabled(selection);
        return selection != null && selection.length == 1 && this.isInSelect(selection[0]);
    }

    public void setCheckTables(boolean checkTables) {
        this.checkTables = checkTables;
    }

    public boolean isInSelect(Object element) {
        boolean b;
        if (element instanceof MSelectSubQuery) {
            return false;
        }
        boolean bl = b = element instanceof MSelect || element instanceof ANode && ((ANode)element).getParent() instanceof MSelect;
        if (b && this.checkTables) {
            MFrom mfrom = Util.getKeyword((ANode)((ANode)element).getRoot(), MFrom.class);
            if (mfrom != null) {
                return !Misc.isNullOrEmpty((Collection)mfrom.getChildren());
            }
            return false;
        }
        return b;
    }

    public void run() {
        FromTableColumnsDialog dialog = new FromTableColumnsDialog(UIUtils.getShell());
        dialog.setSelection((ANode)this.selection[0]);
        if (dialog.open() == 0) {
            this.run(dialog.getColumns());
        }
    }

    public void run(Map<MSQLColumn, MFromTable> cols) {
        Object sel = this.selection[0];
        for (MSQLColumn t : cols.keySet()) {
            MFromTable mftable = cols.get(t);
            if (sel instanceof MSelect) {
                sel = this.run(t, mftable, (MSelect)sel, 0);
                continue;
            }
            if (!(sel instanceof ANode) || !(((ANode)sel).getParent() instanceof MSelect)) continue;
            MSelect msel = (MSelect)((ANode)sel).getParent();
            int index = msel.getChildren().indexOf(sel) + 1;
            sel = this.run(t, mftable, msel, index);
        }
        this.selectInTree(sel);
    }

    public void run(Collection<MSQLColumn> nodes) {
        Object sel = this.selection[0];
        List<MFromTable> tbls = Util.getFromTables((ANode)sel);
        for (MSQLColumn t : nodes) {
            MSqlTable tbl = (MSqlTable)t.getParent();
            MFromTable mftable = null;
            for (MFromTable ft : tbls) {
                if (!((MSqlTable)ft.getValue()).equals(tbl)) continue;
                mftable = ft;
                break;
            }
            if (mftable == null) {
                if (this.ct == null) {
                    this.ct = new CreateTable(this.designer, this.treeViewer);
                }
                ANode r = Util.getQueryRoot((ANode)sel);
                for (INode n : r.getChildren()) {
                    if (!(n instanceof MFrom)) continue;
                    mftable = this.ct.run(tbl, (MFrom)n, -1);
                    tbls = Util.getFromTables((ANode)sel);
                    break;
                }
            }
            if (sel instanceof MSelect) {
                sel = this.run(t, mftable, (MSelect)sel, 0);
                continue;
            }
            if (!(sel instanceof MSelectColumn)) continue;
            sel = this.run(t, mftable, (MSelectColumn)sel);
        }
        this.selectInTree(sel);
    }

    public MSelectColumn run(MSQLColumn sCol, MFromTable mfTable) {
        MSelect mSelect = Util.getKeyword((ANode)mfTable, MSelect.class);
        MSelectColumn msCol = this.run(sCol, mfTable, mSelect, -1);
        this.selectInTree(msCol);
        return msCol;
    }

    protected MSelectColumn run(MSQLColumn sCol, MFromTable mfTable, MSelectColumn mSelCol) {
        MSelect mSelect = Util.getKeyword((ANode)mfTable, MSelect.class);
        return this.run(sCol, mfTable, mSelect, mSelect.getChildren().indexOf(mSelCol) + 1);
    }

    public MSelectColumn run(MSQLColumn node, MFromTable mfTable, MSelect select, int index) {
        CreateColumnCommand c = new CreateColumnCommand(node, select, index, mfTable);
        this.designer.getDiagram().getViewer().getEditDomain().getCommandStack().execute((Command)c);
        return c.getResultColumn();
    }
}

