/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.sql.dialogs;

import com.jaspersoft.studio.data.sql.model.metadata.MSqlSchema;
import com.jaspersoft.studio.data.sql.model.metadata.MSqlTable;
import com.jaspersoft.studio.data.sql.model.metadata.MTables;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MRoot;
import com.jaspersoft.studio.outline.ReportTreeContetProvider;
import com.jaspersoft.studio.outline.ReportTreeLabelProvider;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.ATitledDialog;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class TablesDialog
extends ATitledDialog {
    private TreeViewer treeViewer;
    private MRoot root;
    private List<MSqlTable> table = new ArrayList<MSqlTable>();

    public TablesDialog(Shell parentShell) {
        super(parentShell);
        this.setTitle("Tables Dialog");
        this.setDefaultSize(650, 780);
    }

    public void setRoot(MRoot root) {
        this.root = root;
    }

    public boolean close() {
        TreeSelection ts = (TreeSelection)this.treeViewer.getSelection();
        for (Object obj : ts.toList()) {
            if (!(obj instanceof MSqlTable)) continue;
            this.table.add((MSqlTable)obj);
        }
        return super.close();
    }

    public List<MSqlTable> getTable() {
        return this.table;
    }

    protected Control createDialogArea(Composite parent) {
        Composite cmp = (Composite)super.createDialogArea(parent);
        this.treeViewer = new TreeViewer(cmp, 2050);
        this.treeViewer.setContentProvider((IContentProvider)new ReportTreeContetProvider(){

            public Object[] getChildren(Object parentElement) {
                MSqlSchema p;
                if (parentElement instanceof MSqlSchema && (p = (MSqlSchema)parentElement).getChildren() != null && p.getChildren().size() > 0) {
                    ArrayList<INode> n = new ArrayList<INode>();
                    for (INode node : p.getChildren()) {
                        if (!(node instanceof MTables)) continue;
                        n.add(node);
                    }
                    return n.toArray();
                }
                return super.getChildren(parentElement);
            }

            public boolean hasChildren(Object element) {
                if (element instanceof MSqlTable) {
                    return false;
                }
                return super.hasChildren(element);
            }
        });
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ReportTreeLabelProvider());
        GridData gd = new GridData(1808);
        gd.minimumHeight = 400;
        gd.minimumWidth = 400;
        this.treeViewer.getControl().setLayoutData((Object)gd);
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TreeSelection ts = (TreeSelection)TablesDialog.this.treeViewer.getSelection();
                Object el = ts.getFirstElement();
                if (el instanceof MSqlTable) {
                    TablesDialog.this.okPressed();
                } else if (TablesDialog.this.treeViewer.getExpandedState(el)) {
                    TablesDialog.this.treeViewer.collapseToLevel(el, 1);
                } else {
                    TablesDialog.this.treeViewer.expandToLevel(el, 1);
                }
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeViewer);
        this.treeViewer.setInput((Object)this.root);
        return cmp;
    }
}

