/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.sql.model.query;

import com.jaspersoft.studio.data.querydesigner.sql.text.SQLScanner;
import com.jaspersoft.studio.data.sql.model.query.AMQueryObject;
import com.jaspersoft.studio.data.sql.model.query.IQueryString;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.preferences.fonts.utils.FontUtils;
import org.eclipse.jface.viewers.StyledString;

public abstract class AMQueryAliased<T>
extends AMQueryObject<T> {
    public static final long serialVersionUID = 10200L;
    private String alias;
    private String aliasKeyword = "AS";

    public AMQueryAliased(ANode parent, T value, String image, int index) {
        super(parent, value, image, index);
    }

    public AMQueryAliased(ANode parent, T value, String image) {
        super(parent, value, image);
    }

    public void setAliasKeyword(String aliasKeyword) {
        this.aliasKeyword = aliasKeyword.toUpperCase();
    }

    public void setAlias(String alias) {
        if (alias != null && alias.trim().isEmpty()) {
            alias = null;
        }
        this.alias = alias;
    }

    public String getAliasKeyword() {
        return this.aliasKeyword;
    }

    public String getAlias() {
        return this.alias;
    }

    public String addAlias() {
        if (this.alias != null && !this.alias.trim().isEmpty()) {
            return String.valueOf(this.getAliasKeyString()) + this.prepareAlias();
        }
        return "";
    }

    public String getAliasKeyString() {
        if (this.aliasKeyword.equals("AS")) {
            return " AS ";
        }
        return " ";
    }

    protected String prepareAlias() {
        String al = this.alias.trim();
        if (al.contains(" ") || SQLScanner.SQL_KEYWORDS.contains(this.alias)) {
            al = "'" + al + "'";
        }
        return al;
    }

    public void addAlias(StyledString dt) {
        if (this.alias != null && !this.alias.trim().isEmpty()) {
            dt.append(this.getAliasKeyString(), FontUtils.getKeywordStyler());
            dt.append(this.prepareAlias());
        }
    }

    @Override
    public String getDisplayText() {
        return String.valueOf(super.getDisplayText()) + this.addAlias();
    }

    public StyledString getStyledDisplayText() {
        StyledString dt = new StyledString(super.getDisplayText());
        this.addAlias(dt);
        return dt;
    }

    @Override
    public String toSQLString() {
        String sql = "";
        if (this.getValue() instanceof IQueryString) {
            sql = ((IQueryString)this.getValue()).toSQLString();
        } else if (this.getValue() instanceof String) {
            sql = (String)this.getValue();
        }
        sql = String.valueOf(sql) + this.addAlias();
        return this.isFirst() ? sql : ",\n\t" + sql;
    }
}

