/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.sql.model.query;

import com.jaspersoft.studio.data.sql.model.MSQLRoot;
import com.jaspersoft.studio.data.sql.model.query.IQueryString;
import com.jaspersoft.studio.data.sql.text2model.ConvertUtil;
import com.jaspersoft.studio.model.AMapElement;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import java.util.UUID;
import net.sf.jasperreports.eclipse.JasperReportsPlugin;
import org.eclipse.jface.resource.ImageDescriptor;

public abstract class AMQueryObject<T>
extends AMapElement
implements IQueryString {
    public static final long serialVersionUID = 10200L;
    private transient ImageDescriptor icon;
    private String image;
    protected String tooltip;
    private String id;

    public AMQueryObject(ANode parent, T value, String image) {
        this(parent, value, image, -1);
    }

    public AMQueryObject(ANode parent, T value, String image, int index) {
        super(parent, index);
        this.setValue(value);
        this.image = image;
        this.id = UUID.randomUUID().toString();
        if (image != null) {
            this.icon = JasperReportsPlugin.getDefault().getImageDescriptor(image);
        }
    }

    public MSQLRoot getRoot() {
        return (MSQLRoot)super.getRoot();
    }

    public String getId() {
        return this.id;
    }

    public T getValue() {
        return (T)super.getValue();
    }

    public String getToolTip() {
        if (this.getValue() instanceof INode) {
            String name = ((INode)this.getValue()).getToolTip();
            if (this.tooltip != null) {
                name = String.valueOf(name) + "\n" + this.tooltip;
            }
            return name;
        }
        if (this.getValue() instanceof String) {
            return (String)this.getValue();
        }
        return null;
    }

    public ImageDescriptor getImagePath() {
        if (this.icon == null && this.image != null) {
            this.icon = JasperReportsPlugin.getDefault().getImageDescriptor(this.image);
        }
        return this.icon;
    }

    public String getDisplayText() {
        if (this.getValue() instanceof IQueryString) {
            return ConvertUtil.cleanDbNameFull(((IQueryString)this.getValue()).toSQLString());
        }
        if (this.getValue() instanceof String) {
            return (String)this.getValue();
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj.getClass().equals(this.getClass()) && ((AMQueryObject)obj).getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    @Override
    public String toSQLString() {
        String sql = "";
        if (this.getValue() instanceof IQueryString) {
            sql = ((IQueryString)this.getValue()).toSQLString();
        } else if (this.getValue() instanceof String) {
            sql = (String)this.getValue();
        }
        return this.isFirst() ? sql : ",\n\t" + sql;
    }
}

