/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.sql.model.query.expression;

import com.jaspersoft.studio.data.sql.model.enums.Operator;
import com.jaspersoft.studio.data.sql.model.query.expression.AMExpression;
import com.jaspersoft.studio.data.sql.model.query.from.MFromTableJoin;
import com.jaspersoft.studio.data.sql.model.query.operand.AOperand;
import com.jaspersoft.studio.data.sql.model.query.subquery.MQueryTable;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.preferences.fonts.utils.FontUtils;
import java.text.MessageFormat;
import org.eclipse.jface.viewers.StyledString;

public class MExpression
extends AMExpression<Object> {
    public static final long serialVersionUID = 10200L;
    private Operator operator = Operator.EQUALS;

    public MExpression(ANode parent, Object value, int newIndex) {
        super(parent, value, newIndex);
    }

    @Override
    public MExpression clone() {
        MExpression clone = (MExpression)super.clone();
        for (AOperand op : clone.getOperands()) {
            op.setExpression(clone);
        }
        return clone;
    }

    @Override
    public String getDisplayText() {
        String dt = "";
        if (!this.isFirst()) {
            if (this.getParent() instanceof MFromTableJoin && this.getParent().getValue() instanceof MQueryTable) {
                MFromTableJoin mftj = (MFromTableJoin)this.getParent();
                dt = String.valueOf(dt) + ") " + mftj.addAlias() + " ON ";
            } else {
                dt = String.valueOf(dt) + this.prevCond + " ";
            }
        }
        Object[] ops = null;
        if (this.operator.getNrOperands() > 3) {
            ops = new String[]{"", ""};
            String sep = "";
            int i = 0;
            while (i < this.operands.size()) {
                if (i == 0) {
                    ops[i] = ((AOperand)this.operands.get(i)).toSQLString();
                } else {
                    ops[1] = String.valueOf(ops[1]) + sep + ((AOperand)this.operands.get(i)).toSQLString();
                    sep = ",";
                }
                ++i;
            }
        } else {
            ops = new String[this.operands.size()];
            int i = 0;
            while (i < ops.length) {
                ops[i] = ((AOperand)this.operands.get(i)).toSQLString();
                ++i;
            }
        }
        return String.valueOf(dt) + MessageFormat.format(this.operator.getFormat(this.operator), ops) + this.isLastInGroup(this.getParent(), (ANode)this);
    }

    public StyledString getStyledDisplayText() {
        String sqlname;
        int ind;
        String dt = this.getDisplayText();
        StyledString ss = new StyledString(dt);
        StyledString.Styler ks = FontUtils.getKeywordStyler();
        if (!this.isFirst()) {
            if (this.getParent() instanceof MFromTableJoin && this.getParent().getValue() instanceof MQueryTable) {
                int ind2 = dt.indexOf(" AS ");
                if (ind2 >= 0) {
                    ss.setStyle(ind2, " AS ".length(), ks);
                }
                if ((ind2 = dt.indexOf(" ON ")) >= 0) {
                    ss.setStyle(ind2, " ON ".length(), ks);
                }
            } else {
                ss.setStyle(0, (String.valueOf(this.prevCond) + " ").length(), ks);
            }
        }
        if ((this.operator.getNrOperands() != 2 || this.operator.getNrOperands() == 2 && this.operator == Operator.LIKE) && (ind = dt.indexOf(sqlname = " " + this.operator.getSqlname() + " ")) >= 0) {
            ss.setStyle(ind, sqlname.length(), ks);
        }
        if (this.operator.getNrOperands() == 3 && (this.operator == Operator.BETWEEN || this.operator == Operator.NOTBETWEEN)) {
            ss.setStyle(dt.indexOf(" AND "), " AND ".length(), ks);
        }
        return ss;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }
}

