/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.sql.model.query.operand;

import com.jaspersoft.studio.data.sql.model.query.expression.AMExpression;
import com.jaspersoft.studio.data.sql.model.query.operand.AOperand;
import java.sql.Time;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.sf.jasperreports.eclipse.util.Misc;

public class ScalarOperand<T>
extends AOperand {
    public static final long serialVersionUID = 10200L;
    private T value;
    private Class<? extends T> type;

    public ScalarOperand(AMExpression<?> mexpr, T value) {
        super(mexpr);
        this.value = value;
        if (value != null) {
            this.type = value.getClass();
        }
    }

    public T getValue() {
        return this.value;
    }

    public Class<? extends T> getType() {
        return this.type;
    }

    public void setValue(T value) {
        this.value = value;
    }

    @Override
    public String toSQLString() {
        if (this.value != null) {
            if (Number.class.isAssignableFrom(this.type)) {
                if (this.value instanceof String) {
                    return (String)this.value;
                }
                NumberFormat nf = NumberFormat.getInstance();
                nf.setGroupingUsed(false);
                return nf.format((Number)this.value);
            }
            if (Time.class.isAssignableFrom(this.type)) {
                return "'" + new SimpleDateFormat("HH:mm:ss.ssss").format((Date)this.value) + "'";
            }
            if (java.sql.Date.class.isAssignableFrom(this.type)) {
                return "'" + new SimpleDateFormat("yyyy-MM-dd").format((Date)this.value) + "'";
            }
            if (Date.class.isAssignableFrom(this.type)) {
                return "'" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.ssss").format((Date)this.value) + "'";
            }
            return "'" + this.value + "'";
        }
        return Misc.nvl(this.value, (String)"NULL");
    }

    @Override
    public String toXString() {
        return this.toSQLString();
    }
}

