/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.sql.model.query.orderby;

import com.jaspersoft.studio.data.sql.model.metadata.MSQLColumn;
import com.jaspersoft.studio.data.sql.model.metadata.MSqlTable;
import com.jaspersoft.studio.data.sql.model.query.from.MFromTable;
import com.jaspersoft.studio.data.sql.model.query.orderby.AMOrderByMember;
import com.jaspersoft.studio.data.sql.model.query.select.MSelectColumn;
import com.jaspersoft.studio.data.sql.text2model.ConvertUtil;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.preferences.fonts.utils.FontUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.jface.viewers.StyledString;

public class MOrderByColumn
extends AMOrderByMember<MSQLColumn> {
    public static final long serialVersionUID = 10200L;
    private MFromTable mfTable;
    private MSelectColumn msColumn;

    public MOrderByColumn(ANode parent, MSelectColumn msColumn) {
        this(parent, (MSQLColumn)msColumn.getValue(), msColumn.getMFromTable(), -1);
    }

    public MOrderByColumn(ANode parent, MSelectColumn msColumn, int index) {
        this(parent, (MSQLColumn)msColumn.getValue(), msColumn.getMFromTable(), index);
        this.msColumn = msColumn;
    }

    public MOrderByColumn(ANode parent, MSQLColumn value, MFromTable mfTable) {
        this(parent, value, mfTable, -1);
    }

    public MOrderByColumn(ANode parent, MSQLColumn value, MFromTable mfTable, int index) {
        super(parent, value, null, index);
        this.mfTable = mfTable;
    }

    public MSelectColumn getMSelectColumn() {
        return this.msColumn;
    }

    public void setMSelectColumn(MSelectColumn msColumn) {
        this.msColumn = msColumn;
    }

    public MFromTable getMFromTable() {
        return this.mfTable;
    }

    public void setMFromTable(MFromTable mfTable) {
        this.mfTable = mfTable;
    }

    public StyledString getStyledDisplayText() {
        StyledString ss = new StyledString();
        if (this.msColumn == null || this.msColumn.getAlias() == null) {
            if (this.mfTable.getAlias() != null) {
                ss.append(this.mfTable.getAlias());
            } else {
                ss.append(ConvertUtil.cleanDbNameFull(((MSqlTable)this.mfTable.getValue()).toSQLString()));
            }
            ss.append("." + ((MSQLColumn)this.getValue()).getDisplayText());
            ss.append(this.addDirection(), FontUtils.getKeywordStyler());
        } else {
            ss.append(this.msColumn.getAlias());
        }
        return ss;
    }

    @Override
    public String toSQLString() {
        String IQ = this.getRoot().getIdentifierQuote();
        boolean onlyException = this.getRoot().isQuoteExceptions();
        StringBuffer ss = new StringBuffer();
        if (this.msColumn == null || this.msColumn.getAlias() == null) {
            if (this.mfTable.getAlias() != null && !this.mfTable.getAlias().trim().isEmpty()) {
                ss.append(this.mfTable.getAlias());
            } else {
                ss.append(((MSqlTable)this.mfTable.getValue()).toSQLString());
            }
            ss.append("." + Misc.quote((String)((MSQLColumn)this.getValue()).getDisplayText(), (String)IQ, (boolean)onlyException));
            ss.append(this.addDirection());
        } else {
            ss.append(this.msColumn.getAlias());
        }
        return this.isFirst() ? ss.toString() : ",\n\t" + ss.toString();
    }
}

