/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.sql.ui.gef;

import com.jaspersoft.studio.data.sql.SQLQueryDesigner;
import com.jaspersoft.studio.data.sql.Util;
import com.jaspersoft.studio.data.sql.action.LayoutAction;
import com.jaspersoft.studio.data.sql.action.TableModeShowAction;
import com.jaspersoft.studio.data.sql.action.TableSelectAllAction;
import com.jaspersoft.studio.data.sql.action.select.CreateColumn;
import com.jaspersoft.studio.data.sql.action.table.CreateTable;
import com.jaspersoft.studio.data.sql.action.table.DeleteTable;
import com.jaspersoft.studio.data.sql.messages.Messages;
import com.jaspersoft.studio.data.sql.model.metadata.MSQLColumn;
import com.jaspersoft.studio.data.sql.model.metadata.MSqlTable;
import com.jaspersoft.studio.data.sql.model.query.from.MFrom;
import com.jaspersoft.studio.data.sql.model.query.from.MFromTable;
import com.jaspersoft.studio.data.sql.model.query.from.MFromTableJoin;
import com.jaspersoft.studio.data.sql.model.query.from.TableJoin;
import com.jaspersoft.studio.data.sql.model.query.from.TableJoinDetail;
import com.jaspersoft.studio.data.sql.ui.gef.SQLDesignerRootEditPart;
import com.jaspersoft.studio.data.sql.ui.gef.command.AddTableCommand;
import com.jaspersoft.studio.data.sql.ui.gef.parts.ColumnEditPart;
import com.jaspersoft.studio.data.sql.ui.gef.parts.FromEditPart;
import com.jaspersoft.studio.data.sql.ui.gef.parts.QueryEditPart;
import com.jaspersoft.studio.data.sql.ui.gef.parts.SQLDesignerEditPartFactory;
import com.jaspersoft.studio.data.sql.ui.gef.parts.TableEditPart;
import com.jaspersoft.studio.dnd.NodeTransfer;
import com.jaspersoft.studio.model.AMapElement;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.DialogEnabledCommand;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.util.ModelVisitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.MouseWheelHandler;
import org.eclipse.gef.MouseWheelZoomHandler;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.dnd.AbstractTransferDropTargetListener;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.Keyboard;

public class SQLQueryDiagram {
    private SQLQueryDesigner designer;
    private ScrollingGraphicalViewer viewer;
    public static final String SQLQUERYDIAGRAM = "SQLQUERYDIAGRAM";
    private ZoomInAction zoomIn;
    private ZoomOutAction zoomOut;
    public static final String SQL_EDITOR_TABLES = "com.jaspersoft.studio.data.sql.tables";

    public SQLQueryDiagram(SQLQueryDesigner designer) {
        this.designer = designer;
    }

    public Control createDiagram(Composite parent) {
        this.viewer = new ScrollingGraphicalViewer();
        this.viewer.createControl(parent);
        this.viewer.setEditDomain((EditDomain)new DefaultEditDomain(null));
        this.viewer.setRootEditPart((RootEditPart)new SQLDesignerRootEditPart());
        this.viewer.setEditPartFactory((EditPartFactory)new SQLDesignerEditPartFactory());
        final ZoomManager zoomManager = (ZoomManager)this.viewer.getProperty(ZoomManager.class.toString());
        this.zoomIn = new ZoomInAction(zoomManager);
        this.zoomOut = new ZoomOutAction(zoomManager);
        this.viewer.setKeyHandler((KeyHandler)new GraphicalViewerKeyHandler((GraphicalViewer)this.viewer){

            public boolean keyPressed(KeyEvent event) {
                block15: {
                    block16: {
                        block14: {
                            if (event.keyCode != 127 && event.keyCode != 8) break block14;
                            SQLQueryDiagram.this.doDeleteTable();
                            break block15;
                        }
                        if ((event.stateMask & Keyboard.getCtrlKey()) == 0) break block16;
                        switch (event.keyCode) {
                            case 43: 
                            case 61: 
                            case 16777259: {
                                if (zoomManager.canZoomIn()) {
                                    SQLQueryDiagram.this.zoomIn.run();
                                    break;
                                }
                                break block15;
                            }
                            case 45: 
                            case 16777261: {
                                if (zoomManager.canZoomOut()) {
                                    SQLQueryDiagram.this.zoomOut.run();
                                    break;
                                }
                                break block15;
                            }
                            case 48: {
                                zoomManager.setZoom(1.0);
                                break;
                            }
                            case 122: {
                                if (SQLQueryDiagram.this.viewer.getEditDomain().getCommandStack().canUndo()) {
                                    SQLQueryDiagram.this.viewer.getEditDomain().getCommandStack().undo();
                                    SQLQueryDiagram.this.refreshViewer(false, false);
                                    break;
                                }
                                break block15;
                            }
                            case 121: {
                                if (!SQLQueryDiagram.this.viewer.getEditDomain().getCommandStack().canRedo()) break block15;
                                SQLQueryDiagram.this.viewer.getEditDomain().getCommandStack().redo();
                                SQLQueryDiagram.this.refreshViewer(false, false);
                            }
                            default: {
                                break;
                            }
                            {
                            }
                        }
                        break block15;
                    }
                    if ((event.stateMask & 0x10000) != 0 && event.keyCode == 122 && SQLQueryDiagram.this.viewer.getEditDomain().getCommandStack().canRedo()) {
                        SQLQueryDiagram.this.viewer.getEditDomain().getCommandStack().redo();
                        SQLQueryDiagram.this.refreshViewer(false, false);
                    }
                }
                return super.keyPressed(event);
            }
        });
        this.viewer.setProperty(MouseWheelHandler.KeyGenerator.getKey((int)SWT.MOD1), (Object)MouseWheelZoomHandler.SINGLETON);
        this.viewer.setProperty(SQLQUERYDIAGRAM, (Object)this.designer);
        this.viewer.setContextMenu((MenuManager)new ContextMenuProvider((EditPartViewer)this.viewer){

            public void buildContextMenu(IMenuManager menu) {
                TableModeShowAction ms;
                Object[] selection = null;
                IStructuredSelection s = (IStructuredSelection)SQLQueryDiagram.this.viewer.getSelection();
                if (s != null) {
                    ArrayList models = new ArrayList();
                    for (Object obj : s.toList()) {
                        if (obj instanceof EditPart) {
                            if (obj instanceof ColumnEditPart) {
                                models.add(obj);
                            } else {
                                obj = ((EditPart)obj).getModel();
                            }
                        }
                        if (obj instanceof ANode) {
                            models.add((ANode)obj);
                        }
                        if (obj instanceof TableJoin) {
                            models.add(((TableJoin)obj).getJoinTable());
                        }
                        if (!(obj instanceof TableJoinDetail)) continue;
                        models.add(obj);
                    }
                    if (!models.isEmpty()) {
                        selection = models.toArray();
                    }
                }
                SQLQueryDiagram.this.designer.getOutline().getAfactory().fillMenu(selection, menu);
                IContributionItem[] iContributionItemArray = menu.getItems();
                int n = iContributionItemArray.length;
                int obj = 0;
                while (obj < n) {
                    IContributionItem c = iContributionItemArray[obj];
                    if (c instanceof ActionContributionItem && ((ActionContributionItem)c).getAction() instanceof DeleteTable) {
                        menu.insertAfter(c.getId(), (IAction)new Action(Messages.SQLQueryDiagram_1){

                            public void run() {
                                SQLQueryDiagram.this.doDeleteTable();
                            }
                        });
                        menu.remove(c);
                    }
                    ++obj;
                }
                LayoutAction action = new LayoutAction(SQLQueryDiagram.this.designer);
                if (action.isEnabled()) {
                    menu.add((IAction)action);
                    menu.add((IContributionItem)new Separator());
                    menu.add((IAction)SQLQueryDiagram.this.zoomIn);
                    menu.add((IAction)SQLQueryDiagram.this.zoomOut);
                }
                menu.add((IContributionItem)new Separator());
                TableSelectAllAction sa = new TableSelectAllAction(SQLQueryDiagram.this.designer, Messages.SQLQueryDiagram_0);
                if (sa.calculateEnabled(selection)) {
                    menu.add((IAction)sa);
                }
                if ((ms = new TableModeShowAction(SQLQueryDiagram.this.designer, "keys", Messages.SQLQueryDiagram_2)).calculateEnabled(selection)) {
                    menu.add((IAction)ms);
                }
                if ((ms = new TableModeShowAction(SQLQueryDiagram.this.designer, null, Messages.SQLQueryDiagram_3)).calculateEnabled(selection)) {
                    menu.add((IAction)ms);
                }
                if ((ms = new TableModeShowAction(SQLQueryDiagram.this.designer, "short", Messages.SQLQueryDiagram_9)).calculateEnabled(selection)) {
                    menu.add((IAction)ms);
                }
            }
        });
        this.viewer.addDropTargetListener((TransferDropTargetListener)new QueryDesignerDropTargetListener((EditPartViewer)this.viewer, (Transfer)NodeTransfer.getInstance()));
        this.refreshViewer(false, true);
        return this.viewer.getControl();
    }

    public ScrollingGraphicalViewer getViewer() {
        return this.viewer;
    }

    protected void refreshViewer(boolean refreshSource, boolean reread) {
        String tbls;
        JRDesignDataset ds = this.designer.getjDataset();
        if (reread && ds != null && !Misc.isNullOrEmpty((String)(tbls = ds.getPropertiesMap().getProperty(SQL_EDITOR_TABLES)))) {
            final ArrayList<Table> map = new ArrayList<Table>();
            try {
                String[] tables;
                String[] stringArray = tables = Misc.decodeBase64String((String)tbls, (String)"ISO-8859-1").split(";");
                int n = tables.length;
                int n2 = 0;
                while (n2 < n) {
                    String t = stringArray[n2];
                    String[] tprm = t.split(",");
                    Table tbl = new Table();
                    tbl.tbl = tprm.length > 0 ? tprm[0] : null;
                    String xs = tprm.length > 1 ? tprm[1] : null;
                    String ys = tprm.length > 2 ? tprm[2] : null;
                    tbl.id = tprm.length > 3 ? tprm[3] : null;
                    String string = tbl.sm = tprm.length > 4 ? tprm[4] : null;
                    if (tbl != null && xs != null && ys != null) {
                        try {
                            tbl.x = Integer.parseInt(xs);
                            tbl.y = Integer.parseInt(ys);
                            map.add(tbl);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    ++n2;
                }
                final ArrayList processed = new ArrayList();
                new ModelVisitor<Object>((INode)this.designer.getRoot()){

                    public boolean visit(INode n) {
                        Table key = null;
                        if (n instanceof MFromTable) {
                            MFromTable ft = (MFromTable)n;
                            String t = String.valueOf(((MSqlTable)ft.getValue()).toSQLString()) + ft.getAliasKeyString();
                            for (Table kv : map) {
                                if (kv.tbl.equals("\t\tFROM") || !kv.tbl.equals(t) || !kv.id.equals(ft.getId())) continue;
                                key = SQLQueryDiagram.this.setupTable(processed, ft, kv);
                                break;
                            }
                        } else if (n instanceof MFrom) {
                            MFrom ft = (MFrom)n;
                            for (Table kv : map) {
                                if (!kv.tbl.equals("\t\tFROM") || !kv.id.equals(ft.getId())) continue;
                                key = SQLQueryDiagram.this.setupTable(processed, ft, kv);
                                break;
                            }
                        }
                        if (key != null) {
                            map.remove(key);
                        }
                        return true;
                    }
                };
                if (!map.isEmpty()) {
                    new ModelVisitor<Object>((INode)this.designer.getRoot()){

                        public boolean visit(INode n) {
                            Table key = null;
                            if (n instanceof MFromTable && !processed.contains(n)) {
                                MFromTable ft = (MFromTable)n;
                                String t = String.valueOf(((MSqlTable)ft.getValue()).toSQLString()) + ft.getAliasKeyString();
                                for (Table kv : map) {
                                    if (kv.tbl.equals("\t\tFROM") || !kv.tbl.equals(t)) continue;
                                    key = SQLQueryDiagram.this.setupTable(processed, ft, kv);
                                    break;
                                }
                            }
                            if (key != null) {
                                map.remove(key);
                            }
                            return true;
                        }
                    };
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.viewer.setContents((Object)this.designer.getRoot());
        TreeSelection s = (TreeSelection)this.designer.getOutline().getTreeViewer().getSelection();
        ArrayList<MFromTable> tables = new ArrayList<MFromTable>();
        for (Object obj : s.toList()) {
            if (!(obj instanceof MFromTable)) continue;
            tables.add((MFromTable)obj);
        }
        if (!tables.isEmpty()) {
            ArrayList<TableEditPart> parts = new ArrayList<TableEditPart>();
            RootEditPart ep = this.viewer.getRootEditPart();
            for (Object obj : ep.getChildren()) {
                this.doAddParts(obj, parts, tables);
            }
            this.viewer.setSelection((ISelection)new StructuredSelection(parts));
            if (!parts.isEmpty()) {
                this.viewer.reveal((EditPart)parts.get(0));
            }
        }
        if (refreshSource) {
            this.designer.refreshQueryText();
        }
    }

    private void doAddParts(Object obj, List<TableEditPart> parts, List<MFromTable> tables) {
        block3: {
            block2: {
                if (!(obj instanceof QueryEditPart)) break block2;
                for (Object o : ((QueryEditPart)((Object)obj)).getChildren()) {
                    this.doAddParts(o, parts, tables);
                }
                break block3;
            }
            if (!(obj instanceof FromEditPart)) break block3;
            for (Object tep : ((FromEditPart)((Object)obj)).getChildren()) {
                if (!(tep instanceof TableEditPart) || !tables.contains(((TableEditPart)((Object)tep)).getModel())) continue;
                parts.add((TableEditPart)((Object)tep));
            }
        }
    }

    public void scheduleRefresh(boolean refreshSource, boolean reread) {
        this.refreshViewer(refreshSource, reread);
    }

    public void dispose() {
    }

    protected void doDeleteTable() {
        ArrayList parts = new ArrayList(this.viewer.getSelectedEditParts());
        if (parts.size() > 1) {
            Collections.sort(parts, new Comparator<EditPart>(){

                @Override
                public int compare(EditPart o1, EditPart o2) {
                    if (o1 == o2) {
                        return 0;
                    }
                    if (o1.getModel() instanceof MFromTableJoin) {
                        return -1;
                    }
                    return 1;
                }
            });
        }
        CompoundCommand cc = new CompoundCommand(){
            private boolean firstRun = false;
            private boolean run = true;

            public void execute() {
                if (!this.firstRun) {
                    this.run = UIUtils.showDeleteConfirmation((Shell)SQLQueryDiagram.this.viewer.getControl().getShell(), (String)Messages.SQLQueryDiagram_6);
                }
                this.firstRun = true;
                if (this.run) {
                    super.execute();
                }
            }

            public void undo() {
                if (this.run) {
                    super.undo();
                }
            }
        };
        for (EditPart p : parts) {
            GroupRequest deleteReq = new GroupRequest((Object)"delete");
            HashMap<String, String> extendedData = new HashMap<String, String>();
            extendedData.put(Messages.SQLQueryDiagram_7, Messages.SQLQueryDiagram_8);
            deleteReq.setExtendedData(extendedData);
            deleteReq.setEditParts(p);
            cc.add(p.getCommand((Request)deleteReq));
        }
        this.viewer.getEditDomain().getCommandStack().execute((Command)cc);
        this.designer.refreshQueryText();
        this.refreshViewer(true, false);
    }

    private Table setupTable(List<AMapElement> processed, AMapElement ft, Table kv) {
        ft.setNoEvents(true);
        ft.setPropertyValue((Object)"x", (Object)kv.x);
        ft.setPropertyValue((Object)"y", (Object)kv.y);
        ft.setPropertyValue((Object)"showMode", (Object)kv.sm);
        ft.setNoEvents(false);
        Table key = kv;
        processed.add(ft);
        return key;
    }

    public class QueryDesignerDropTargetListener
    extends AbstractTransferDropTargetListener {
        public QueryDesignerDropTargetListener(EditPartViewer viewer, Transfer xfer) {
            super(viewer, xfer);
        }

        protected void updateTargetRequest() {
            ((CreateRequest)this.getTargetRequest()).setLocation(this.getDropLocation());
        }

        protected void handleDrop() {
            this.updateTargetRequest();
            this.updateTargetEditPart();
            this.doDrop(Util.getAllNodes(this.getCurrentEvent().data));
        }

        private void doDrop(List<ANode> node) {
            CreateColumn ct;
            if (this.getCurrentEvent() == null) {
                return;
            }
            final LinkedHashSet<MSqlTable> tablesset = new LinkedHashSet<MSqlTable>();
            LinkedHashSet<MSQLColumn> colsset = new LinkedHashSet<MSQLColumn>();
            LinkedHashSet<ANode> others = new LinkedHashSet<ANode>();
            Util.filterTables(node, tablesset, colsset, others);
            MFrom mfrom = null;
            EditPart ep = this.getTargetEditPart();
            if (ep instanceof ColumnEditPart) {
                ep = ep.getParent();
            }
            if (ep instanceof TableEditPart) {
                ep = ep.getParent();
            }
            mfrom = ep instanceof FromEditPart ? (MFrom)ep.getModel() : Util.getKeyword((ANode)SQLQueryDiagram.this.designer.getRoot(), MFrom.class);
            if (!tablesset.isEmpty()) {
                LinkedHashSet<MSqlTable> tmp = new LinkedHashSet<MSqlTable>();
                for (MSqlTable t : tablesset) {
                    MSqlTable mt = Util.getTable(SQLQueryDiagram.this.designer.getDbMetadata().getRoot(), t);
                    SQLQueryDiagram.this.designer.getDbMetadata().loadTable(mt);
                    tmp.add(mt);
                }
                tablesset.clear();
                tablesset.addAll(tmp);
                CreateTable ct2 = SQLQueryDiagram.this.designer.getOutline().getAfactory().getAction(CreateTable.class);
                if (ct2.calculateEnabled(new Object[]{mfrom})) {
                    CreateRequest tgReq = (CreateRequest)this.getTargetRequest();
                    tgReq.setFactory(new CreationFactory(){

                        public Object getObjectType() {
                            return MSqlTable.class;
                        }

                        public Object getNewObject() {
                            return tablesset;
                        }
                    });
                    Command command = null;
                    if (this.getTargetEditPart() != null && (command = this.getTargetEditPart().getCommand((Request)tgReq)) != null) {
                        if (command instanceof AddTableCommand) {
                            AddTableCommand c = (AddTableCommand)command;
                            c.setJoinOnDND(SQLQueryDiagram.this.designer.getjConfig().getProperty("com.jaspersoft.studio.data.sql.prefs.join_on_dnd", "drop"));
                            c.setDnDDetail(this.getCurrentEvent().detail);
                        }
                        if (command instanceof DialogEnabledCommand && command.canExecute() && ((DialogEnabledCommand)command).openDialog() == 1) {
                            this.getCurrentEvent().detail = 0;
                            return;
                        }
                    }
                    if (command != null && command.canExecute()) {
                        this.getViewer().getEditDomain().getCommandStack().execute(command);
                    } else {
                        this.getCurrentEvent().detail = 0;
                    }
                    SQLQueryDiagram.this.refreshViewer(true, false);
                }
            }
            if (!colsset.isEmpty() && (ct = SQLQueryDiagram.this.designer.getOutline().getAfactory().getAction(CreateColumn.class)).calculateEnabled(new Object[]{mfrom})) {
                ct.run(colsset);
                SQLQueryDiagram.this.refreshViewer(true, false);
            }
        }

        protected Request createTargetRequest() {
            return new CreateRequest();
        }
    }

    class Table {
        public String tbl;
        public String id;
        public int x;
        public int y;
        public String sm;

        Table() {
        }
    }
}

