/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.sql.ui.gef.command;

import com.jaspersoft.studio.data.sql.messages.Messages;
import com.jaspersoft.studio.data.sql.model.metadata.MSQLColumn;
import com.jaspersoft.studio.data.sql.model.metadata.MSqlTable;
import com.jaspersoft.studio.data.sql.model.metadata.keys.ForeignKey;
import com.jaspersoft.studio.data.sql.model.query.expression.MExpression;
import com.jaspersoft.studio.data.sql.model.query.from.MFrom;
import com.jaspersoft.studio.data.sql.model.query.from.MFromTable;
import com.jaspersoft.studio.data.sql.model.query.from.MFromTableJoin;
import com.jaspersoft.studio.data.sql.model.query.operand.AOperand;
import com.jaspersoft.studio.data.sql.model.query.operand.FieldOperand;
import com.jaspersoft.studio.data.sql.ui.gef.command.ACommand;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.util.ModelVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.draw2d.geometry.Rectangle;

public class AddTableCommand
extends ACommand {
    private Rectangle location;
    private MFrom mFrom;
    private Collection<MSqlTable> child;
    private List<MFromTable> fromTable;
    private String joinOnDND = "drop";
    private int dndDetail = 0;

    public AddTableCommand(MFrom parent, Collection<MSqlTable> child, Rectangle location) {
        this.location = location;
        this.mFrom = parent;
        this.child = child;
    }

    public void setJoinOnDND(String joinOnDND) {
        this.joinOnDND = joinOnDND;
    }

    public void setDnDDetail(int dndDetail) {
        this.dndDetail = dndDetail;
    }

    @Override
    public void execute() {
        super.execute();
        if (this.fromTable == null) {
            this.fromTable = new ArrayList<MFromTable>();
            final HashMap<ForeignKey, MFromTable> keys = new HashMap<ForeignKey, MFromTable>();
            for (MSqlTable mtlb : this.child) {
                MFromTable ft = new MFromTable((ANode)this.mFrom, mtlb);
                this.undoRemove.add(ft);
                if (this.location != null && this.child.size() == 1) {
                    ft.setNoEvents(true);
                    ft.setPropertyValue("x", this.location.x);
                    ft.setPropertyValue("y", this.location.y);
                    ft.setNoEvents(false);
                }
                this.fromTable.add(ft);
                for (INode n : mtlb.getChildren()) {
                    List<ForeignKey> lfk;
                    if (!(n instanceof MSQLColumn) || (lfk = ((MSQLColumn)n).getForeignKeys()) == null) continue;
                    for (ForeignKey fk : lfk) {
                        if (!fk.getTable().equals(mtlb)) continue;
                        keys.put(fk, ft);
                    }
                }
            }
            new ModelVisitor<Object>((INode)this.mFrom){

                public boolean visit(INode n) {
                    if (!(n instanceof MFromTable)) {
                        return false;
                    }
                    if (AddTableCommand.this.fromTable.contains(n)) {
                        return false;
                    }
                    MFromTable mft = (MFromTable)n;
                    for (INode child : ((MSqlTable)mft.getValue()).getChildren()) {
                        MSQLColumn col;
                        if (!(child instanceof MSQLColumn) || (col = (MSQLColumn)child).getForeignKeys() == null) continue;
                        for (ForeignKey fk : col.getForeignKeys()) {
                            if (fk.getDestColumns() == null || keys.containsKey(fk)) continue;
                            MSQLColumn[] mSQLColumnArray = fk.getDestColumns();
                            int n2 = mSQLColumnArray.length;
                            int n3 = 0;
                            while (n3 < n2) {
                                MSQLColumn c = mSQLColumnArray[n3];
                                MSqlTable tbl = (MSqlTable)c.getParent();
                                for (MFromTable ftbl : AddTableCommand.this.fromTable) {
                                    if (!((MSqlTable)ftbl.getValue()).equals(tbl)) continue;
                                    keys.put(fk, mft);
                                }
                                ++n3;
                            }
                        }
                    }
                    return true;
                }
            };
            boolean createFKs = false;
            if (!keys.isEmpty()) {
                if (this.joinOnDND.equals("drop")) {
                    createFKs = this.dndDetail == 2;
                } else if (this.joinOnDND.equals("ask")) {
                    createFKs = UIUtils.showConfirmation((String)Messages.AddTableCommand_0, (String)Messages.AddTableCommand_1);
                } else if (this.joinOnDND.equals("ctrl-drop")) {
                    boolean bl = createFKs = this.dndDetail == 1;
                }
            }
            if (createFKs) {
                for (ForeignKey fk : new HashSet(keys.keySet())) {
                    Iterator<MFromTable> iterator;
                    MSQLColumn c;
                    Set<MFromTable> destinations;
                    MFromTable src = (MFromTable)keys.get(fk);
                    MSQLColumn[] cols = null;
                    if (fk.getTable().equals(src.getValue())) {
                        cols = fk.getDestColumns();
                    }
                    if (cols == null) continue;
                    MSQLColumn[] mSQLColumnArray = cols;
                    if (cols.length == 0 || Misc.isNullOrEmpty(destinations = this.hasTable(c = mSQLColumnArray[0])) || destinations.contains(src)) continue;
                    MFromTable nsrc = src;
                    if (nsrc instanceof MFromTableJoin) {
                        nsrc = (MFromTable)src.getParent();
                    }
                    if (!(iterator = destinations.iterator()).hasNext()) continue;
                    MFromTable dest = iterator.next();
                    MFromTable mTbl = dest instanceof MFromTableJoin ? (MFromTable)dest.getParent() : dest;
                    MFromTableJoin join = null;
                    if (dest instanceof MFromTableJoin) {
                        join = (MFromTableJoin)dest;
                    } else {
                        MFromTable srcTbl = nsrc != mTbl ? nsrc : src;
                        join = this.convertToSubTable(dest, srcTbl);
                        for (ForeignKey fk1 : new HashSet(keys.keySet())) {
                            if (keys.get(fk1) != dest) continue;
                            keys.put(fk1, join);
                        }
                        dest = join;
                    }
                    this.joinExpression(join, dest, c, src, fk.getSrcColumns()[0]);
                }
            }
        } else {
            for (MFromTable mft : this.fromTable) {
                this.reparent((ANode)mft, (ANode)this.mFrom);
            }
        }
        this.mFrom.firePropertyChange("wrongvalue", true, false);
    }

    private Set<MFromTable> hasTable(MSQLColumn c) {
        HashSet<MFromTable> tables = new HashSet<MFromTable>();
        for (INode n : this.mFrom.getChildren()) {
            if (!(n instanceof MFromTable)) continue;
            MFromTable ft = (MFromTable)n;
            if (((MSqlTable)ft.getValue()).equals(c.getParent())) {
                tables.add(ft);
            }
            if (Misc.isNullOrEmpty((Collection)ft.getChildren())) continue;
            for (INode cn : ft.getChildren()) {
                if (!(cn instanceof MFromTable) || !((MSqlTable)(ft = (MFromTable)cn).getValue()).equals(c.getParent())) continue;
                tables.add(ft);
            }
        }
        return tables;
    }

    private void joinExpression(MFromTableJoin join, MFromTable mtbl, MSQLColumn mCol, MFromTable sTbl, MSQLColumn sCol) {
        if (!mCol.getParent().equals(mtbl.getValue())) {
            System.out.println("problem!");
        }
        if (!sCol.getParent().equals(sTbl.getValue())) {
            System.out.println("problem!");
        }
        MExpression mexpr = new MExpression((ANode)join, mtbl, -1);
        List<AOperand> operands = mexpr.getOperands();
        operands.add(new FieldOperand(sCol, sTbl, mexpr));
        operands.add(new FieldOperand(mCol, mtbl, mexpr));
        this.undoRemove.add(mexpr);
    }

    private MFromTableJoin convertToSubTable(MFromTable nsrc, MFromTable parent) {
        this.reparent((ANode)nsrc, null);
        this.fromTable.remove(nsrc);
        if (parent instanceof MFromTableJoin) {
            parent = (MFromTable)parent.getParent();
        }
        MFromTableJoin join = new MFromTableJoin(parent, (MSqlTable)nsrc.getValue());
        this.undoRemove.add(join);
        this.undoProperties.put(nsrc, nsrc.copyPropertiesUndo(join));
        if (!Misc.isNullOrEmpty((Collection)nsrc.getChildren())) {
            for (INode n : new ArrayList(nsrc.getChildren())) {
                this.reparent((ANode)n, (ANode)parent);
            }
        }
        this.fromTable.add(join);
        return join;
    }

    @Override
    protected void firePropertyChange() {
        this.mFrom.firePropertyChange("wrongvalue", true, false);
    }
}

