/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.sql.ui.gef.command;

import com.jaspersoft.studio.data.sql.SQLQueryDesigner;
import com.jaspersoft.studio.data.sql.Util;
import com.jaspersoft.studio.data.sql.model.metadata.MSQLColumn;
import com.jaspersoft.studio.data.sql.model.metadata.MSqlTable;
import com.jaspersoft.studio.data.sql.model.query.expression.MExpression;
import com.jaspersoft.studio.data.sql.model.query.from.MFrom;
import com.jaspersoft.studio.data.sql.model.query.from.MFromTable;
import com.jaspersoft.studio.data.sql.model.query.from.MFromTableJoin;
import com.jaspersoft.studio.data.sql.model.query.operand.FieldOperand;
import com.jaspersoft.studio.data.sql.model.query.subquery.MQueryTable;
import com.jaspersoft.studio.data.sql.ui.gef.command.ACommand;
import com.jaspersoft.studio.data.sql.ui.gef.command.DeleteTableJoinCommand;
import com.jaspersoft.studio.data.sql.ui.gef.command.JoinTableCommand;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import java.util.ArrayList;
import java.util.Collection;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;

public class JoinCommand
extends ACommand {
    private SQLQueryDesigner designer;
    private MSQLColumn src;
    private MSQLColumn dest;
    private MFromTable srcTbl;
    private MFromTable destTbl;

    public JoinCommand(MSQLColumn src, MFromTable srcTbl, MSQLColumn dest, MFromTable destTbl, SQLQueryDesigner designer) {
        this.designer = designer;
        this.src = src;
        this.srcTbl = srcTbl;
        this.dest = dest;
        this.destTbl = destTbl;
    }

    public JoinCommand(MFromTable srcTbl, MFromTable destTbl, SQLQueryDesigner designer) {
        this.designer = designer;
        this.srcTbl = srcTbl;
        this.destTbl = destTbl;
    }

    @Override
    public void execute() {
        super.execute();
        MFromTable mfSrcTbl = this.srcTbl;
        if (this.srcTbl.getParent() instanceof MFrom && this.srcTbl.getParent() != null && this.srcTbl.getParent().getParent() instanceof MFromTable && this.srcTbl.getParent().getParent().getValue() != null && this.srcTbl.getParent().getParent().getValue() instanceof MQueryTable) {
            mfSrcTbl = (MFromTable)this.srcTbl.getParent().getParent();
        }
        MFromTable mfDesttbl = this.destTbl;
        if (this.destTbl.getParent() instanceof MFrom && this.destTbl.getParent() != null && this.destTbl.getParent().getParent() instanceof MFromTable && this.destTbl.getParent().getParent().getValue() != null && this.destTbl.getParent().getParent().getValue() instanceof MQueryTable) {
            mfDesttbl = (MFromTable)this.destTbl.getParent().getParent();
        }
        if (mfDesttbl != mfSrcTbl) {
            this.srcTbl = mfSrcTbl;
            this.destTbl = mfDesttbl;
        }
        if (this.srcTbl instanceof MFromTableJoin && !(this.destTbl instanceof MFromTableJoin)) {
            MFromTable tmp = this.srcTbl;
            MSQLColumn tmpColumn = this.src;
            this.srcTbl = this.destTbl;
            this.src = this.dest;
            this.destTbl = tmp;
            this.dest = tmpColumn;
        }
        if (this.srcTbl instanceof MFromTableJoin) {
            DeleteTableJoinCommand cmd = new DeleteTableJoinCommand(new Object[]{this.srcTbl});
            this.undoCmd.add(cmd);
            cmd.execute();
            this.srcTbl = cmd.getResultFromTable();
        }
        MFromTable fromTbl = this.destTbl;
        if (this.destTbl instanceof MFromTableJoin) {
            fromTbl = JoinCommand.getParentFromTable((MFromTableJoin)this.destTbl);
        }
        if (this.srcTbl == this.destTbl) {
            return;
        }
        if (this.srcTbl instanceof MFromTable) {
            this.srcTbl = this.convertToSubTable(this.srcTbl, fromTbl);
        }
        for (INode n : fromTbl.getChildren()) {
            if (n != this.destTbl) continue;
            MExpression mexpr = new MExpression((ANode)this.srcTbl, this.src, -1);
            this.undoRemove.add(mexpr);
            mexpr.getOperands().add(new FieldOperand(this.src, this.srcTbl, mexpr));
            mexpr.getOperands().add(new FieldOperand(this.dest, this.destTbl, mexpr));
            this.refresh();
            return;
        }
        String join = "INNER JOIN";
        if (this.srcTbl instanceof MFromTableJoin) {
            join = ((MFromTableJoin)this.srcTbl).getJoin();
        } else if (this.destTbl instanceof MFromTableJoin) {
            join = ((MFromTableJoin)this.destTbl).getJoin();
        }
        JoinTableCommand c = new JoinTableCommand(this.src, this.srcTbl, this.dest, this.destTbl, fromTbl, join);
        this.undoCmd.add(c);
        c.execute();
        if (this.srcTbl instanceof MFromTable && !this.srcTbl.getChildren().isEmpty()) {
            ArrayList<MFromTableJoin> lst = new ArrayList<MFromTableJoin>();
            for (INode iNode : this.srcTbl.getChildren()) {
                if (iNode == this.destTbl) {
                    return;
                }
                if (!(iNode instanceof MFromTableJoin)) continue;
                lst.add((MFromTableJoin)iNode);
            }
            for (MFromTable mFromTable : lst) {
                this.reparent((ANode)mFromTable, (ANode)this.destTbl);
            }
        }
        this.refresh();
    }

    private MFromTableJoin convertToSubTable(MFromTable nsrc, MFromTable parent) {
        if (nsrc != parent) {
            this.reparent((ANode)nsrc, null);
        }
        MFromTableJoin join = new MFromTableJoin(parent, (MSqlTable)nsrc.getValue());
        this.undoRemove.add(join);
        this.undoProperties.put(nsrc, nsrc.copyPropertiesUndo(join));
        if (!Misc.isNullOrEmpty((Collection)nsrc.getChildren())) {
            for (INode n : new ArrayList(nsrc.getChildren())) {
                this.reparent((ANode)n, (ANode)parent);
            }
        }
        Util.cleanTableVersions(join, nsrc);
        return join;
    }

    private void refresh() {
        TreeViewer tv = this.designer.getOutline().getTreeViewer();
        tv.refresh(true);
        tv.setSelection((ISelection)new TreeSelection(new TreePath(new Object[]{this.destTbl})));
        tv.reveal((Object)this.destTbl);
    }

    public static MFromTable getParentFromTable(MFromTableJoin dest) {
        ANode res = dest.getParent();
        while (res != null) {
            if (res instanceof MFromTable && !(res instanceof MFromTableJoin)) {
                return (MFromTable)res;
            }
            res = res.getParent();
        }
        return dest;
    }

    @Override
    protected void firePropertyChange() {
    }
}

