/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.sql.ui.gef.command;

import com.jaspersoft.studio.data.sql.SQLQueryDesigner;
import com.jaspersoft.studio.data.sql.model.query.from.MFromTable;
import com.jaspersoft.studio.data.sql.model.query.from.MFromTableJoin;
import com.jaspersoft.studio.data.sql.model.query.from.TableJoin;
import com.jaspersoft.studio.data.sql.ui.gef.command.ACommand;
import com.jaspersoft.studio.data.sql.ui.gef.command.DeleteTableJoinCommand;
import com.jaspersoft.studio.data.sql.ui.gef.command.JoinCommand;
import com.jaspersoft.studio.data.sql.ui.gef.command.JoinTableCommand;

public class MoveJoinCommand
extends ACommand {
    private MFromTable destTbl;
    private MFromTable srcTbl;
    private TableJoin tjoin;

    public MoveJoinCommand(MFromTable destTbl, TableJoin tjoin, SQLQueryDesigner designer) {
        this.tjoin = tjoin;
        this.destTbl = destTbl;
        this.srcTbl = tjoin.getJoinTable();
    }

    public MoveJoinCommand(TableJoin tjoin, MFromTable destTbl, SQLQueryDesigner designer) {
        this.tjoin = tjoin;
        this.destTbl = tjoin.getFromTable();
        this.srcTbl = destTbl;
    }

    @Override
    public void execute() {
        super.execute();
        ACommand c = new DeleteTableJoinCommand(new Object[]{this.tjoin.getJoinTable()});
        this.undoCmd.add(c);
        c.execute();
        if (this.srcTbl instanceof MFromTableJoin) {
            this.srcTbl = c.getResultFromTable();
        }
        MFromTable fromTbl = this.destTbl;
        if (this.destTbl instanceof MFromTableJoin) {
            fromTbl = JoinCommand.getParentFromTable((MFromTableJoin)this.destTbl);
        }
        String join = "INNER JOIN";
        if (this.srcTbl instanceof MFromTableJoin) {
            join = ((MFromTableJoin)this.srcTbl).getJoin();
        } else if (this.destTbl instanceof MFromTableJoin) {
            join = ((MFromTableJoin)this.destTbl).getJoin();
        }
        c = new JoinTableCommand(null, this.srcTbl, null, this.destTbl, fromTbl, join);
        this.undoCmd.add(c);
        c.execute();
    }

    @Override
    protected void firePropertyChange() {
    }
}

