/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.sql.ui.gef.parts;

import com.jaspersoft.studio.data.sql.SQLQueryDesigner;
import com.jaspersoft.studio.data.sql.Util;
import com.jaspersoft.studio.data.sql.action.ActionFactory;
import com.jaspersoft.studio.data.sql.action.select.CreateColumn;
import com.jaspersoft.studio.data.sql.action.select.DeleteColumn;
import com.jaspersoft.studio.data.sql.messages.Messages;
import com.jaspersoft.studio.data.sql.model.metadata.MSQLColumn;
import com.jaspersoft.studio.data.sql.model.metadata.MSqlTable;
import com.jaspersoft.studio.data.sql.model.query.from.MFromTable;
import com.jaspersoft.studio.data.sql.model.query.select.MSelect;
import com.jaspersoft.studio.data.sql.model.query.select.MSelectColumn;
import com.jaspersoft.studio.data.sql.model.query.select.MSelectExpression;
import com.jaspersoft.studio.data.sql.ui.gef.command.CreateColumnCommand;
import com.jaspersoft.studio.data.sql.ui.gef.command.DeleteObjectCommand;
import com.jaspersoft.studio.data.sql.ui.gef.figures.ColumnFigure;
import com.jaspersoft.studio.data.sql.ui.gef.parts.TableEditPart;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import java.util.ArrayList;
import net.sf.jasperreports.eclipse.JasperReportsPlugin;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class ColumnEditPart
extends AbstractGraphicalEditPart {
    private String colname;
    private MSelectColumn mSelCol;
    private ActionFactory afactory;
    private MSelect mselect;
    private boolean isRefreshing = false;

    protected IFigure createFigure() {
        this.colname = this.getModel().getValue();
        Image image = null;
        ImageDescriptor imgd = this.getModel().getImagePath();
        if (imgd != null) {
            image = JasperReportsPlugin.getDefault().getImage(imgd);
        }
        final SQLQueryDesigner designer = (SQLQueryDesigner)((Object)this.getViewer().getProperty("SQLQUERYDIAGRAM"));
        this.afactory = designer.getOutline().getAfactory();
        final MFromTable tblModel = this.getParent().getModel();
        this.mselect = Util.getKeyword((ANode)tblModel, MSelect.class);
        ColumnFigure cbfig = new ColumnFigure(this.colname, image){

            @Override
            protected void handleSelectionChanged() {
                super.handleSelectionChanged();
                if (ColumnEditPart.this.isRefreshing) {
                    return;
                }
                CompoundCommand c = new CompoundCommand();
                CreateColumn ct = ColumnEditPart.this.afactory.getAction(CreateColumn.class);
                if (this.isSelected()) {
                    if (ct.calculateEnabled(new Object[]{ColumnEditPart.this.mselect})) {
                        MSelect mSelect = Util.getKeyword((ANode)tblModel, MSelect.class);
                        c.add((Command)new CreateColumnCommand(ColumnEditPart.this.getModel(), mSelect, -1, tblModel));
                    }
                } else {
                    if (ColumnEditPart.this.getParent().isAllstar(ColumnEditPart.this.mselect)) {
                        boolean tmp = ColumnEditPart.this.isRefreshing;
                        ColumnEditPart.this.isRefreshing = true;
                        MSelectExpression todel = null;
                        for (INode n : ColumnEditPart.this.mselect.getChildren()) {
                            if (!(n instanceof MSelectExpression) || !n.getValue().equals("*")) continue;
                            todel = (MSelectExpression)n;
                            break;
                        }
                        if (todel != null) {
                            ArrayList<ANode> tl = new ArrayList<ANode>();
                            tl.add((ANode)todel);
                            c.add((Command)new DeleteObjectCommand(tl));
                        }
                        MFromTable mFromTable = ColumnEditPart.this.getParent().getModel();
                        for (INode n : ((MSqlTable)mFromTable.getValue()).getChildren()) {
                            if (!(n instanceof MSQLColumn)) continue;
                            boolean exists = false;
                            for (INode sc : ColumnEditPart.this.mselect.getChildren()) {
                                if (!(sc instanceof MSelectColumn) || !((MSQLColumn)((MSelectColumn)sc).getValue()).equals(n)) continue;
                                exists = true;
                                break;
                            }
                            if (exists) continue;
                            c.add((Command)new CreateColumnCommand((MSQLColumn)n, ColumnEditPart.this.mselect, -1, mFromTable));
                        }
                        ColumnEditPart.this.getParent().refreshModel();
                        ColumnEditPart.this.refreshVisuals();
                        ColumnEditPart.this.isRefreshing = tmp;
                    }
                    ArrayList<ANode> todel = new ArrayList<ANode>();
                    todel.add((ANode)ColumnEditPart.this.mSelCol);
                    if (!DeleteColumn.showConfirmation(designer, Messages.ColumnEditPart_1, todel)) {
                        return;
                    }
                    if (ColumnEditPart.this.mSelCol == null) {
                        Command cmddel = null;
                        for (Command cmd : c.getCommands()) {
                            if (!(cmd instanceof CreateColumnCommand) || !((CreateColumnCommand)cmd).getColumn().getValue().equals(ColumnEditPart.this.colname)) continue;
                            cmddel = cmd;
                            break;
                        }
                        c.getCommands().remove(cmddel);
                    } else {
                        c.add((Command)new DeleteObjectCommand(todel));
                    }
                }
                designer.getDiagram().getViewer().getEditDomain().getCommandStack().execute((Command)c);
                designer.getDiagram().scheduleRefresh(true, false);
            }
        };
        cbfig.setToolTip((IFigure)new Label(this.getModel().getToolTip()));
        return cbfig;
    }

    public TableEditPart getParent() {
        return (TableEditPart)super.getParent();
    }

    public ColumnFigure getFigure() {
        return (ColumnFigure)super.getFigure();
    }

    protected void refreshVisuals() {
        this.isRefreshing = true;
        if (this.getParent().isAllstar()) {
            this.getFigure().setSelected(true);
        } else {
            this.mSelCol = this.getParent().getColumnMap().get(this.colname);
            this.getFigure().setSelected(this.mSelCol != null);
        }
        this.isRefreshing = false;
    }

    public MSelectColumn getmSelectColumn() {
        return this.mSelCol;
    }

    public MSQLColumn getModel() {
        return (MSQLColumn)super.getModel();
    }

    protected void createEditPolicies() {
    }
}

