/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.sql.validator;

import com.jaspersoft.studio.data.querydesigner.sql.text.SQLScanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jasperreports.eclipse.messages.Messages;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class TableAliasStringValidator
implements IValidator {
    private Pattern pattern = Pattern.compile("^[A-Za-z0-9_-]{0,100}$");

    public IStatus validate(Object value) {
        if (value == null || ((String)value).isEmpty()) {
            return Status.OK_STATUS;
        }
        String str = (String)value;
        Matcher matcher = this.pattern.matcher(str);
        if (!matcher.matches()) {
            return ValidationStatus.error((String)Messages.IDStringValidator_InvalidChars);
        }
        if (SQLScanner.SQL_KEYWORDS.contains(str.trim().toLowerCase())) {
            return ValidationStatus.error((String)"Please do not use SQL reserved keywords");
        }
        return Status.OK_STATUS;
    }
}

