/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.ui.contentassist;

import com.jaspersoft.studio.data.sql.SQLQueryDesigner;
import com.jaspersoft.studio.data.sql.Util;
import com.jaspersoft.studio.data.sql.impl.SelectImpl;
import com.jaspersoft.studio.data.sql.model.MSQLRoot;
import com.jaspersoft.studio.data.sql.model.metadata.MSQLColumn;
import com.jaspersoft.studio.data.sql.model.metadata.MSqlSchema;
import com.jaspersoft.studio.data.sql.model.metadata.MSqlTable;
import com.jaspersoft.studio.data.sql.model.query.AMQueryAliased;
import com.jaspersoft.studio.data.sql.model.query.expression.MExpressionX;
import com.jaspersoft.studio.data.sql.model.query.from.MFromTable;
import com.jaspersoft.studio.data.sql.model.query.select.MSelect;
import com.jaspersoft.studio.data.sql.text2model.Text2Model;
import com.jaspersoft.studio.data.ui.contentassist.AbstractSqlProposalProvider;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import java.util.LinkedHashMap;
import java.util.List;
import net.sf.jasperreports.eclipse.JasperReportsPlugin;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;

public class SqlProposalProvider
extends AbstractSqlProposalProvider {
    private MSQLRoot qroot;

    protected Object getDesigner(ContentAssistContext context) {
        return context.getViewer().getTextWidget().getData("SQLQUERYDESIGNER");
    }

    @Override
    public void complete_FromTableJoin(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeTables(context, acceptor);
    }

    @Override
    public void completeFromTable_Table(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeTables(context, acceptor);
    }

    protected void proposeTables(ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        Object obj = this.getDesigner(context);
        if (obj instanceof SQLQueryDesigner) {
            ConfigurableCompletionProposal proposal;
            SQLQueryDesigner d = (SQLQueryDesigner)((Object)obj);
            d.refreshQueryModel();
            Image img = JasperReportsPlugin.getDefault().getImage("icons/table.png");
            LinkedHashMap<String, MSqlTable> tables = d.getDbMetadata().getTables();
            for (String s : tables.keySet()) {
                String sp = tables.get(s).getDisplayText();
                proposal = (ConfigurableCompletionProposal)this.createCompletionProposal(sp, s, img, context);
                if (proposal == null) continue;
                if (tables.get(s).isCurrentSchema()) {
                    proposal.setReplacementString(s);
                }
                acceptor.accept((ICompletionProposal)proposal);
            }
            img = JasperReportsPlugin.getDefault().getImage("icons/database.png");
            for (INode n : d.getDbMetadata().getRoot().getChildren()) {
                if (!(n instanceof MSqlSchema) || ((MSqlSchema)n).isNotInMetadata() || ((MSqlSchema)n).isCurrent()) continue;
                String s = (String)n.getValue();
                proposal = (ConfigurableCompletionProposal)this.createCompletionProposal(n.getDisplayText(), s, img, context);
                if (proposal == null) continue;
                acceptor.accept((ICompletionProposal)proposal);
            }
        }
    }

    @Override
    public void completeOrderByColumnFull_ColOrder(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeColumnOrAlias(context, acceptor);
    }

    @Override
    public void completeGroupByColumnFull_ColGrBy(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeColumnOrAlias(context, acceptor);
    }

    @Override
    public void completeColumnOperand_Cfull(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeColumn(context, acceptor);
    }

    @Override
    public void completeXExpression_Col(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeColumnOrAlias(context, acceptor);
    }

    protected ANode proposeColumn(ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        Object obj = this.getDesigner(context);
        if (obj instanceof SQLQueryDesigner) {
            SQLQueryDesigner d = (SQLQueryDesigner)((Object)obj);
            this.qroot = ((SQLQueryDesigner)((Object)obj)).createRoot(this.qroot);
            Util.createSelect((ANode)this.qroot);
            if (context.getCurrentModel() instanceof SelectImpl) {
                Text2Model.convertSelect(d, (ANode)this.qroot, (SelectImpl)context.getCurrentModel());
                List<MFromTable> tbls = Util.getFromTables((ANode)this.qroot);
                for (MFromTable mft : tbls) {
                    for (INode n : ((MSqlTable)mft.getValue()).getChildren()) {
                        MSQLColumn mc = (MSQLColumn)n;
                        String s = mc.getValue();
                        s = mft.getAlias() != null ? String.valueOf(mft.getAlias()) + "." + s : String.valueOf(((MSqlTable)mft.getValue()).toSQLString()) + "." + s;
                        ConfigurableCompletionProposal proposal = (ConfigurableCompletionProposal)this.createCompletionProposal(mc.getDisplayText(), s, null, context);
                        if (proposal == null) continue;
                        if (((MSqlTable)mft.getValue()).isCurrentSchema()) {
                            proposal.setReplacementString(mc.getDisplayText());
                        }
                        acceptor.accept((ICompletionProposal)proposal);
                    }
                }
            }
        }
        return this.qroot;
    }

    protected void proposeColumnOrAlias(ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        ANode qroot = this.proposeColumn(context, acceptor);
        if (qroot != null) {
            MSelect msel = Util.getKeyword(qroot, MSelect.class);
            for (INode n : msel.getChildren()) {
                ConfigurableCompletionProposal proposal;
                if (!(n instanceof AMQueryAliased) || ((AMQueryAliased)n).getAlias() == null || (proposal = (ConfigurableCompletionProposal)this.createCompletionProposal(((AMQueryAliased)n).getAlias(), n.getStyledDisplayText(), null, context)) == null) continue;
                acceptor.accept((ICompletionProposal)proposal);
            }
        }
    }

    @Override
    public void completeXExpression_Xf(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String[] stringArray = MExpressionX.FUNCTIONS;
        int n = MExpressionX.FUNCTIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            ICompletionProposal proposal = this.createCompletionProposal(s, context);
            if (proposal != null) {
                acceptor.accept(proposal);
            }
            ++n2;
        }
    }

    @Override
    public void completeParameterOperand_Prm(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeJRParameter(context, acceptor);
    }

    @Override
    public void completeExclamationParameterOperand_Prm(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeJRParameter(context, acceptor);
    }

    protected void proposeJRParameter(ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        SQLQueryDesigner d;
        JRDesignDataset ds;
        Object obj = this.getDesigner(context);
        if (obj instanceof SQLQueryDesigner && (ds = (d = (SQLQueryDesigner)((Object)obj)).getjDataset()) != null) {
            for (JRParameter p : ds.getParametersList()) {
                ICompletionProposal proposal;
                if (!Number.class.isAssignableFrom(p.getValueClass()) && !String.class.isAssignableFrom(p.getValueClass()) || (proposal = this.createCompletionProposal(p.getName(), context)) == null) continue;
                acceptor.accept(proposal);
            }
        }
    }
}

