/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.properties;

public class SVNPropertyDefinition
implements Comparable {
    private final String name;
    private final String description;
    private String type = "String";
    private int showFor;
    private boolean allowRecurse = true;
    public static final int BOTH = 0;
    public static final int FOLDER = 1;
    public static final int FILE = 2;
    public static final String STRING = "String";
    public static final String NUMBER = "Number";
    public static final String URL = "URL";
    public static final String BOOLEAN = "Boolean";

    public SVNPropertyDefinition(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public SVNPropertyDefinition(String name, String description, int showFor) {
        this(name, description);
        this.showFor = showFor;
    }

    public SVNPropertyDefinition(String name, String description, int showFor, boolean allowRecurse) {
        this(name, description, showFor);
        this.allowRecurse = allowRecurse;
    }

    public SVNPropertyDefinition(String name, String description, int showFor, boolean allowRecurse, String type) {
        this(name, description, showFor, allowRecurse);
        this.type = type;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public int compareTo(Object property) {
        SVNPropertyDefinition compare = (SVNPropertyDefinition)property;
        return this.name.compareTo(compare.getName());
    }

    public int getShowFor() {
        return this.showFor;
    }

    public boolean showForFile() {
        return this.showFor == 0 || this.showFor == 2;
    }

    public boolean showForFolder() {
        return this.showFor == 0 || this.showFor == 1;
    }

    public boolean isAllowRecurse() {
        return this.allowRecurse;
    }

    public String getType() {
        return this.type;
    }

    public boolean isNumber() {
        return this.type.equals(NUMBER);
    }

    public boolean isBoolean() {
        return this.type.equals(BOOLEAN);
    }

    public boolean isUrl() {
        return this.type.equals(URL);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SVNPropertyDefinition)) {
            return false;
        }
        return ((SVNPropertyDefinition)object).getName().equals(this.name);
    }
}

