/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.resources;

import java.io.File;
import java.util.Date;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.team.core.TeamException;
import org.tigris.subversion.subclipse.core.ISVNRemoteFolder;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.resources.BaseFile;
import org.tigris.subversion.subclipse.core.resources.BaseFolder;
import org.tigris.subversion.subclipse.core.resources.LocalResourceStatus;
import org.tigris.subversion.subclipse.core.util.Assert;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tigris.subversion.svnclientadapter.utils.SVNUrlUtils;

public abstract class BaseResource
extends PlatformObject
implements ISVNRemoteResource {
    private String charset = null;
    protected LocalResourceStatus localResourceStatus;
    protected IResource resource;
    private ISVNRemoteFolder parent;

    public BaseResource(IResource resource, LocalResourceStatus localResourceStatus) {
        Assert.isNotNull(resource);
        Assert.isNotNull(localResourceStatus);
        this.localResourceStatus = localResourceStatus;
        this.resource = resource;
    }

    public BaseResource(IResource resource, LocalResourceStatus localResourceStatus, String charset) {
        Assert.isNotNull(resource);
        Assert.isNotNull(localResourceStatus);
        this.localResourceStatus = localResourceStatus;
        this.charset = charset;
        this.resource = resource;
    }

    public static BaseResource from(IResource resource, LocalResourceStatus localResourceStatus) {
        if (SVNNodeKind.FILE.equals((Object)localResourceStatus.getNodeKind())) {
            return new BaseFile(resource, localResourceStatus);
        }
        return new BaseFolder(resource, localResourceStatus);
    }

    @Override
    public String getName() {
        return this.localResourceStatus.getFile().getName();
    }

    public String getContentIdentifier() {
        return SVNRevision.BASE.toString();
    }

    public byte[] asBytes() {
        return this.getContentIdentifier().getBytes();
    }

    @Override
    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (!(target instanceof BaseResource)) {
            return false;
        }
        BaseResource base = (BaseResource)target;
        return base.isContainer() == this.isContainer() && base.getUrl().equals((Object)this.getUrl()) && base.getRevision() == this.getRevision();
    }

    public int hashCode() {
        return this.getUrl().hashCode() + this.getRevision().hashCode();
    }

    @Override
    public ISVNRepositoryLocation getRepository() {
        return this.localResourceStatus.getRepository();
    }

    @Override
    public SVNUrl getUrl() {
        return this.localResourceStatus.getUrl();
    }

    @Override
    public SVNRevision.Number getLastChangedRevision() {
        return this.localResourceStatus.getLastChangedRevision();
    }

    @Override
    public SVNRevision getRevision() {
        return SVNRevision.BASE;
    }

    @Override
    public Date getDate() {
        return this.localResourceStatus.getLastChangedDate();
    }

    @Override
    public String getAuthor() {
        return this.localResourceStatus.getLastCommitAuthor();
    }

    public File getFile() {
        return this.localResourceStatus.getFile();
    }

    public IPath getPath() {
        return this.localResourceStatus.getIPath();
    }

    @Override
    public String getRepositoryRelativePath() {
        return SVNUrlUtils.getRelativePath((SVNUrl)this.getRepository().getUrl(), (SVNUrl)this.getUrl(), (boolean)true);
    }

    @Override
    public String getProjectRelativePath() {
        ISVNRemoteResource project = this;
        while (project.getParent() != null) {
            project = project.getParent();
        }
        return SVNUrlUtils.getRelativePath((SVNUrl)project.getUrl(), (SVNUrl)this.getUrl(), (boolean)true);
    }

    @Override
    public ISVNLogMessage[] getLogMessages(SVNRevision pegRevision, SVNRevision revisionStart, SVNRevision revisionEnd, boolean stopOnCopy, boolean fetchChangePath, long limit, boolean includeMergedRevisions) throws TeamException {
        ISVNClientAdapter svnClient = this.getRepository().getSVNClient();
        try {
            ISVNLogMessage[] iSVNLogMessageArray = svnClient.getLogMessages(this.getFile(), pegRevision, revisionStart, revisionEnd, stopOnCopy, fetchChangePath, limit, includeMergedRevisions);
            return iSVNLogMessageArray;
        }
        catch (SVNClientException e) {
            throw new TeamException("Failed in BaseResource.getLogMessages()", (Throwable)e);
        }
        finally {
            this.getRepository().returnSVNClient(svnClient);
        }
    }

    @Override
    public boolean exists(IProgressMonitor monitor) throws TeamException {
        return true;
    }

    @Override
    public ISVNRemoteFolder getParent() {
        return this.parent;
    }

    public void setParent(ISVNRemoteFolder parent) {
        this.parent = parent;
    }

    public String getCharset() {
        return this.charset;
    }

    public String toString() {
        return this.localResourceStatus != null ? this.localResourceStatus.getPath() : "";
    }

    @Override
    public IResource getResource() {
        return this.resource;
    }
}

