/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.resourcesListeners;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.tigris.subversion.subclipse.core.ISVNLocalFile;
import org.tigris.subversion.subclipse.core.ISVNLocalFolder;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.client.OperationManager;
import org.tigris.subversion.subclipse.core.resources.SVNMoveDeleteHook;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.core.util.JobUtility;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class RevertResourceManager
implements IResourceChangeListener {
    public void resourceChanged(IResourceChangeEvent event) {
        final ArrayList addedFileResources = new ArrayList();
        try {
            IResourceDelta[] resources;
            ISVNLocalResource[] revertResources;
            event.getDelta().accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    IResource resource = delta.getResource();
                    if (resource.getType() == 4) {
                        IProject project = (IProject)resource;
                        if (!project.isAccessible()) {
                            return false;
                        }
                        if ((delta.getFlags() & 0x4000) != 0) {
                            return false;
                        }
                        if (!SVNWorkspaceRoot.isManagedBySubclipse(project)) {
                            return false;
                        }
                    } else if (resource.getType() == 1) {
                        if (delta.getKind() == 1 || delta.getKind() == 4) {
                            addedFileResources.add(delta);
                        } else if (delta.getKind() == 2) {
                            SVNMoveDeleteHook.removeFromDeletedFileList((IFile)delta.getResource());
                        }
                    }
                    return true;
                }
            });
            if (!addedFileResources.isEmpty() && (revertResources = this.processResources(resources = addedFileResources.toArray(new IResourceDelta[addedFileResources.size()]))).length > 0) {
                ArrayList<IProject> projects = new ArrayList<IProject>();
                ISVNLocalResource[] iSVNLocalResourceArray = revertResources;
                int n = revertResources.length;
                int n2 = 0;
                while (n2 < n) {
                    ISVNLocalResource revertResource = iSVNLocalResourceArray[n2];
                    IProject project = revertResource.getResource().getProject();
                    if (project != null && !projects.contains(project)) {
                        projects.add(project);
                    }
                    ++n2;
                }
                IProject[] projectArray = new IProject[projects.size()];
                projects.toArray(projectArray);
                JobUtility.scheduleJob("Revert Resources", new Runnable(){

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Override
                    public void run() {
                        try {
                            int i = 0;
                            while (i < revertResources.length) {
                                if (revertResources[i] instanceof ISVNLocalFile) {
                                    ISVNLocalFile res = (ISVNLocalFile)revertResources[i];
                                    File file = res.getFile().getAbsoluteFile();
                                    File tmp = new File(String.valueOf(res.getFile().getAbsolutePath()) + ".svntmp");
                                    if (tmp.exists()) {
                                        tmp.delete();
                                    }
                                    if (!file.renameTo(tmp)) throw SVNException.wrapException(new IllegalStateException("Could not rename " + file + " to " + tmp));
                                    RevertResourceManager.this.revert(res);
                                    if (!file.delete() && file.exists()) {
                                        throw SVNException.wrapException(new IllegalStateException("Could not remove " + file));
                                    }
                                    if (!tmp.renameTo(file)) {
                                        throw SVNException.wrapException(new IllegalStateException("Could not rename " + tmp + " to " + file));
                                    }
                                    try {
                                        res.getParent().getResource().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                                    }
                                    catch (CoreException coreException) {}
                                } else {
                                    RevertResourceManager.this.revert(revertResources[i]);
                                }
                                ++i;
                            }
                            return;
                        }
                        catch (SVNException e) {
                            SVNProviderPlugin.log(e.getStatus());
                        }
                    }
                }, MultiRule.combine((ISchedulingRule[])projectArray), false);
            }
        }
        catch (CoreException e) {
            SVNProviderPlugin.log(e.getStatus());
        }
    }

    private ISVNLocalResource[] processResources(IResourceDelta[] resources) throws CoreException {
        ArrayList<ISVNLocalResource> revertedResources = new ArrayList<ISVNLocalResource>();
        IResourceDelta[] iResourceDeltaArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            ISVNLocalFile res;
            IResourceDelta resourceDelta = iResourceDeltaArray[n2];
            IResource resource = resourceDelta.getResource();
            if (resource.getType() == 1 && (res = SVNWorkspaceRoot.getSVNFileFor((IFile)resource)).getFile().exists()) {
                boolean deleted;
                if (resourceDelta.getKind() == 1) {
                    deleted = res.getStatusFromCache().isDeleted();
                } else {
                    deleted = SVNMoveDeleteHook.isDeleted((IFile)resource);
                    if (deleted) {
                        SVNMoveDeleteHook.removeFromDeletedFileList((IFile)resource);
                    }
                }
                if (deleted) {
                    revertedResources.add(res);
                }
                ISVNLocalFolder parentFolder = res.getParent();
                while (parentFolder != null) {
                    if (!parentFolder.getStatusFromCache().isDeleted() || parentFolder.getResource().exists() || revertedResources.contains(parentFolder)) break;
                    revertedResources.add(parentFolder);
                    if (parentFolder.getParent() == null) break;
                    parentFolder = parentFolder.getParent();
                }
            }
            ++n2;
        }
        return revertedResources.toArray(new ISVNLocalResource[revertedResources.size()]);
    }

    private void revert(ISVNLocalResource resource) throws SVNException {
        ISVNClientAdapter svnClient = null;
        try {
            try {
                svnClient = resource.getRepository().getSVNClient();
                OperationManager.getInstance().beginOperation(svnClient);
                svnClient.revert(resource.getFile(), false);
            }
            catch (SVNClientException e) {
                throw SVNException.wrapException((Exception)((Object)e));
            }
        }
        finally {
            resource.getRepository().returnSVNClient(svnClient);
            OperationManager.getInstance().endOperation();
        }
    }
}

