/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.resourcesListeners;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.tigris.subversion.subclipse.core.Policy;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.core.status.StatusCacheManager;

public class SyncFileChangeListener
implements IResourceChangeListener {
    protected int INTERESTING_CHANGES = 323840;

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            final StatusCacheManager cacheManager = SVNProviderPlugin.getPlugin().getStatusCacheManager();
            event.getDelta().accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) {
                    IResource resource = delta.getResource();
                    if (resource.getType() == 8) {
                        return true;
                    }
                    if (resource.getType() == 4) {
                        if (!resource.isAccessible()) {
                            return false;
                        }
                        if (!SVNWorkspaceRoot.isManagedBySubclipse((IProject)resource)) {
                            return false;
                        }
                    }
                    String name = resource.getName();
                    int kind = delta.getKind();
                    try {
                        if (resource.getType() == 2 && kind == 1 && cacheManager.hasCachedStatus(resource) && cacheManager.getStatus(resource).isManaged()) {
                            if (Policy.DEBUG_METAFILE_CHANGES) {
                                System.out.println("[svn] duplicte ADD change event registered in SyncFileChangeListener: " + resource);
                            }
                            return false;
                        }
                    }
                    catch (SVNException sVNException) {
                        return true;
                    }
                    if (kind == 4 && (delta.getFlags() & SyncFileChangeListener.this.INTERESTING_CHANGES) == 0) {
                        return true;
                    }
                    if (SVNProviderPlugin.getPlugin().isAdminDirectory(name)) {
                        SyncFileChangeListener.this.handleSVNDir((IContainer)resource, kind);
                    }
                    return true;
                }
            }, 2);
        }
        catch (CoreException e) {
            SVNProviderPlugin.log(e.getStatus());
        }
    }

    protected void handleSVNDir(IContainer svnDir, int kind) {
        IFile entriesFile;
        if ((kind & 0x1F) != 0 && kind == 1 && (entriesFile = svnDir.getFile((IPath)new Path("wc.db"))).exists() && !svnDir.isTeamPrivateMember()) {
            try {
                svnDir.setTeamPrivateMember(true);
                if (Policy.DEBUG_METAFILE_CHANGES) {
                    System.out.println("[svn] found a new SVN meta folder, marking as team-private: " + svnDir.getFullPath());
                }
            }
            catch (CoreException e) {
                SVNProviderPlugin.log(SVNException.wrapException((IResource)svnDir, Policy.bind("SyncFileChangeListener.errorSettingTeamPrivateFlag"), e));
            }
        }
    }

    protected boolean isEntries(IResource resource) {
        if (resource.getType() != 1 || !resource.getName().equals("wc.db")) {
            return false;
        }
        IContainer parent = resource.getParent();
        return parent != null && SVNProviderPlugin.getPlugin().isAdminDirectory(parent.getName()) && (parent.isTeamPrivateMember() || !parent.exists());
    }

    protected IContainer handleChangedEntries(IResource resource, int kind) {
        IContainer changedContainer = resource.getParent();
        IContainer parent = changedContainer.getParent();
        if (parent != null && parent.exists()) {
            return changedContainer;
        }
        return null;
    }
}

