/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.plugin;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.eclipse.core.internal.runtime.XmlProcessorFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.plugin.IExtensions;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.ISharedPluginModel;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.plugin.PluginExtension;
import org.eclipse.pde.internal.core.plugin.PluginExtensionPoint;
import org.eclipse.pde.internal.core.plugin.PluginHandler;
import org.eclipse.pde.internal.core.plugin.PluginObject;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractExtensions
extends PluginObject
implements IExtensions {
    private static final long serialVersionUID = 1L;
    protected String fSchemaVersion;
    protected List<IPluginExtension> fExtensions = null;
    protected List<IPluginExtensionPoint> fExtensionPoints = null;
    boolean fCache = false;

    public AbstractExtensions(boolean readOnly) {
        this.fCache = !readOnly;
    }

    @Override
    public void add(IPluginExtension extension) throws CoreException {
        this.ensureModelEditable();
        this.getExtensionsList().add(extension);
        ((PluginExtension)extension).setInTheModel(true);
        ((PluginExtension)extension).setParent(this);
        this.fireStructureChanged(extension, 1);
    }

    @Override
    public void add(IPluginExtensionPoint extensionPoint) throws CoreException {
        this.ensureModelEditable();
        this.getExtensionPointsList().add(extensionPoint);
        ((PluginExtensionPoint)extensionPoint).setInTheModel(true);
        ((PluginExtensionPoint)extensionPoint).setParent(this);
        this.fireStructureChanged(extensionPoint, 1);
    }

    @Override
    public IPluginExtensionPoint[] getExtensionPoints() {
        List<IPluginExtensionPoint> extPoints = this.getExtensionPointsList();
        return extPoints.toArray(new IPluginExtensionPoint[extPoints.size()]);
    }

    @Override
    public IPluginExtension[] getExtensions() {
        List<IPluginExtension> extensions = this.getExtensionsList();
        return extensions.toArray(new IPluginExtension[extensions.size()]);
    }

    @Override
    public void restoreProperty(String name, Object oldValue, Object newValue) throws CoreException {
        if (name.equals("extension_order")) {
            this.swap((IPluginExtension)oldValue, (IPluginExtension)newValue);
            return;
        }
        super.restoreProperty(name, oldValue, newValue);
    }

    public void load(IExtensions srcExtensions) {
        IPluginExtensionPoint[] extensionPoints;
        IPluginExtension[] extensions;
        List<IPluginExtension> extensionsList = this.getExtensionsList();
        IPluginExtension[] iPluginExtensionArray = extensions = srcExtensions.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginExtension extension = iPluginExtensionArray[n2];
            if (extension != null) {
                extensionsList.add(extension);
            }
            ++n2;
        }
        List<IPluginExtensionPoint> extensionPointsList = this.getExtensionPointsList();
        IPluginExtensionPoint[] iPluginExtensionPointArray = extensionPoints = srcExtensions.getExtensionPoints();
        int n3 = extensionPoints.length;
        int n4 = 0;
        while (n4 < n3) {
            IPluginExtensionPoint extensionPoint = iPluginExtensionPointArray[n4];
            if (extensionPoint != null) {
                extensionPointsList.add(extensionPoint);
            }
            ++n4;
        }
    }

    @Override
    public void remove(IPluginExtension extension) throws CoreException {
        this.ensureModelEditable();
        this.getExtensionsList().remove(extension);
        ((PluginExtension)extension).setInTheModel(false);
        this.fireStructureChanged(extension, 2);
    }

    @Override
    public void remove(IPluginExtensionPoint extensionPoint) throws CoreException {
        this.ensureModelEditable();
        this.getExtensionPointsList().remove(extensionPoint);
        ((PluginExtensionPoint)extensionPoint).setInTheModel(false);
        this.fireStructureChanged(extensionPoint, 2);
    }

    public void reset() {
        this.resetExtensions();
    }

    public void resetExtensions() {
        this.fExtensions = null;
        this.fExtensionPoints = null;
    }

    public int getExtensionCount() {
        return this.getExtensionsList().size();
    }

    @Override
    public int getIndexOf(IPluginExtension e) {
        return this.getExtensionsList().indexOf(e);
    }

    @Override
    public void swap(IPluginExtension e1, IPluginExtension e2) throws CoreException {
        this.ensureModelEditable();
        List<IPluginExtension> extensions = this.getExtensionsList();
        int index1 = extensions.indexOf(e1);
        int index2 = extensions.indexOf(e2);
        if (index1 == -1 || index2 == -1) {
            this.throwCoreException(PDECoreMessages.AbstractExtensions_extensionsNotFoundException);
        }
        extensions.set(index2, e1);
        extensions.set(index1, e2);
        this.firePropertyChanged(this, "extension_order", e1, e2);
    }

    protected void writeChildren(String indent, String tag, Object[] children, PrintWriter writer) {
        writer.println(indent + "<" + tag + ">");
        Object[] objectArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            IPluginObject obj = (IPluginObject)element;
            obj.write(indent + "   ", writer);
            ++n2;
        }
        writer.println(indent + "</" + tag + ">");
    }

    protected boolean hasRequiredAttributes() {
        List<IPluginExtension> extensions = this.getExtensionsList();
        int size = extensions.size();
        int i = 0;
        while (i < size) {
            IPluginExtension extension = extensions.get(i);
            if (!extension.isValid()) {
                return false;
            }
            ++i;
        }
        List<IPluginExtensionPoint> extPoints = this.getExtensionPointsList();
        size = extPoints.size();
        int i2 = 0;
        while (i2 < size) {
            IPluginExtensionPoint expoint = extPoints.get(i2);
            if (!expoint.isValid()) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public String getSchemaVersion() {
        IResource res;
        IResource iResource;
        ISharedPluginModel model;
        if (this.fSchemaVersion == null && (model = this.getModel()) != null && (iResource = (res = model.getUnderlyingResource())) instanceof IFile) {
            IFile iFile = (IFile)iResource;
            IFile cfr_ignored_0 = (IFile)iResource;
            try {
                Throwable throwable = null;
                Object var7_7 = null;
                try {
                    void file;
                    try (BufferedInputStream stream = new BufferedInputStream(file.getContents(true));){
                        PluginHandler handler = new PluginHandler(true);
                        SAXParser parser = XmlProcessorFactory.createSAXParserWithErrorOnDOCTYPE();
                        parser.parse((InputStream)stream, (DefaultHandler)handler);
                        return handler.getSchemaVersion();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | ParserConfigurationException | CoreException | SAXException throwable) {}
        }
        return this.fSchemaVersion;
    }

    public void setSchemaVersion(String schemaVersion) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.fSchemaVersion;
        this.fSchemaVersion = schemaVersion;
        this.firePropertyChanged("schema-version", oldValue, schemaVersion);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List<IPluginExtension> getExtensionsList() {
        if (this.fExtensions != null) return this.fExtensions;
        IPluginBase base = this.getPluginBase();
        if (base == null) return Collections.emptyList();
        if (!this.fCache) return Arrays.asList(PDECore.getDefault().getExtensionsRegistry().findExtensionsForPlugin(base.getPluginModel()));
        this.fExtensions = new ArrayList<IPluginExtension>(Arrays.asList(PDECore.getDefault().getExtensionsRegistry().findExtensionsForPlugin(base.getPluginModel())));
        return this.fExtensions;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List<IPluginExtensionPoint> getExtensionPointsList() {
        if (this.fExtensionPoints != null) return this.fExtensionPoints;
        IPluginBase base = this.getPluginBase();
        if (base == null) return Collections.emptyList();
        if (!this.fCache) return Arrays.asList(PDECore.getDefault().getExtensionsRegistry().findExtensionPointsForPlugin(base.getPluginModel()));
        this.fExtensionPoints = new ArrayList<IPluginExtensionPoint>(Arrays.asList(PDECore.getDefault().getExtensionsRegistry().findExtensionPointsForPlugin(base.getPluginModel())));
        return this.fExtensionPoints;
    }

    protected void processChild(Node child) {
        String name = child.getNodeName();
        if (this.fExtensions == null) {
            this.fExtensions = new ArrayList<IPluginExtension>();
        }
        if (this.fExtensionPoints == null) {
            this.fExtensionPoints = new ArrayList<IPluginExtensionPoint>();
        }
        if (name.equals("extension")) {
            PluginExtension extension = new PluginExtension();
            extension.setModel(this.getModel());
            extension.setParent(this);
            this.fExtensions.add(extension);
            extension.setInTheModel(true);
            extension.load(child);
        } else if (name.equals("extension-point")) {
            PluginExtensionPoint point = new PluginExtensionPoint();
            point.setModel(this.getModel());
            point.setParent(this);
            point.setInTheModel(true);
            this.fExtensionPoints.add(point);
            point.load(child);
        }
    }
}

