/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.subversion.merge;

import com.collabnet.subversion.merge.Activator;
import com.collabnet.subversion.merge.AdaptableMergeResult;
import com.collabnet.subversion.merge.AdaptableMergeResultsFolder;
import com.collabnet.subversion.merge.MergeAdapterFactory;
import com.collabnet.subversion.merge.MergeOperation;
import com.collabnet.subversion.merge.MergeOptions;
import com.collabnet.subversion.merge.MergeResult;
import com.collabnet.subversion.merge.MergeResultsFolder;
import com.collabnet.subversion.merge.MergeSummaryResult;
import com.collabnet.subversion.merge.Messages;
import com.collabnet.subversion.merge.SkippedMergeResult;
import com.collabnet.subversion.merge.SkippedMergeResultsFolder;
import com.collabnet.subversion.merge.xml.DOMUtil;
import com.collabnet.subversion.merge.xml.MergeOutputDocument;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.tigris.subversion.subclipse.core.resources.LocalResourceStatus;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.svnclientadapter.SVNRevisionRange;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class MergeOutput
implements IPropertySource,
IAdaptable {
    private String target;
    private IResource resource;
    private MergeOptions mergeOptions;
    private String mergeCommand;
    private Date mergeDate;
    private String description;
    private String workspaceUrl;
    private long workspaceRevision;
    private MergeResult[] mergeResults;
    private MergeSummaryResult[] mergeSummaryResults;
    private MergeResult[] conflictedMergeResults;
    private MergeResult[] nonSkippedMergeResults;
    private MergeResultsFolder[] compressedFolders;
    private MergeResultsFolder[] conflictedCompressedFolders;
    private long lowerRevision;
    private long upperRevision;
    private boolean incomplete = false;
    private boolean normalEnd = false;
    private boolean abnormalEnd = false;
    private static boolean inProgress = false;
    private static final String LAST_TEXT_CONFLICT_CHOICE = "MergeWizardMainPage.lastTextConflictChoice";
    private static final String LAST_PROPERTY_CONFLICT_CHOICE = "MergeWizardMainPage.lastPropertyConflictChoice";
    private static final String LAST_BINARY_CONFLICT_CHOICE = "MergeWizardMainPage.lastBinaryConflictChoice";
    private static final String LAST_TREE_CONFLICT_CHOICE = "MergeWizardMainPage.lastTreeConflictChoice";
    public static final int EXPORT_FORMAT_DEFAULT = 0;
    public static String P_ID_DESCRIPTION = "desc";
    public static String P_DESCRIPTION = Messages.MergeOutput_description;
    public static String P_ID_DATE = "date";
    public static String P_DATE = Messages.MergeOutput_date;
    public static String P_ID_RESOURCE = "resource";
    public static String P_RESOURCE = Messages.MergeOutput_resource;
    public static String P_ID_COMMAND = "command";
    public static String P_COMMAND = Messages.MergeOutput_command;
    public static String P_ID_WORKSPACE_URL = "workspaceUrl";
    public static String P_WORKSPACE_URL = Messages.MergeOutput_url;
    public static String P_ID_WORKSPACE_REVISION = "workspaceRevision";
    public static String P_WORKSPACE_REVISION = Messages.MergeOutput_revision;
    public static List descriptors = new ArrayList();

    static {
        descriptors.add(new PropertyDescriptor((Object)P_ID_DESCRIPTION, P_DESCRIPTION));
        descriptors.add(new PropertyDescriptor((Object)P_ID_DATE, P_DATE));
        descriptors.add(new PropertyDescriptor((Object)P_ID_RESOURCE, P_RESOURCE));
        descriptors.add(new PropertyDescriptor((Object)P_ID_COMMAND, P_COMMAND));
        descriptors.add(new PropertyDescriptor((Object)P_ID_WORKSPACE_URL, P_WORKSPACE_URL));
        descriptors.add(new PropertyDescriptor((Object)P_ID_WORKSPACE_REVISION, P_WORKSPACE_REVISION));
    }

    public MergeOutput() {
    }

    public MergeOutput(String mergeCommand, Date mergeDate, MergeResult[] mergeResults) {
        this();
        this.mergeCommand = mergeCommand;
        this.mergeDate = mergeDate;
        this.mergeResults = mergeResults;
    }

    public void setMergeCommand(String mergeCommand) {
        this.mergeCommand = mergeCommand;
    }

    public void setMergeDate(Date mergeDate) {
        this.mergeDate = mergeDate;
    }

    public void setMergeResults(MergeResult[] mergeResults) {
        this.mergeResults = mergeResults;
    }

    public String getMergeCommand() {
        return this.mergeCommand;
    }

    public Date getMergeDate() {
        return this.mergeDate;
    }

    public MergeResult[] getConflictedMergeResults() {
        if (this.conflictedMergeResults == null) {
            ArrayList<MergeResult> conflictList = new ArrayList<MergeResult>();
            this.mergeResults = this.getNonSkippedMergeResults();
            int i = 0;
            while (i < this.mergeResults.length) {
                if (this.mergeResults[i].hasTreeConflict() || this.mergeResults[i].isConflicted() || this.mergeResults[i].isPropertyConflicted()) {
                    conflictList.add(this.mergeResults[i]);
                }
                ++i;
            }
            this.conflictedMergeResults = new MergeResult[conflictList.size()];
            conflictList.toArray(this.conflictedMergeResults);
        }
        return this.conflictedMergeResults;
    }

    public MergeResult[] getNonSkippedMergeResults() {
        if (this.nonSkippedMergeResults == null) {
            ArrayList<MergeResult> nonSkippedList = new ArrayList<MergeResult>();
            this.mergeResults = this.getMergeResults();
            int i = 0;
            while (i < this.mergeResults.length) {
                if (!this.mergeResults[i].isSkip()) {
                    nonSkippedList.add(this.mergeResults[i]);
                }
                ++i;
            }
            this.nonSkippedMergeResults = new MergeResult[nonSkippedList.size()];
            nonSkippedList.toArray(this.nonSkippedMergeResults);
        }
        return this.nonSkippedMergeResults;
    }

    public MergeResult[] getMergeResults() {
        if (this.mergeResults == null) {
            this.mergeResults = this.loadMergeResults();
        }
        return this.mergeResults;
    }

    public MergeResult[] getMergeResults(boolean conflictsOnly) {
        if (conflictsOnly) {
            return this.getConflictedMergeResults();
        }
        return this.getMergeResults();
    }

    public IResource getResource() {
        return this.resource;
    }

    public void setResource(IResource resource) {
        this.resource = resource;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MergeOutput) {
            MergeOutput compareTo = (MergeOutput)obj;
            if (compareTo.getResource() == null || compareTo.getResource().getFullPath() == null || this.resource == null || this.resource.getFullPath() == null || compareTo.getMergeDate() == null || this.mergeDate == null) {
                return false;
            }
            return compareTo.getResource().getFullPath().equals((Object)this.resource.getFullPath()) && compareTo.getMergeDate().getTime() == this.mergeDate.getTime();
        }
        return super.equals(obj);
    }

    public int hashCode() {
        if (this.resource == null) {
            return super.hashCode();
        }
        String hashString = String.valueOf(this.resource.getFullPath().toString()) + this.mergeDate.getTime();
        return hashString.hashCode();
    }

    public String toString() {
        if (this.resource == null) {
            return super.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.abnormalEnd) {
            stringBuffer.append(":abnormalEnd:" + System.getProperty("line.separator"));
        }
        if (this.normalEnd) {
            stringBuffer.append(":normalEnd:" + System.getProperty("line.separator"));
        }
        if (this.incomplete) {
            stringBuffer.append(":incomplete:" + System.getProperty("line.separator"));
        }
        if (this.description != null) {
            stringBuffer.append("description: " + this.description + System.getProperty("line.separator"));
        }
        if (this.resource.getType() == 4) {
            stringBuffer.append("project: " + this.resource.getFullPath().toOSString() + System.getProperty("line.separator"));
        } else if (this.resource.getType() == 2) {
            stringBuffer.append("folder: " + this.resource.getFullPath().toOSString() + System.getProperty("line.separator"));
        } else if (this.resource.getType() == 1) {
            stringBuffer.append("file: " + this.resource.getFullPath().toOSString() + System.getProperty("line.separator"));
        }
        if (this.mergeOptions != null) {
            int i;
            if (this.mergeOptions.getFromUrl() != null) {
                stringBuffer.append("fromUrl: " + this.mergeOptions.getFromUrl().toString() + System.getProperty("line.separator"));
            }
            if (this.mergeOptions.getFromRevision() != null) {
                stringBuffer.append("fromRevision: " + this.mergeOptions.getFromRevision() + System.getProperty("line.separator"));
            }
            if (this.mergeOptions.getToUrl() != null) {
                stringBuffer.append("toUrl: " + this.mergeOptions.getToUrl().toString() + System.getProperty("line.separator"));
            }
            if (this.mergeOptions.getToRevision() != null) {
                stringBuffer.append("toRevision: " + this.mergeOptions.getToRevision() + System.getProperty("line.separator"));
            }
            if (this.mergeOptions.getRevisions() != null) {
                stringBuffer.append("revisionRanges: ");
                SVNRevisionRange[] revisionRanges = this.mergeOptions.getRevisions();
                i = 0;
                while (i < revisionRanges.length) {
                    if (i > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(revisionRanges[i].toString());
                    ++i;
                }
                stringBuffer.append(System.getProperty("line.separator"));
            }
            stringBuffer.append("force: " + this.mergeOptions.isForce() + System.getProperty("line.separator"));
            stringBuffer.append("recurse: " + this.mergeOptions.isRecurse() + System.getProperty("line.separator"));
            stringBuffer.append("ignore: " + this.mergeOptions.isIgnoreAncestry() + System.getProperty("line.separator"));
            stringBuffer.append("depth: " + this.mergeOptions.getDepth() + System.getProperty("line.separator"));
            if (this.mergeOptions.getRevisions() != null && this.mergeOptions.getRevisions().length > 0) {
                stringBuffer.append("revisions: ");
                SVNRevisionRange[] revisions = this.mergeOptions.getRevisions();
                i = 0;
                while (i < revisions.length) {
                    if (i > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(revisions[i].toString());
                    ++i;
                }
                stringBuffer.append(System.getProperty("line.separator"));
            }
        }
        if (this.mergeSummaryResults != null) {
            int i = 0;
            while (i < this.mergeSummaryResults.length) {
                stringBuffer.append(this.mergeSummaryResults[i] + System.getProperty("line.separator"));
                ++i;
            }
            stringBuffer.append(System.getProperty("line.separator"));
        }
        if (this.workspaceUrl != null) {
            stringBuffer.append("workspaceUrl: " + this.workspaceUrl + System.getProperty("line.separator"));
        }
        stringBuffer.append("workspaceRevision: " + this.workspaceRevision + System.getProperty("line.separator"));
        stringBuffer.append("lowerRevision: " + this.lowerRevision + System.getProperty("line.separator"));
        stringBuffer.append("upperRevision: " + this.upperRevision + System.getProperty("line.separator"));
        stringBuffer.append(this.mergeCommand);
        if (this.mergeResults != null) {
            int i = 0;
            while (i < this.mergeResults.length) {
                stringBuffer.append(String.valueOf(System.getProperty("line.separator")) + this.mergeResults[i]);
                ++i;
            }
        }
        return stringBuffer.toString();
    }

    public String export(int format) {
        MergeOutputDocument document = new MergeOutputDocument(this);
        return DOMUtil.toString(document.getDocument().getDocumentElement());
    }

    public boolean store() {
        boolean error;
        block16: {
            error = false;
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.mergeDate);
            File mergeOutputFile = new File(String.valueOf(Activator.getMergeResultsLocation()) + File.separator + "m" + calendar.getTimeInMillis());
            Writer output = null;
            try {
                try {
                    File mergeOutputDirectory = new File(Activator.getMergeResultsLocation());
                    if (!mergeOutputDirectory.exists()) {
                        mergeOutputDirectory.mkdirs();
                    }
                    if (!mergeOutputFile.exists()) {
                        mergeOutputFile.createNewFile();
                    }
                    output = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(mergeOutputFile), "UTF8"));
                    output.write(this.toString());
                }
                catch (IOException e) {
                    Activator.handleError(e);
                    error = true;
                    try {
                        if (output != null) {
                            output.close();
                        }
                        break block16;
                    }
                    catch (Exception e2) {
                        Activator.handleError(e2);
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (Exception e) {
                    Activator.handleError(e);
                }
                throw throwable;
            }
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (Exception e) {
                Activator.handleError(e);
            }
        }
        return !error;
    }

    public boolean delete() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.mergeDate);
        File mergeOutputFile = new File(String.valueOf(Activator.getMergeResultsLocation()) + File.separator + "m" + calendar.getTimeInMillis());
        return mergeOutputFile.delete();
    }

    public void resume() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IResource[] resources = new IResource[]{this.resource};
        SVNUrl[] fromUrls = new SVNUrl[]{this.mergeOptions.getFromUrl()};
        SVNUrl[] toUrls = new SVNUrl[]{this.mergeOptions.getToUrl()};
        MergeOperation mergeOperation = new MergeOperation(SVNUIPlugin.getActivePage().getActivePart(), resources, fromUrls, this.mergeOptions.getFromRevision(), toUrls, this.mergeOptions.getToRevision(), this.mergeOptions.getRevisions(), this);
        mergeOperation.setForce(this.mergeOptions.isForce());
        mergeOperation.setIgnoreAncestry(this.mergeOptions.isIgnoreAncestry());
        mergeOperation.setDepth(this.mergeOptions.getDepth());
        int lastTextConflictChoice = 6;
        try {
            lastTextConflictChoice = settings.getInt(LAST_TEXT_CONFLICT_CHOICE);
        }
        catch (Exception exception) {}
        int lastPropertyConflictChoice = lastTextConflictChoice;
        try {
            lastPropertyConflictChoice = settings.getInt(LAST_PROPERTY_CONFLICT_CHOICE);
        }
        catch (Exception exception) {}
        int lastBinaryConflictChoice = 6;
        try {
            lastBinaryConflictChoice = settings.getInt(LAST_BINARY_CONFLICT_CHOICE);
        }
        catch (Exception exception) {}
        int lastTreeConflictChoice = 0;
        try {
            lastTreeConflictChoice = settings.getInt(LAST_TREE_CONFLICT_CHOICE);
        }
        catch (Exception exception) {}
        mergeOperation.setTextConflictHandling(lastTextConflictChoice);
        mergeOperation.setBinaryConflictHandling(lastBinaryConflictChoice);
        mergeOperation.setPropertyConflictHandling(lastPropertyConflictChoice);
        mergeOperation.setTreeConflictHandling(lastTreeConflictChoice);
        try {
            mergeOperation.run();
        }
        catch (Exception e) {
            Activator.handleError(Messages.MergeOutput_resumeError, e);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.MergeOutput_resume, (String)e.getMessage());
        }
    }

    private MergeResult[] loadMergeResults() {
        ArrayList<MergeResult> results;
        block21: {
            results = new ArrayList<MergeResult>();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.mergeDate);
            File mergeOutputFile = new File(String.valueOf(Activator.getMergeResultsLocation()) + File.separator + "m" + calendar.getTimeInMillis());
            BufferedReader input = null;
            try {
                try {
                    input = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(mergeOutputFile), "UTF8"));
                    String line = null;
                    while ((line = input.readLine()) != null) {
                        if (!line.startsWith("Message: ") && !line.startsWith("Error:   ")) continue;
                        if (line.length() < 24) {
                            Activator.handleError(new Exception("Unexpected error while loading merge results from " + mergeOutputFile.getName() + ".  line: " + line));
                            continue;
                        }
                        String action = null;
                        String propertyAction = null;
                        String treeConflictAction = null;
                        String conflictResolution = null;
                        String propertyResolution = null;
                        String treeConflictResolution = null;
                        String path = null;
                        int type = 1;
                        boolean error = line.startsWith("Error: ");
                        type = Integer.parseInt(line.substring(9, 10));
                        action = line.substring(11, 12);
                        propertyAction = line.substring(13, 14);
                        conflictResolution = line.substring(15, 16);
                        propertyResolution = line.substring(17, 18);
                        treeConflictAction = line.substring(19, 20);
                        treeConflictResolution = line.substring(21, 22);
                        path = line.substring(23);
                        MergeResult result = null;
                        result = action.equals("S") ? new SkippedMergeResult(action, propertyAction, treeConflictAction, path, error) : new AdaptableMergeResult(action, propertyAction, treeConflictAction, path, error);
                        result.setType(type);
                        result.setMergeOutput(this);
                        IResource resource = null;
                        resource = this.resource.getLocation().toString().equals(path) ? this.resource : SVNWorkspaceRoot.getResourceFor((IResource)this.resource, (IPath)new Path(path));
                        result.setResource(resource);
                        if (error) {
                            result.setConflictResolution(conflictResolution);
                            result.setPropertyResolution(propertyResolution);
                            result.setTreeConflictResolution(treeConflictResolution);
                            if (resource != null && !inProgress) {
                                LocalResourceStatus status = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource).getStatus();
                                if (conflictResolution.trim().length() == 0 && !status.isTextConflicted()) {
                                    result.setConflictResolution("X");
                                }
                                if (propertyResolution.trim().length() == 0 && !status.isPropConflicted()) {
                                    result.setPropertyResolution("X");
                                }
                                if (treeConflictResolution.trim().length() == 0 && !status.hasTreeConflict()) {
                                    result.setTreeConflictResolution("X");
                                }
                            }
                        }
                        results.add(result);
                    }
                }
                catch (Exception e) {
                    Activator.handleError(e);
                    try {
                        if (input != null) {
                            input.close();
                        }
                        break block21;
                    }
                    catch (IOException e2) {
                        Activator.handleError(e2);
                    }
                    break block21;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (IOException e) {
                    Activator.handleError(e);
                }
                throw throwable;
            }
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e) {
                Activator.handleError(e);
            }
        }
        Object[] mergeResultArray = new MergeResult[results.size()];
        results.toArray(mergeResultArray);
        Arrays.sort(mergeResultArray);
        return mergeResultArray;
    }

    public static MergeOutput getIncompleteMerge(IResource resource, String fromUrl, String toUrl) {
        MergeOutput[] mergeOutputs = MergeOutput.getMergeOutputs();
        int i = 0;
        while (i < mergeOutputs.length) {
            if (mergeOutputs[i].isIncomplete() && mergeOutputs[i].getResource().getFullPath().equals((Object)resource.getFullPath()) && mergeOutputs[i].getMergeOptions().getFromUrl().toString().equals(fromUrl) && mergeOutputs[i].getMergeOptions().getToUrl().toString().equals(toUrl)) {
                return mergeOutputs[i];
            }
            ++i;
        }
        return null;
    }

    public static MergeOutput[] getMergeOutputs() {
        Calendar calendar = Calendar.getInstance();
        File mergeOutputDirectory = new File(Activator.getMergeResultsLocation());
        if (!mergeOutputDirectory.exists()) {
            mergeOutputDirectory.mkdirs();
        }
        File[] mergeOutputs = mergeOutputDirectory.listFiles();
        ArrayList<MergeOutput> mergeOutputList = new ArrayList<MergeOutput>();
        int i = 0;
        while (i < mergeOutputs.length) {
            block44: {
                MergeOutput mergeOutput = new MergeOutput();
                ArrayList<MergeSummaryResult> mergeSummaryResults = new ArrayList<MergeSummaryResult>();
                boolean goodMergeResultsFile = mergeOutputs[i].getName().startsWith("m");
                if (goodMergeResultsFile) {
                    try {
                        calendar.setTimeInMillis(Long.parseLong(mergeOutputs[i].getName().substring(1)));
                    }
                    catch (Exception exception) {
                        goodMergeResultsFile = false;
                    }
                }
                if (goodMergeResultsFile) {
                    mergeOutput.setMergeDate(calendar.getTime());
                    BufferedReader input = null;
                    try {
                        try {
                            input = new BufferedReader(new FileReader(mergeOutputs[i]));
                            String line = null;
                            MergeOptions mergeOptions = new MergeOptions();
                            while ((line = input.readLine()) != null) {
                                if (line.startsWith(":abnormalEnd:")) {
                                    mergeOutput.setAbnormalEnd(true);
                                }
                                if (line.startsWith(":normalEnd:")) {
                                    mergeOutput.setNormalEnd(true);
                                }
                                if (line.startsWith(":incomplete:")) {
                                    mergeOutput.setIncomplete(true);
                                }
                                if (line.startsWith("description: ")) {
                                    mergeOutput.setDescription(line.substring(13));
                                }
                                if (line.startsWith("project: ")) {
                                    mergeOutput.setResource((IResource)ResourcesPlugin.getWorkspace().getRoot().getProject(line.substring(10)));
                                    mergeOutput.setTarget(line.substring(10));
                                }
                                if (line.startsWith("folder: ")) {
                                    mergeOutput.setResource((IResource)ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(line.substring(8))));
                                    mergeOutput.setTarget(line.substring(8));
                                }
                                if (line.startsWith(Messages.MergeOutput_57)) {
                                    mergeOutput.setResource((IResource)ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(line.substring(6))));
                                    mergeOutput.setTarget(line.substring(6));
                                }
                                if (line.startsWith("fromUrl: ")) {
                                    mergeOptions.setFromUrl(line.substring(9));
                                }
                                if (line.startsWith("toUrl: ")) {
                                    mergeOptions.setToUrl(line.substring(7));
                                }
                                if (line.startsWith("fromRevision: ")) {
                                    mergeOptions.setFromRevision(line.substring(14));
                                }
                                if (line.startsWith("toRevision: ")) {
                                    mergeOptions.setToRevision(line.substring(12));
                                }
                                if (line.startsWith("force: ")) {
                                    mergeOptions.setForce(line.substring(7).equals("true"));
                                }
                                if (line.startsWith("recurse: ")) {
                                    mergeOptions.setRecurse(line.substring(9).equals("true"));
                                }
                                if (line.startsWith("ignore: ")) {
                                    mergeOptions.setIgnoreAncestry(line.substring(8).equals("true"));
                                }
                                if (line.startsWith("depth: ")) {
                                    String depthString = line.substring(7);
                                    int depth = Integer.parseInt(depthString.trim());
                                    mergeOptions.setDepth(depth);
                                }
                                if (line.startsWith("revisionRanges: ")) {
                                    mergeOptions.setRevisions(line.substring(16));
                                }
                                if (line.startsWith("lowerRevision: ")) {
                                    mergeOutput.setLowerRevision(Long.parseLong(line.substring(15)));
                                }
                                if (line.startsWith("upperRevision: ")) {
                                    mergeOutput.setUpperRevision(Long.parseLong(line.substring(15)));
                                }
                                if (line.startsWith("workspaceUrl: ")) {
                                    mergeOutput.setWorkspaceUrl(line.substring(14));
                                }
                                if (line.startsWith("workspaceRevision: ")) {
                                    mergeOutput.setWorkspaceRevision(Long.parseLong(line.substring(19)));
                                }
                                if (line.startsWith("Summary result: ")) {
                                    mergeSummaryResults.add(new MergeSummaryResult(line));
                                }
                                if (line.startsWith("merge ")) {
                                    mergeOutput.setMergeCommand(line);
                                    break;
                                }
                                mergeOutput.setMergeOptions(mergeOptions);
                            }
                            MergeSummaryResult[] mergeSummaryResultArray = new MergeSummaryResult[mergeSummaryResults.size()];
                            mergeSummaryResults.toArray(mergeSummaryResultArray);
                            mergeOutput.setMergeSummaryResults(mergeSummaryResultArray);
                            if (mergeOutput.getResource() != null) {
                                mergeOutputList.add(mergeOutput);
                            }
                        }
                        catch (Exception e) {
                            Activator.handleError(e);
                            try {
                                if (input != null) {
                                    input.close();
                                }
                                break block44;
                            }
                            catch (IOException e2) {
                                Activator.handleError(e2);
                            }
                            break block44;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            if (input != null) {
                                input.close();
                            }
                        }
                        catch (IOException e) {
                            Activator.handleError(e);
                        }
                        throw throwable;
                    }
                    try {
                        if (input != null) {
                            input.close();
                        }
                    }
                    catch (IOException e) {
                        Activator.handleError(e);
                    }
                }
            }
            ++i;
        }
        MergeOutput[] mergeOutputArray = new MergeOutput[mergeOutputList.size()];
        mergeOutputList.toArray(mergeOutputArray);
        return mergeOutputArray;
    }

    public Object getEditableValue() {
        if (this.description == null) {
            return this.resource.getName();
        }
        return this.description.toString();
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return MergeOutput.getDescriptors().toArray(new IPropertyDescriptor[MergeOutput.getDescriptors().size()]);
    }

    private static List getDescriptors() {
        return descriptors;
    }

    public Object getPropertyValue(Object propKey) {
        if (P_ID_DESCRIPTION.equals(propKey)) {
            if (this.description == null) {
                return "";
            }
            return this.description;
        }
        if (P_ID_DATE.equals(propKey)) {
            return this.mergeDate.toString();
        }
        if (P_ID_RESOURCE.equals(propKey)) {
            return this.resource.getFullPath().makeRelative().toOSString();
        }
        if (P_ID_COMMAND.equals(propKey)) {
            return this.mergeCommand;
        }
        if (P_ID_WORKSPACE_URL.equals(propKey)) {
            if (this.workspaceUrl == null) {
                return "";
            }
            return this.workspaceUrl;
        }
        if (P_ID_WORKSPACE_REVISION.equals(propKey)) {
            if (this.workspaceRevision > 0L) {
                return Long.toString(this.workspaceRevision);
            }
            return "";
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public MergeOptions getMergeOptions() {
        return this.mergeOptions;
    }

    public void setMergeOptions(MergeOptions mergeOptions) {
        this.mergeOptions = mergeOptions;
    }

    public MergeSummaryResult[] getMergeSummaryResults() {
        return this.mergeSummaryResults;
    }

    public void setMergeSummaryResults(MergeSummaryResult[] mergeSummaryResults) {
        this.mergeSummaryResults = mergeSummaryResults;
    }

    public boolean hasUnresolvedConflicts() {
        MergeResult[] conflicts = this.getMergeResults(true);
        int i = 0;
        while (i < conflicts.length) {
            if (conflicts[i].hasTreeConflict() && !conflicts[i].isTreeConflictResolved() || conflicts[i].isConflicted() && !conflicts[i].isResolved() || conflicts[i].isPropertyConflicted() && !conflicts[i].isPropertyResolved()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public MergeResult[] getRootMergeResults(boolean conflictsOnly) {
        ArrayList<MergeResult> rootMergeResults = new ArrayList<MergeResult>();
        MergeResult[] mergeResults = conflictsOnly ? this.getConflictedMergeResults() : this.getMergeResults();
        int i = 0;
        while (i < mergeResults.length) {
            IContainer parent;
            MergeResult mergeResult = mergeResults[i];
            IResource resource = mergeResult.getResource();
            if (resource instanceof IFile && (parent = resource.getParent()) != null && parent.getFullPath().toString().equals(this.resource.getFullPath().toString())) {
                rootMergeResults.add(mergeResult);
            }
            ++i;
        }
        MergeResult[] resultArray = new MergeResult[rootMergeResults.size()];
        rootMergeResults.toArray(resultArray);
        return resultArray;
    }

    public MergeResultsFolder[] getCompressedFolders(boolean conflictsOnly) {
        if (conflictsOnly) {
            return this.getConflictedCompressedFolders();
        }
        return this.getCompressedFolders();
    }

    public MergeResultsFolder[] getCompressedFolders() {
        if (this.compressedFolders == null) {
            HashMap<IResource, MergeResult> map = new HashMap<IResource, MergeResult>();
            ArrayList<Object> folderList = new ArrayList<Object>();
            this.mergeResults = this.getMergeResults();
            int i = 0;
            while (i < this.mergeResults.length) {
                IContainer parent;
                IResource resource = this.mergeResults[i].getResource();
                if (resource instanceof IContainer && !folderList.contains(resource)) {
                    folderList.add(resource);
                    map.put(resource, this.mergeResults[i]);
                }
                if (!(resource instanceof IContainer || (parent = resource.getParent()) == null || parent instanceof IWorkspaceRoot || folderList.contains(parent))) {
                    folderList.add(parent);
                }
                ++i;
            }
            IContainer[] folders = new IContainer[folderList.size()];
            folderList.toArray(folders);
            this.compressedFolders = new MergeResultsFolder[folders.length];
            int i2 = 0;
            while (i2 < folders.length) {
                MergeResult mergeResult = (MergeResult)map.get(folders[i2]);
                MergeResultsFolder folder = null;
                folder = mergeResult != null && mergeResult.getAction().equals("S") ? new SkippedMergeResultsFolder() : new AdaptableMergeResultsFolder();
                folder.setFolder(folders[i2]);
                folder.setCompressed(true);
                folder.setRootFolderLength(this.resource.getFullPath().makeRelative().toOSString().length());
                folder.setMergeOutput(this);
                folder.setMergeResult(mergeResult);
                this.compressedFolders[i2] = folder;
                ++i2;
            }
        }
        return this.compressedFolders;
    }

    public MergeResultsFolder[] getConflictedCompressedFolders() {
        if (this.conflictedCompressedFolders == null) {
            HashMap<IResource, MergeResult> map = new HashMap<IResource, MergeResult>();
            ArrayList<Object> folderList = new ArrayList<Object>();
            this.conflictedMergeResults = this.getConflictedMergeResults();
            int i = 0;
            while (i < this.conflictedMergeResults.length) {
                IContainer parent;
                IResource resource = this.conflictedMergeResults[i].getResource();
                if (resource instanceof IContainer && !folderList.contains(resource)) {
                    folderList.add(resource);
                    map.put(resource, this.conflictedMergeResults[i]);
                }
                if (!(resource instanceof IContainer || (parent = resource.getParent()) == null || folderList.contains(parent) || parent.getFullPath().toString().equals(this.resource.getFullPath().toString()))) {
                    folderList.add(parent);
                }
                ++i;
            }
            IContainer[] folders = new IContainer[folderList.size()];
            folderList.toArray(folders);
            this.conflictedCompressedFolders = new MergeResultsFolder[folders.length];
            int i2 = 0;
            while (i2 < folders.length) {
                MergeResult mergeResult = (MergeResult)map.get(folders[i2]);
                MergeResultsFolder folder = null;
                folder = mergeResult != null && mergeResult.getAction().equals("S") ? new SkippedMergeResultsFolder() : new AdaptableMergeResultsFolder();
                folder.setFolder(folders[i2]);
                folder.setCompressed(true);
                folder.setRootFolderLength(this.resource.getFullPath().makeRelative().toOSString().length());
                folder.setMergeOutput(this);
                folder.setMergeResult(mergeResult);
                this.conflictedCompressedFolders[i2] = folder;
                ++i2;
            }
        }
        return this.conflictedCompressedFolders;
    }

    public Object getAdapter(Class adapter) {
        Object object = new MergeAdapterFactory().getAdapter(this, adapter);
        return object;
    }

    public static void setInProgress(boolean inProgress) {
        MergeOutput.inProgress = inProgress;
    }

    public boolean isIncomplete() {
        return this.incomplete;
    }

    public void setIncomplete(boolean incomplete) {
        this.incomplete = incomplete;
    }

    public boolean isNormalEnd() {
        return this.normalEnd;
    }

    public void setNormalEnd(boolean normalEnd) {
        this.normalEnd = normalEnd;
    }

    public boolean isAbnormalEnd() {
        return this.abnormalEnd;
    }

    public void setAbnormalEnd(boolean abnormalEnd) {
        this.abnormalEnd = abnormalEnd;
    }

    public boolean isInProgress() {
        return !this.abnormalEnd && !this.normalEnd;
    }

    public void setLowerRevision(long lowerRevision) {
        this.lowerRevision = lowerRevision;
    }

    public void setUpperRevision(long upperRevision) {
        this.upperRevision = upperRevision;
    }

    public long getLowerRevision() {
        return this.lowerRevision;
    }

    public long getUpperRevision() {
        return this.upperRevision;
    }

    public String getWorkspaceUrl() {
        return this.workspaceUrl;
    }

    public void setWorkspaceUrl(String workspaceUrl) {
        this.workspaceUrl = workspaceUrl;
    }

    public long getWorkspaceRevision() {
        return this.workspaceRevision;
    }

    public void setWorkspaceRevision(long workspaceRevision) {
        this.workspaceRevision = workspaceRevision;
    }
}

