/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.subversion.merge;

import com.collabnet.subversion.merge.Activator;
import com.collabnet.subversion.merge.IMergeInputProvider;
import com.collabnet.subversion.merge.MergeOperation;
import com.collabnet.subversion.merge.Messages;
import com.collabnet.subversion.merge.wizards.MergeWizardLastPage;
import com.collabnet.subversion.merge.wizards.MergeWizardMainPage;
import com.collabnet.subversion.merge.wizards.MergeWizardRevisionsPage;
import com.collabnet.subversion.merge.wizards.MergeWizardStandardPage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.tigris.subversion.subclipse.core.history.ILogEntry;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.comments.CommentsManager;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNRevisionRange;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class StandardMergeInputProvider
implements IMergeInputProvider {
    private String text;
    private String description;
    private int sequence;
    private Image image;
    private MergeWizardStandardPage standardPage;
    private MergeWizardRevisionsPage revisionsPage;
    private WizardPage[] wizardPages;

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public int getSequence() {
        return this.sequence;
    }

    @Override
    public IWizardPage[] getWizardPages(boolean initializePages) {
        if (this.wizardPages == null || initializePages) {
            this.standardPage = new MergeWizardStandardPage("standard", Messages.StandardMergeInputProvider_selectMergeSource, Activator.getDefault().getImageDescriptor("mergestream_wizban.png"));
            this.revisionsPage = new MergeWizardRevisionsPage("revisions", Messages.StandardMergeInputProvider_selectRevisions, Activator.getDefault().getImageDescriptor("mergestream_wizban.png"), this.standardPage);
            WizardPage[] pages = new WizardPage[]{this.standardPage, this.revisionsPage};
            this.wizardPages = pages;
        }
        return this.wizardPages;
    }

    @Override
    public IWizardPage getNextPage(IWizardPage currentPage) {
        if (currentPage == this.standardPage && this.standardPage.selectRevisions()) {
            return this.revisionsPage;
        }
        return null;
    }

    @Override
    public boolean performMerge(MergeWizardMainPage mainPage, MergeWizardLastPage optionsPage, IWorkbenchPart targetPart) {
        String commonRoot = this.standardPage.getCommonRoot(false);
        String mergeFrom = this.standardPage.getMergeFrom();
        Activator.getDefault().saveMergeSource(mergeFrom, commonRoot);
        IResource[] resources = this.standardPage.getResources();
        SVNUrl[] urls = this.standardPage.getUrls();
        SVNRevisionRange[] revisions = null;
        if (this.standardPage.selectRevisions()) {
            HashSet<IResource> usedResources = new HashSet<IResource>();
            Map<SVNRevision.Number, List<IResource>> map = this.revisionsPage.getRevisionToResource();
            revisions = this.revisionsPage.getRevisions();
            CommentsManager commentsManager = SVNUIPlugin.getPlugin().getRepositoryManager().getCommentsManager();
            ILogEntry[] entries = this.revisionsPage.getSelectedLogEntries();
            int i = 0;
            while (i < entries.length) {
                commentsManager.addComment(entries[i].getComment());
                if (map.size() > 0) {
                    List<IResource> lst = map.get(entries[i].getRevision());
                    usedResources.addAll(lst);
                }
                ++i;
            }
            if (usedResources.size() > 0) {
                ArrayList<SVNUrl> urlsList = new ArrayList<SVNUrl>();
                ArrayList<IResource> resourcesList = new ArrayList<IResource>();
                int i2 = 0;
                while (i2 < resources.length) {
                    if (usedResources.contains(resources[i2])) {
                        urlsList.add(urls[i2]);
                        resourcesList.add(resources[i2]);
                    }
                    ++i2;
                }
                resources = resourcesList.toArray(new IResource[resourcesList.size()]);
                urls = urlsList.toArray(new SVNUrl[urlsList.size()]);
            }
        }
        MergeOperation mergeOperation = new MergeOperation(targetPart, resources, urls, null, urls, null, revisions, null);
        mergeOperation.setForce(optionsPage.isForce());
        mergeOperation.setIgnoreAncestry(optionsPage.isIgnore());
        mergeOperation.setDepth(optionsPage.getDepth());
        mergeOperation.setTextConflictHandling(optionsPage.getTextConflictHandling());
        mergeOperation.setBinaryConflictHandling(optionsPage.getBinaryConflictHandling());
        mergeOperation.setPropertyConflictHandling(optionsPage.getPropertyConflictHandling());
        mergeOperation.setTreeConflictHandling(optionsPage.getTreeConflictHandling());
        try {
            mergeOperation.run();
        }
        catch (Exception e) {
            Activator.handleError(Messages.StandardMergeInputProvider_error, e);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.StandardMergeInputProvider_merge, (String)e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public void setText(String text) {
        this.text = text;
    }

    public int compareTo(Object compareToObject) {
        if (!(compareToObject instanceof IMergeInputProvider)) {
            return 0;
        }
        IMergeInputProvider compareToInputProvider = (IMergeInputProvider)compareToObject;
        if (this.getSequence() > compareToInputProvider.getSequence()) {
            return 1;
        }
        if (compareToInputProvider.getSequence() > this.getSequence()) {
            return -1;
        }
        return this.getText().compareTo(compareToInputProvider.getText());
    }

    @Override
    public boolean enabledForMultipleSelection() {
        return true;
    }

    @Override
    public boolean showOptionsPage() {
        return true;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean hideDepth() {
        return false;
    }

    @Override
    public boolean hideForce() {
        return false;
    }

    @Override
    public boolean hideIgnoreAncestry() {
        return false;
    }

    @Override
    public Image getImage() {
        return this.image;
    }

    @Override
    public void setImage(Image image) {
        this.image = image;
    }

    @Override
    public void setSequence(int sequence) {
        this.sequence = sequence;
    }

    @Override
    public boolean showBestPracticesPage() {
        return true;
    }
}

