/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.subversion.merge.dialogs;

import com.collabnet.subversion.merge.Messages;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.TreeSet;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.history.ILogEntry;
import org.tigris.subversion.subclipse.ui.dialogs.DateSelectionDialog;
import org.tigris.subversion.subclipse.ui.dialogs.HistoryDialog;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class FilterRevisionsDialog
extends TrayDialog {
    private ISVNRemoteResource remoteResource;
    private Combo authors;
    private Text commentText;
    private Text startDateText;
    private Text endDateText;
    private Button regExpButton;
    private Text startRevisionText;
    private Button startLogButton;
    private Text endRevisionText;
    private Button endLogButton;
    private TreeSet<String> allAuthorSet;
    private Button clearButton;
    private String selectedAuthor;
    private String comment;
    private Date startDate;
    private Date endDate;
    private SVNRevision.Number startRevision;
    private SVNRevision.Number endRevision;
    private boolean regExp;
    private static final String ALL_AUTHORS = Messages.FilterRevisionsDialog_0;

    public FilterRevisionsDialog(Shell shell) {
        super(shell);
    }

    public FilterRevisionsDialog(Shell shell, TreeSet<String> allAuthorsSet) {
        super(shell);
        this.allAuthorSet = allAuthorsSet;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.FilterRevisionsDialog_filter);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        Composite top = new Composite(composite, 0);
        GridLayout topLayout = new GridLayout();
        top.setLayout((Layout)topLayout);
        top.setLayoutData((Object)new GridData(768));
        this.regExpButton = new Button(top, 32);
        this.regExpButton.setText(Messages.FilterRevisionsDialog_regExp);
        GridData gdRegExpButton = new GridData(768);
        this.regExpButton.setLayoutData((Object)gdRegExpButton);
        this.regExpButton.setSelection(this.regExp);
        Group search = new Group(composite, 0);
        search.setText(Messages.FilterRevisionsDialog_searchTitle);
        GridLayout searchLayout = new GridLayout();
        searchLayout.numColumns = 2;
        search.setLayout((Layout)searchLayout);
        search.setLayoutData((Object)new GridData(1808));
        Label userLabel = new Label((Composite)search, 0);
        userLabel.setText(Messages.FilterRevisionsDialog_user);
        this.authors = new Combo((Composite)search, 2056);
        this.authors.setLayoutData((Object)new GridData(768));
        if (this.allAuthorSet != null && this.allAuthorSet.size() > 0) {
            this.authors.setItems(this.allAuthorSet.toArray(new String[0]));
            if (this.selectedAuthor != null && this.allAuthorSet.contains(this.selectedAuthor)) {
                this.authors.setText(this.selectedAuthor);
            } else {
                this.authors.setText(ALL_AUTHORS);
            }
            if (this.allAuthorSet.size() == 1) {
                Iterator<String> it = this.allAuthorSet.iterator();
                String firstElement = null;
                if (it.hasNext()) {
                    firstElement = it.next();
                }
                this.authors.setText(firstElement);
                this.authors.setEnabled(false);
            }
        }
        Label commentLabel = new Label((Composite)search, 0);
        commentLabel.setText(Messages.FilterRevisionsDialog_comment);
        this.commentText = new Text((Composite)search, 2048);
        this.commentText.setLayoutData((Object)new GridData(768));
        if (this.comment != null) {
            this.commentText.setText(this.comment);
        }
        Label dateLabel = new Label((Composite)search, 0);
        dateLabel.setText(Messages.FilterRevisionsDialog_date);
        Composite dateComp = new Composite((Composite)search, 0);
        GridLayout dateCompLayout = new GridLayout();
        dateCompLayout.numColumns = 5;
        dateCompLayout.marginHeight = 0;
        dateCompLayout.marginWidth = 0;
        dateComp.setLayout((Layout)dateCompLayout);
        dateComp.setLayoutData((Object)new GridData(768));
        this.startDateText = new Text(dateComp, 2048);
        this.startDateText.setLayoutData((Object)new GridData(768));
        if (this.startDate != null) {
            this.startDateText.setText(this.formatDate(this.startDate));
            this.startDateText.setData((Object)this.startDate);
        }
        Button selectStartDateButton = new Button(dateComp, 0);
        selectStartDateButton.setText(Messages.FilterRevisionsDialog_startDateButton);
        Label midDataLabel = new Label(dateComp, 0);
        midDataLabel.setText(Messages.FilterRevisionsDialog_midDate);
        this.endDateText = new Text(dateComp, 2048);
        this.endDateText.setLayoutData((Object)new GridData(768));
        if (this.endDate != null) {
            this.endDateText.setText(this.formatDate(this.endDate));
            this.endDateText.setData((Object)this.endDate);
        }
        Button selectEndDateButton = new Button(dateComp, 0);
        selectEndDateButton.setText(Messages.FilterRevisionsDialog_endDateButton);
        Label revisionLabel = new Label((Composite)search, 0);
        revisionLabel.setText(Messages.FilterRevisionsDialog_revision);
        Composite revisionComp = new Composite((Composite)search, 0);
        GridLayout revisionCompLayout = new GridLayout();
        revisionCompLayout.numColumns = 5;
        revisionCompLayout.marginHeight = 0;
        revisionCompLayout.marginWidth = 0;
        revisionComp.setLayout((Layout)revisionCompLayout);
        revisionComp.setLayoutData((Object)new GridData(768));
        this.startRevisionText = new Text(revisionComp, 2048);
        this.startRevisionText.setLayoutData((Object)new GridData(768));
        if (this.startRevision != null) {
            this.startRevisionText.setText(this.startRevision.toString());
        }
        this.startLogButton = new Button(revisionComp, 8);
        this.startLogButton.setText(Messages.FilterRevisionsDialog_startRevisionButton);
        Label endRevisionLabel = new Label(revisionComp, 0);
        endRevisionLabel.setText(Messages.FilterRevisionsDialog_endRevision);
        this.endRevisionText = new Text(revisionComp, 2048);
        this.endRevisionText.setLayoutData((Object)new GridData(768));
        if (this.endRevision != null) {
            this.endRevisionText.setText(this.endRevision.toString());
        }
        this.endLogButton = new Button(revisionComp, 8);
        this.endLogButton.setText(Messages.FilterRevisionsDialog_endRevisionButton);
        selectStartDateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String start = null;
                if (FilterRevisionsDialog.this.startDateText.getText().trim().length() == 0) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.add(2, -1);
                    Date date = calendar.getTime();
                    start = FilterRevisionsDialog.this.formatDate(date);
                } else {
                    start = FilterRevisionsDialog.this.startDateText.getText();
                    if (FilterRevisionsDialog.this.parseDate(start) == null) {
                        return;
                    }
                }
                DateSelectionDialog dsd = new DateSelectionDialog(FilterRevisionsDialog.this.getShell(), start);
                if (dsd.open() == 0) {
                    Date endDate;
                    Date startDate = dsd.getDate();
                    FilterRevisionsDialog.this.startDateText.setText(FilterRevisionsDialog.this.formatDate(startDate));
                    FilterRevisionsDialog.this.startDateText.setData((Object)startDate);
                    if (FilterRevisionsDialog.this.endDateText.getText().trim().length() > 0 && !startDate.before(endDate = (Date)FilterRevisionsDialog.this.endDateText.getData())) {
                        FilterRevisionsDialog.this.endDateText.setText(FilterRevisionsDialog.this.formatDate(startDate));
                        FilterRevisionsDialog.this.endDateText.setData((Object)startDate);
                    }
                }
            }
        });
        selectEndDateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String end = null;
                if (FilterRevisionsDialog.this.endDateText.getText().trim().length() == 0) {
                    Date date = Calendar.getInstance().getTime();
                    end = FilterRevisionsDialog.this.formatDate(date);
                } else {
                    end = FilterRevisionsDialog.this.endDateText.getText();
                    if (FilterRevisionsDialog.this.parseDate(end) == null) {
                        return;
                    }
                }
                DateSelectionDialog dsd = new DateSelectionDialog(FilterRevisionsDialog.this.getShell(), end);
                if (dsd.open() == 0) {
                    Date startDate;
                    Date endDate = dsd.getDate();
                    FilterRevisionsDialog.this.endDateText.setText(FilterRevisionsDialog.this.formatDate(endDate));
                    FilterRevisionsDialog.this.endDateText.setData((Object)endDate);
                    if (FilterRevisionsDialog.this.startDateText.getText().trim().length() > 0 && !endDate.after(startDate = (Date)FilterRevisionsDialog.this.startDateText.getData())) {
                        FilterRevisionsDialog.this.startDateText.setText(FilterRevisionsDialog.this.formatDate(endDate));
                        FilterRevisionsDialog.this.startDateText.setData((Object)endDate);
                    }
                }
            }
        });
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource() == FilterRevisionsDialog.this.startLogButton) {
                    FilterRevisionsDialog.this.showLog(FilterRevisionsDialog.this.startRevisionText);
                } else {
                    FilterRevisionsDialog.this.showLog(FilterRevisionsDialog.this.endRevisionText);
                }
            }
        };
        this.startLogButton.addSelectionListener((SelectionListener)selectionListener);
        this.endLogButton.addSelectionListener((SelectionListener)selectionListener);
        FocusAdapter focusListener = new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ((Text)e.getSource()).selectAll();
            }

            public void focusLost(FocusEvent e) {
                ((Text)e.getSource()).setText(((Text)e.getSource()).getText());
            }
        };
        this.authors.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FilterRevisionsDialog.this.selectedAuthor = FilterRevisionsDialog.this.authors.getText();
                FilterRevisionsDialog.this.clearButton.setEnabled(FilterRevisionsDialog.this.isFiltering());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.startDateText.addFocusListener((FocusListener)focusListener);
        this.endDateText.addFocusListener((FocusListener)focusListener);
        this.clearButton = new Button(composite, 8);
        this.clearButton.setText(Messages.FilterRevisionsDialog_1);
        this.clearButton.setLayoutData((Object)new GridData(64));
        this.clearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilterRevisionsDialog.this.authors.setText(ALL_AUTHORS);
                FilterRevisionsDialog.this.selectedAuthor = ALL_AUTHORS;
                FilterRevisionsDialog.this.commentText.setText(Messages.FilterRevisionsDialog_2);
                FilterRevisionsDialog.this.startDateText.setText("");
                FilterRevisionsDialog.this.endDateText.setText("");
                FilterRevisionsDialog.this.startRevisionText.setText("");
                FilterRevisionsDialog.this.endRevisionText.setText("");
                FilterRevisionsDialog.this.clearButton.setEnabled(false);
            }
        });
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FilterRevisionsDialog.this.clearButton.setEnabled(FilterRevisionsDialog.this.isFiltering());
            }
        };
        this.commentText.addModifyListener(modifyListener);
        this.startDateText.addModifyListener(modifyListener);
        this.endDateText.addModifyListener(modifyListener);
        this.startRevisionText.addModifyListener(modifyListener);
        this.endRevisionText.addModifyListener(modifyListener);
        this.clearButton.setEnabled(this.isFiltering());
        return composite;
    }

    protected void okPressed() {
        Date tempStartDate = null;
        Date tempEndDate = null;
        if (this.startDateText.getText().trim().length() == 0) {
            this.startDate = null;
        } else {
            tempStartDate = this.parseDate(this.startDateText.getText());
            if (tempStartDate == null) {
                return;
            }
        }
        if (this.endDateText.getText().trim().length() == 0) {
            this.endDate = null;
        } else {
            tempEndDate = this.parseDate(this.endDateText.getText());
            if (tempEndDate == null) {
                return;
            }
        }
        if (tempStartDate != null && tempEndDate != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(tempEndDate);
            calendar.set(11, calendar.getActualMaximum(11));
            calendar.set(12, calendar.getActualMaximum(12));
            calendar.set(13, calendar.getActualMaximum(13));
            tempEndDate = calendar.getTime();
            if (!tempEndDate.after(tempStartDate)) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.FilterRevisionsDialog_dateSequenceErrorTitle, (String)Messages.FilterRevisionsDialog_dateSequenceErrorMessage);
                return;
            }
        }
        this.endDate = tempEndDate;
        this.startDate = tempStartDate;
        if (this.startRevisionText.getText().trim().length() > 0) {
            try {
                this.startRevision = (SVNRevision.Number)SVNRevision.getRevision((String)this.startRevisionText.getText().trim());
            }
            catch (ParseException parseException) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.FilterRevisionsDialog_revisionParseErrorTitle, (String)Messages.FilterRevisionsDialog_revisionParseErrorMessage);
                return;
            }
        } else {
            this.startRevision = null;
        }
        if (this.endRevisionText.getText().trim().length() > 0) {
            try {
                this.endRevision = (SVNRevision.Number)SVNRevision.getRevision((String)this.endRevisionText.getText().trim());
            }
            catch (ParseException parseException) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.FilterRevisionsDialog_revisionParseErrorTitle, (String)Messages.FilterRevisionsDialog_revisionParseErrorMessage);
                return;
            }
        } else {
            this.endRevision = null;
        }
        if (this.startRevision != null && this.endRevision != null && this.startRevision.getNumber() > this.endRevision.getNumber()) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.FilterRevisionsDialog_revisionSequenceErrorTitle, (String)Messages.FilterRevisionsDialog_revisionSequenceErrorMessage);
            return;
        }
        this.comment = this.commentText.getText().trim().length() > 0 ? this.commentText.getText() : null;
        if (this.selectedAuthor != null && this.selectedAuthor.equals(ALL_AUTHORS)) {
            this.selectedAuthor = null;
        }
        this.regExp = this.regExpButton.getSelection();
        super.okPressed();
    }

    private Date parseDate(String date) {
        try {
            return DateFormat.getDateInstance(3).parse(date);
        }
        catch (ParseException parseException) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.FilterRevisionsDialog_dateParseErrorTitle, (String)Messages.FilterRevisionsDialog_dateParseErrorMessage);
            return null;
        }
    }

    private void showLog(Text revisionText) {
        HistoryDialog dialog = new HistoryDialog(this.getShell(), this.remoteResource);
        if (dialog.open() == 1) {
            return;
        }
        ILogEntry[] selectedEntries = dialog.getSelectedLogEntries();
        if (selectedEntries.length == 0) {
            return;
        }
        revisionText.setText(Long.toString(selectedEntries[selectedEntries.length - 1].getRevision().getNumber()));
    }

    public boolean isHelpAvailable() {
        return false;
    }

    private String formatDate(Date date) {
        return DateFormat.getDateInstance(3).format(date);
    }

    public void setRemoteResource(ISVNRemoteResource remoteResource) {
        this.remoteResource = remoteResource;
    }

    public String getUser() {
        return this.selectedAuthor;
    }

    public String getComment() {
        return this.comment;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public SVNRevision.Number getStartRevision() {
        return this.startRevision;
    }

    public SVNRevision.Number getEndRevision() {
        return this.endRevision;
    }

    public boolean getRegExp() {
        return this.regExp;
    }

    private boolean isFiltering() {
        return this.commentText.getText().length() > 0 || this.startDateText.getText().length() > 0 || this.endDateText.getText().length() > 0 || this.startRevisionText.getText().length() > 0 || this.endRevisionText.getText().length() > 0 || !this.authors.getText().equals(ALL_AUTHORS);
    }
}

