/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.eclipse.builder;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import net.sf.jasperreports.eclipse.builder.JRDefinition;
import net.sf.jasperreports.eclipse.classpath.JavaProjectClassLoader;
import net.sf.jasperreports.eclipse.util.KeyValue;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.osgi.framework.Bundle;

public class CompatibilityManager {
    private static CompatibilityManager instance;
    private HashMap<String, String> jrpaths = new HashMap();
    private HashMap<KeyValue<String, IProject>, ClassLoader> cLoaders = new HashMap();
    public static final String PROP_JR_VERSIONS = "com.jaspersoft.studio.jr.runtime.versions";

    public static CompatibilityManager getInstance() {
        if (instance == null) {
            instance = new CompatibilityManager();
        }
        return instance;
    }

    private CompatibilityManager() {
        final IPreferenceStore pstore = CompatibilityManager.getStore();
        pstore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals(CompatibilityManager.PROP_JR_VERSIONS)) {
                    CompatibilityManager.this.jrpaths.clear();
                    CompatibilityManager.this.cLoaders.clear();
                    CompatibilityManager.this.readVersions(pstore);
                }
            }
        });
        this.readVersions(pstore);
    }

    protected void readVersions(IPreferenceStore pstore) {
        List<JRDefinition> defs = CompatibilityManager.getJRDefinitions(pstore);
        for (JRDefinition d : defs) {
            this.jrpaths.put(d.getVersion(), d.getResourceURL());
        }
    }

    public ClassLoader getClassLoader(String v, IProject javaProject) {
        KeyValue<String, IProject> key = new KeyValue<String, IProject>(v, javaProject);
        ClassLoader cl = this.cLoaders.get(key);
        if (cl == null) {
            File f = new File(this.jrpaths.get(key.key));
            Collection lf = FileUtils.listFiles((File)f, (String[])new String[]{"zip", "jar"}, (boolean)true);
            ArrayList<File> files = new ArrayList<File>();
            if (lf != null) {
                files.addAll(lf);
            }
            files.add(f);
            try {
                LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
                urls.addAll(Arrays.asList(FileUtils.toURLs((File[])files.toArray(new File[files.size()]))));
                try {
                    if (javaProject.hasNature("org.eclipse.jdt.core.javanature")) {
                        IJavaProject prj = JavaCore.create((IProject)javaProject);
                        prj.open((IProgressMonitor)new NullProgressMonitor());
                        urls.addAll(JavaProjectClassLoader.buildURLs(prj));
                    }
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                cl = URLClassLoader.newInstance(urls.toArray(new URL[urls.size()]));
                this.cLoaders.put(key, cl);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return cl;
    }

    private static List<JRDefinition> getJRDefinitions(IPreferenceStore pstore) {
        List<JRDefinition> list = new ArrayList<JRDefinition>();
        String versions = pstore.getString(PROP_JR_VERSIONS);
        if (versions != null && !versions.isEmpty()) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                list = (List)mapper.readValue(versions, (TypeReference)new TypeReference<List<JRDefinition>>(){});
            }
            catch (JsonParseException e) {
                e.printStackTrace();
            }
            catch (JsonMappingException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    private static IPreferenceStore getStore() {
        try {
            Bundle bundle = Platform.getBundle((String)"com.jaspersoft.studio");
            bundle.getBundleContext();
            String activator = (String)bundle.getHeaders().get("Bundle-Activator");
            Class activatorClass = bundle.loadClass(activator);
            Method method = activatorClass.getMethod("getInstance", new Class[0]);
            Plugin plugin = (Plugin)method.invoke(null, new Object[0]);
            method = plugin.getClass().getMethod("getPreferenceStore", new Class[0]);
            return (IPreferenceStore)method.invoke((Object)plugin, new Object[0]);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getJRPath(String version) {
        return this.jrpaths.get(version);
    }
}

